/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.script.groovy;

import groovy.lang.GroovyResourceLoader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.services.jcr.ext.resource.JcrURLConnection;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

class JcrGroovyResourceLoader
implements GroovyResourceLoader {
    private static final Log LOG = ExoLogger.getLogger(JcrGroovyResourceLoader.class);
    private int maxEntries = 512;
    private final Map<String, URL> resources = Collections.synchronizedMap(new LinkedHashMap<String, URL>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, URL> eldest) {
            return this.size() > JcrGroovyResourceLoader.this.maxEntries;
        }
    });
    private URL[] roots;

    public JcrGroovyResourceLoader(URL[] roots) throws MalformedURLException {
        this.roots = JcrGroovyResourceLoader.normalizeJcrURL(roots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL loadGroovySource(String classname) throws MalformedURLException {
        String filename = (classname.replace('.', '/') + ".groovy").intern();
        URL resource = null;
        String string = filename;
        synchronized (string) {
            resource = this.resources.get(filename);
            boolean inCache = resource != null;
            for (URL root : this.roots) {
                Object var13_12;
                if (resource == null) {
                    if ("jcr".equals(root.getProtocol())) {
                        String ref = root.getRef();
                        resource = new URL(root, "#" + ref + filename);
                    } else {
                        resource = new URL(root, filename);
                    }
                }
                URLConnection connection = null;
                try {
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Try to load resource from URL : " + resource));
                        }
                        connection = resource.openConnection();
                        resource.openStream().close();
                        var13_12 = null;
                        if (connection == null || resource == null || !"jcr".equals(resource.getProtocol())) break;
                        ((JcrURLConnection)connection).disconnect();
                        break;
                    }
                    catch (IOException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Can't open URL : " + resource));
                        }
                        resource = null;
                        var13_12 = null;
                        if (connection == null || resource == null || !"jcr".equals(resource.getProtocol())) continue;
                        ((JcrURLConnection)connection).disconnect();
                    }
                }
                catch (Throwable throwable) {
                    var13_12 = null;
                    if (connection != null && resource != null && "jcr".equals(resource.getProtocol())) {
                        ((JcrURLConnection)connection).disconnect();
                    }
                    throw throwable;
                }
            }
            if (resource != null) {
                this.resources.put(filename, resource);
            } else if (inCache) {
                this.resources.remove(filename);
            }
        }
        return resource;
    }

    private static URL[] normalizeJcrURL(URL[] src) throws MalformedURLException {
        URL[] res = new URL[src.length];
        for (int i = 0; i < src.length; ++i) {
            if ("jcr".equals(src[i].getProtocol())) {
                String ref = src[i].getRef();
                if (ref == null) {
                    ref = "/";
                } else if (ref.charAt(ref.length() - 1) != '/') {
                    ref = ref + "/";
                }
                res[i] = new URL(src[i], "#" + ref);
                continue;
            }
            res[i] = src[i];
        }
        return res;
    }
}

