/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.recovery;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.exoplatform.commons.utils.PrivilegedFileHelper;

public class AbstractFSAccess {
    public static final String DATA_DIR_NAME = "data";
    public static final String PREFIX_REMOVED_DATA = "---";
    public static final String PREFIX_CHAR = "-";
    public static final String REMOVED_SUFFIX = ".remove";
    protected static final int BUFFER_1KB = 1024;
    protected static final int BUFFER_8X = 8;
    protected static final int BUFFER_20X = 20;

    protected File getAsFile(InputStream is) throws IOException {
        int len;
        byte[] buf = new byte[20480];
        File tempFile = PrivilegedFileHelper.createTempFile((String)("" + System.currentTimeMillis()), (String)("" + System.nanoTime()));
        FileOutputStream fos = PrivilegedFileHelper.fileOutputStream((File)tempFile);
        while ((len = is.read(buf)) > 0) {
            fos.write(buf, 0, len);
        }
        fos.flush();
        fos.close();
        return tempFile;
    }

    protected File getAsFile(ObjectInputStream ois, long fileSize) throws IOException {
        int bufferSize = 8192;
        byte[] buf = new byte[bufferSize];
        File tempFile = PrivilegedFileHelper.createTempFile((String)("" + System.currentTimeMillis()), (String)("" + System.nanoTime()));
        FileOutputStream fos = PrivilegedFileHelper.fileOutputStream((File)tempFile);
        for (long readBytes = fileSize; readBytes > 0L; readBytes -= (long)bufferSize) {
            if (readBytes >= (long)bufferSize) {
                ois.readFully(buf);
                fos.write(buf);
                continue;
            }
            if (readBytes >= (long)bufferSize) continue;
            ois.readFully(buf, 0, (int)readBytes);
            fos.write(buf, 0, (int)readBytes);
        }
        fos.flush();
        fos.close();
        return tempFile;
    }
}

