/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.distribution.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionType;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataDistributionType
implements DataDistributionType {
    private static final Log LOG = ExoLogger.getLogger((String)"org.exoplatform.services.jcr.ext.distribution.impl.AbstractDataDistributionType");
    private static final String DEFAULT_NODE_TYPE = "nt:unstructured".intern();
    private final ConcurrentMap<String, Lock> locks = new ConcurrentHashMap<String, Lock>(64, 0.75f, 64);

    @Override
    public Node getDataNode(Node rootNode, String dataId) throws PathNotFoundException, RepositoryException {
        return rootNode.getNode(this.getRelativePath(dataId));
    }

    @Override
    public Node getOrCreateDataNode(Node rootNode, String dataId) throws RepositoryException {
        return this.getOrCreateDataNode(rootNode, dataId, null);
    }

    @Override
    public Node getOrCreateDataNode(Node rootNode, String dataId, String nodeType) throws RepositoryException {
        return this.getOrCreateDataNode(rootNode, dataId, nodeType, null);
    }

    @Override
    public Node getOrCreateDataNode(Node rootNode, String dataId, String nodeType, List<String> mixinTypes) throws RepositoryException {
        return this.getOrCreateDataNode(rootNode, dataId, nodeType, mixinTypes, null);
    }

    @Override
    public Node getOrCreateDataNode(Node rootNode, String dataId, String nodeType, List<String> mixinTypes, Map<String, String[]> permissions) throws RepositoryException {
        try {
            return this.getDataNode(rootNode, dataId);
        }
        catch (PathNotFoundException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
            Node node = rootNode;
            List<String> ancestors = this.getAncestors(dataId);
            int length = ancestors.size();
            for (int i = 0; i < length; ++i) {
                String nodeName = ancestors.get(i);
                try {
                    node = node.getNode(nodeName);
                    continue;
                }
                catch (PathNotFoundException e2) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("An exception occurred: " + e2.getMessage()));
                    }
                    node = this.createNode(node, nodeName, nodeType, mixinTypes, permissions, i == length - 1, true);
                }
            }
            return node;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataNode(Node rootNode, String dataId) throws RepositoryException {
        Lock lock = this.getLock(rootNode, this.getRelativePath(dataId));
        lock.lock();
        try {
            try {
                Node node = this.getDataNode(rootNode, dataId);
                Node parentNode = node.getParent();
                node.remove();
                parentNode.save();
            }
            catch (PathNotFoundException e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
                Object var7_8 = null;
                lock.unlock();
            }
            Object var7_7 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            lock.unlock();
            throw throwable;
        }
    }

    @Override
    public void migrate(Node rootNode) throws RepositoryException {
        throw new UnsupportedOperationException("The method is not supported");
    }

    @Override
    public void migrate(Node rootNode, String nodeType, List<String> mixinTypes, Map<String, String[]> permissions) throws RepositoryException {
        throw new UnsupportedOperationException("The method is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Node createNode(Node parentNode, String nodeName, String nodeType, List<String> mixinTypes, Map<String, String[]> permissions, boolean isLeaf, boolean callSave) throws RepositoryException {
        Throwable throwable2;
        Node node;
        Lock lock = this.getLock(parentNode, nodeName);
        lock.lock();
        try {
            node = parentNode.getNode(nodeName);
        }
        catch (PathNotFoundException e) {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
                boolean useParameters = !this.useParametersOnLeafOnly() || this.useParametersOnLeafOnly() && isLeaf;
                Node node2 = nodeType == null || nodeType.isEmpty() || !useParameters ? parentNode.addNode(nodeName, DEFAULT_NODE_TYPE) : parentNode.addNode(nodeName, nodeType);
                if (useParameters) {
                    if (permissions != null && !permissions.isEmpty()) {
                        if (node2.canAddMixin("exo:privilegeable")) {
                            node2.addMixin("exo:privilegeable");
                        }
                        ((ExtendedNode)node2).setPermissions(permissions);
                    }
                    if (mixinTypes != null) {
                        int length = mixinTypes.size();
                        for (int i = 0; i < length; ++i) {
                            String mixin = mixinTypes.get(i);
                            if (!node2.canAddMixin(mixin)) continue;
                            node2.addMixin(mixin);
                        }
                    }
                }
                if (callSave) {
                    parentNode.save();
                }
                Node node3 = node2;
                Object var15_13 = null;
                lock.unlock();
                return node3;
            }
            catch (Throwable throwable2) {
                Object var15_14 = null;
                lock.unlock();
            }
        }
        Object var15_12 = null;
        lock.unlock();
        return node;
        throw throwable2;
    }

    private String createFullPath(Node parentNode, String relativePath) throws RepositoryException {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(((RepositoryImpl)parentNode.getSession().getRepository()).getName());
        buffer.append('/');
        buffer.append(parentNode.getSession().getWorkspace().getName());
        String rootPath = parentNode.getPath();
        buffer.append(rootPath);
        if (!rootPath.endsWith("/")) {
            buffer.append('/');
        }
        buffer.append(relativePath);
        return buffer.toString();
    }

    private Lock getLock(Node parentNode, String relativePath) throws RepositoryException {
        String fullPath = this.createFullPath(parentNode, relativePath);
        Lock lock = (Lock)this.locks.get(fullPath);
        if (lock != null) {
            return lock;
        }
        lock = new InternalLock(fullPath);
        Lock prevLock = this.locks.putIfAbsent(fullPath, lock);
        if (prevLock != null) {
            lock = prevLock;
        }
        return lock;
    }

    protected String getRelativePath(String dataId) {
        StringBuilder buffer = new StringBuilder(256);
        List<String> ancestors = this.getAncestors(dataId);
        int length = ancestors.size();
        for (int i = 0; i < length; ++i) {
            buffer.append(ancestors.get(i));
            if (i == length - 1) continue;
            buffer.append('/');
        }
        return buffer.toString();
    }

    protected abstract List<String> getAncestors(String var1);

    protected abstract boolean useParametersOnLeafOnly();

    private class InternalLock
    extends ReentrantLock {
        private static final long serialVersionUID = -3362387346368015145L;
        private final String fullPath;

        public InternalLock(String fullPath) {
            this.fullPath = fullPath;
        }

        public void unlock() {
            if (!this.hasQueuedThreads()) {
                AbstractDataDistributionType.this.locks.remove(this.fullPath, this);
            }
            super.unlock();
        }
    }
}

