/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.exoplatform.commons.utils.PrivilegedFileHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangesFile
implements Comparable<ChangesFile> {
    private File file;
    private RandomAccessFile randomAccessFile;
    private final String systemId;
    private final long totalPacketCount;
    private long count = 0L;

    public ChangesFile(File f, String systemId, long totalPacketCount) {
        this.file = f;
        this.systemId = systemId;
        this.totalPacketCount = totalPacketCount;
    }

    public File getFile() {
        return this.file;
    }

    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public int compareTo(ChangesFile o) {
        return this.file.getName().compareTo(o.getFile().getName());
    }

    public synchronized void write(long offset, byte[] data) throws IOException {
        if (this.randomAccessFile == null) {
            this.randomAccessFile = PrivilegedFileHelper.randomAccessFile((File)this.file, (String)"rw");
        }
        this.randomAccessFile.seek(offset);
        this.randomAccessFile.write(data);
        ++this.count;
        if (this.isStored()) {
            this.randomAccessFile.close();
        }
    }

    public boolean isStored() {
        return this.count == this.totalPacketCount;
    }
}

