/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.resource.representation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NtResourceNodeRepresentation
implements NodeRepresentation {
    protected Node node;
    protected ArrayList<HierarchicalProperty> properties;

    public NtResourceNodeRepresentation(Node node) throws RepositoryException {
        this.node = node;
        this.properties = new ArrayList();
        PropertyIterator iter = node.getProperties();
        while (iter.hasNext()) {
            Property prop = iter.nextProperty();
            String name = prop.getName();
            if ("jcr:primaryType".equals(name) || "jcr:mixinTypes".equals(name) || "jcr:data".equals(name) || "jcr:uuid".equals(name)) continue;
            String ns = ((ExtendedSession)node.getSession()).getLocationFactory().parseJCRName(name).getNamespace();
            String value = prop.getString();
            this.properties.add(new HierarchicalProperty(name, value, ns));
        }
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public long getContentLenght() throws RepositoryException {
        return this.node.getProperty("jcr:data").getLength();
    }

    @Override
    public String getMediaType() throws RepositoryException {
        return this.node.getProperty("jcr:mimeType").getString();
    }

    @Override
    public long getLastModified() throws RepositoryException {
        return this.node.getProperty("jcr:lastModified").getLong();
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public HierarchicalProperty getProperty(String name) throws RepositoryException {
        for (HierarchicalProperty p : this.properties) {
            if (!p.getStringName().equals(name)) continue;
            return p;
        }
        return null;
    }

    @Override
    public Collection<HierarchicalProperty> getProperties(String name) throws RepositoryException {
        ArrayList<HierarchicalProperty> props = new ArrayList<HierarchicalProperty>();
        for (HierarchicalProperty p : this.properties) {
            if (!p.getStringName().equals(name)) continue;
            props.add(p);
        }
        return props;
    }

    @Override
    public Collection<String> getPropertyNames() throws RepositoryException {
        HashSet<String> props = new HashSet<String>();
        for (HierarchicalProperty p : this.properties) {
            props.add(p.getStringName());
        }
        return props;
    }

    @Override
    public InputStream getInputStream() throws IOException, RepositoryException {
        return this.node.getProperty("jcr:data").getStream();
    }

    @Override
    public void addProperties(Collection<HierarchicalProperty> properties) throws UnsupportedRepositoryOperationException {
        this.properties.addAll(properties);
    }

    @Override
    public void addProperty(HierarchicalProperty property) throws UnsupportedRepositoryOperationException {
        this.properties.add(property);
    }

    @Override
    public void removeProperty(String name) throws UnsupportedRepositoryOperationException {
        for (int i = 0; i < this.properties.size(); ++i) {
            if (!this.properties.get(i).getStringName().equals(name)) continue;
            this.properties.remove(i);
        }
    }
}

