/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl.rdbms;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.impl.AbstractFullBackupJob;
import org.exoplatform.services.jcr.ext.backup.impl.FileNameProducer;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.Backupable;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FullBackupJob
extends AbstractFullBackupJob {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.ext.FullBackupJob");

    protected URL createStorage() throws FileNotFoundException, IOException {
        FileNameProducer fnp = new FileNameProducer(this.config.getRepository(), this.config.getWorkspace(), PrivilegedFileHelper.getAbsolutePath((File)this.config.getBackupDir()), this.timeStamp, true, true);
        return new URL("file:" + PrivilegedFileHelper.getAbsolutePath((File)fnp.getNextFile()));
    }

    public void init(ManageableRepository repository, String workspaceName, BackupConfig config, Calendar timeStamp) {
        this.repository = repository;
        this.workspaceName = workspaceName;
        this.config = config;
        this.timeStamp = timeStamp;
        try {
            this.url = this.createStorage();
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"Full backup initialization failed ", (Throwable)e);
            this.notifyError("Full backup initialization failed ", e);
        }
        catch (IOException e) {
            LOG.error((Object)"Full backup initialization failed ", (Throwable)e);
            this.notifyError("Full backup initialization failed ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block11: {
            this.notifyListeners();
            this.repository.getWorkspaceContainer(this.workspaceName).setState(3);
            List backupableComponents = this.repository.getWorkspaceContainer(this.workspaceName).getComponentInstancesOfType(Backupable.class);
            for (Backupable component : backupableComponents) {
                component.backup(new File(this.getStorageURL().getFile()));
            }
            Object var5_6 = null;
            try {
                this.repository.getWorkspaceContainer(this.workspaceName).setState(1);
            }
            catch (RepositoryException e2) {
                LOG.error((Object)("Full backup failed " + this.getStorageURL().getPath()), (Throwable)e2);
                this.notifyError("Full backup failed", e2);
            }
            break block11;
            {
                catch (BackupException e) {
                    LOG.error((Object)("Full backup failed " + this.getStorageURL().getPath()), (Throwable)e);
                    this.notifyError("Full backup failed", e);
                    Object var5_7 = null;
                    try {
                        this.repository.getWorkspaceContainer(this.workspaceName).setState(1);
                    }
                    catch (RepositoryException e2) {
                        LOG.error((Object)("Full backup failed " + this.getStorageURL().getPath()), (Throwable)e2);
                        this.notifyError("Full backup failed", e2);
                    }
                    break block11;
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Full backup failed " + this.getStorageURL().getPath()), (Throwable)e);
                    this.notifyError("Full backup failed", e);
                    Object var5_8 = null;
                    try {
                        this.repository.getWorkspaceContainer(this.workspaceName).setState(1);
                    }
                    catch (RepositoryException e2) {
                        LOG.error((Object)("Full backup failed " + this.getStorageURL().getPath()), (Throwable)e2);
                        this.notifyError("Full backup failed", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                try {
                    this.repository.getWorkspaceContainer(this.workspaceName).setState(1);
                }
                catch (RepositoryException e2) {
                    LOG.error((Object)("Full backup failed " + this.getStorageURL().getPath()), (Throwable)e2);
                    this.notifyError("Full backup failed", e2);
                }
                throw throwable;
            }
        }
        this.state = 4;
        this.notifyListeners();
    }

    public void stop() {
        LOG.info((Object)("Stop requested " + this.getStorageURL().getPath()));
    }
}

