/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp.command;

import java.io.IOException;
import org.exoplatform.services.ftp.command.FtpCommandImpl;
import org.exoplatform.services.ftp.data.FtpDataTransiverImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CmdPort
extends FtpCommandImpl {
    private static Log log = ExoLogger.getLogger((String)"jcr.ftpservice.CmdPort");

    public CmdPort() {
        this.commandName = "PORT";
    }

    public void run(String[] params) throws IOException {
        if (params.length < 2) {
            this.reply(String.format("500 %s: command requires a parameter", "PORT"));
            return;
        }
        String host = "";
        int port = 0;
        try {
            String[] ports = params[1].split(",");
            for (int i = 0; i < 3; ++i) {
                host = host + ports[i] + ".";
            }
            host = host + ports[3];
            port = new Integer(ports[4]) * 256 + new Integer(ports[5]);
        }
        catch (Exception exc) {
            this.reply(String.format("500 Illegal %s command", "PORT"));
            return;
        }
        try {
            FtpDataTransiverImpl dataTransiver = new FtpDataTransiverImpl(host, port, this.clientSession().getFtpServer().getConfiguration(), this.clientSession());
            this.clientSession().setDataTransiver(dataTransiver);
            this.reply(String.format("200 %s", "Port command success"));
            return;
        }
        catch (Exception exc) {
            log.info((Object)("Unhandlede exception. " + exc.getMessage()), (Throwable)exc);
            this.reply(String.format("500 Illegal %s command", "PORT"));
            return;
        }
    }
}

