/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp;

import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.command.impl.CommandService;
import org.exoplatform.services.ftp.FtpServer;
import org.exoplatform.services.ftp.FtpServerImpl;
import org.exoplatform.services.ftp.FtpService;
import org.exoplatform.services.ftp.config.FtpConfig;
import org.exoplatform.services.ftp.config.FtpConfigImpl;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class FtpServiceImpl
implements FtpService,
Startable {
    private Log log = ExoLogger.getLogger((String)"exo.jcr.component.ftp.FtpServiceImpl");
    private CommandService commandService = null;
    private RepositoryService repositoryService = null;
    private FtpServer ftpServer = null;
    private FtpConfig config = null;

    public FtpServiceImpl(InitParams params, CommandService commandService, RepositoryService repositoryService, ExoContainerContext context) {
        this.commandService = commandService;
        this.repositoryService = repositoryService;
        this.config = new FtpConfigImpl(context, params);
    }

    public void start() {
        this.log.info((Object)"Start service.");
        try {
            this.ftpServer = new FtpServerImpl(this.config, this.commandService, this.repositoryService.getRepository());
            this.ftpServer.start();
        }
        catch (Exception e) {
            this.log.info((Object)("Unhandled exception. could not get repository!!!! " + e.getMessage()), (Throwable)e);
        }
    }

    public void stop() {
        this.log.info((Object)"Stopping...");
        if (this.ftpServer != null) {
            this.ftpServer.stop();
        } else {
            this.log.warn((Object)"Service isn't started");
        }
    }
}

