/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp.data;

import org.exoplatform.services.ftp.client.FtpClientSession;
import org.exoplatform.services.ftp.config.FtpConfig;
import org.exoplatform.services.ftp.data.FtpDataChannelManager;
import org.exoplatform.services.ftp.data.FtpDataTransiver;
import org.exoplatform.services.ftp.data.FtpDataTransiverImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FtpDataChannelManagerImpl
implements FtpDataChannelManager {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.ftp.FtpDataChannelManagerImpl");
    private FtpConfig configuration;
    private int dataChannels;
    protected FtpDataTransiver[] channels;

    public FtpDataChannelManagerImpl(FtpConfig configuration) {
        this.configuration = configuration;
        this.dataChannels = configuration.getDataMaxPort() - configuration.getDataMinPort() + 1;
        this.channels = new FtpDataTransiver[this.dataChannels];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FtpDataTransiver getDataTransiver(FtpClientSession clientSession) {
        FtpDataChannelManagerImpl ftpDataChannelManagerImpl = this;
        synchronized (ftpDataChannelManagerImpl) {
            for (int i = 0; i < this.channels.length; ++i) {
                if (this.channels[i] != null) continue;
                try {
                    FtpDataTransiverImpl transiver = new FtpDataTransiverImpl(this, this.configuration.getDataMinPort() + i, this.configuration, clientSession);
                    this.channels[i] = transiver;
                    return transiver;
                }
                catch (Exception exc) {
                    log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeDataTransiver(FtpDataTransiver dataTransiver) {
        FtpDataChannelManagerImpl ftpDataChannelManagerImpl = this;
        synchronized (ftpDataChannelManagerImpl) {
            int dataPort = dataTransiver.getDataPort();
            int index = dataPort - this.configuration.getDataMinPort();
            this.channels[index] = null;
        }
    }
}

