/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.test;

import java.security.Permission;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class TestSecurityManager
extends SecurityManager {
    private static final Log LOG = ExoLogger.getLogger((String)"org.exoplatform.commons.test.TestSecurityManager");

    public void checkPermission(Permission perm) {
        try {
            super.checkPermission(perm);
        }
        catch (SecurityException se) {
            boolean srcCode = false;
            boolean testCode = false;
            for (Throwable e = se; e != null; e = e.getCause()) {
                StackTraceElement[] traceElements = e.getStackTrace();
                for (int i = 0; i < traceElements.length; ++i) {
                    String className = traceElements[i].getClassName();
                    String fileName = traceElements[i].getFileName();
                    if (className.startsWith("org.exoplatform")) {
                        if (fileName.equals("BaseStandaloneTest.java")) {
                            return;
                        }
                        if (fileName.equals("RequestHandlerImpl.java")) {
                            return;
                        }
                        if (fileName.startsWith("Test") || fileName.endsWith("Test.java") || fileName.endsWith("TestBase.java") || fileName.equals("Probe.java") || fileName.equals("ExportBase.java")) {
                            testCode = true;
                            continue;
                        }
                        srcCode = true;
                        continue;
                    }
                    if (className.startsWith("org.apache.jackrabbit.test")) {
                        if (fileName.equals("RepositoryHelper.java")) {
                            return;
                        }
                        if (!fileName.endsWith("Test.java") && !fileName.equals("JCRTestResult.java")) continue;
                        testCode = true;
                        continue;
                    }
                    if (!className.startsWith("org.slf4j.impl.Log4jLoggerFactory") && !className.startsWith("com.arjuna.ats.jta.logging.jtaLogger")) continue;
                    return;
                }
            }
            if (!srcCode && testCode) {
                return;
            }
            throw se;
        }
    }
}

