/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.test;

import java.security.Permission;

public class TestSecurityManager
extends SecurityManager {
    public void checkPermission(Permission perm) {
        try {
            super.checkPermission(perm);
        }
        catch (SecurityException se) {
            boolean srcCode = false;
            boolean testCode = false;
            for (Throwable e = se; e != null; e = e.getCause()) {
                StackTraceElement[] traceElements = e.getStackTrace();
                for (int i = 0; i < traceElements.length; ++i) {
                    String className = traceElements[i].getClassName();
                    String fileName = traceElements[i].getFileName();
                    if (className.startsWith("org.exoplatform")) {
                        if (fileName.startsWith("Test") || fileName.endsWith("Test.java") || fileName.endsWith("TestBase.java") || fileName.endsWith("TestCase.java") || fileName.equals("Probe.java") || fileName.equals("ExportBase.java") || fileName.equals("AbstractTestContainer.java") || fileName.equals("ContainerBuilder.java") || fileName.equals("WorkspaceStorageCacheBaseCase.java") || fileName.equals("ExoRepositoryStub.java")) {
                            testCode = true;
                            continue;
                        }
                        srcCode = true;
                        continue;
                    }
                    if (!className.startsWith("org.apache.jackrabbit.test") || !fileName.endsWith("Test.java") && !fileName.equals("JCRTestResult.java") && !fileName.equals("RepositoryHelper.java") && !fileName.equals("RepositoryStub.java")) continue;
                    testCode = true;
                }
            }
            if (!srcCode && testCode) {
                return;
            }
            throw se;
        }
    }
}

