/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.test;

import java.io.IOException;
import java.io.InputStream;
import java.security.Permission;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSecurityManager
extends SecurityManager {
    private final Map<String, Set<String>> excludes = this.getExcludes();

    @Override
    public void checkPermission(Permission perm) {
        try {
            super.checkPermission(perm);
        }
        catch (SecurityException se) {
            boolean srcCode = false;
            boolean testCode = false;
            for (Throwable e = se; e != null; e = e.getCause()) {
                StackTraceElement[] traceElements = e.getStackTrace();
                for (int i = 0; i < traceElements.length; ++i) {
                    String className = traceElements[i].getClassName();
                    String fileName = traceElements[i].getFileName();
                    String methodName = traceElements[i].getMethodName();
                    if (this.excludes != null && i - 1 >= 0 && this.excludes.containsKey(className + "." + methodName) && this.excludes.get(className + "." + methodName).contains(traceElements[i - 1].getMethodName())) {
                        return;
                    }
                    if (className.startsWith("org.exoplatform")) {
                        if (fileName.startsWith("Test") || fileName.endsWith("Test.java") || fileName.endsWith("TestBase.java") || fileName.endsWith("TestCase.java") || fileName.equals("Probe.java") || fileName.equals("ExportBase.java") || fileName.equals("AbstractTestContainer.java") || fileName.equals("ContainerBuilder.java") || fileName.equals("WorkspaceStorageCacheBaseCase.java") || fileName.equals("ExoRepositoryStub.java") || fileName.equals("CloseableDataSource.java")) {
                            testCode = true;
                            continue;
                        }
                        srcCode = true;
                        continue;
                    }
                    if (!className.startsWith("org.apache.jackrabbit.test") || !fileName.endsWith("Test.java") && !fileName.equals("JCRTestResult.java") && !fileName.equals("RepositoryHelper.java") && !fileName.equals("RepositoryStub.java")) continue;
                    testCode = true;
                }
            }
            if (!srcCode && testCode) {
                return;
            }
            throw se;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<String>> getExcludes() {
        InputStream is = null;
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream("tsm-excludes.properties");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (is != null) {
            try {
                System.out.println("A file 'tsm-excludes.properties' has been found");
                Properties p = new Properties();
                p.load(is);
                HashMap<String, Set<String>> excludes = new HashMap<String, Set<String>>();
                for (Object key : p.keySet()) {
                    String[] values = p.getProperty((String)key).split(",");
                    excludes.put((String)key, new HashSet<String>(Arrays.asList(values)));
                }
                HashMap<String, Set<String>> hashMap = excludes;
                return hashMap;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

