/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerThreadFactory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerService {
    private final Executor executor;
    private final Map<String, List<Listener>> listeners_ = new HashMap<String, List<Listener>>();
    private static final Log log = ExoLogger.getLogger((String)"exo.kernel.component.common.ListenerService");

    public ListenerService() {
        this.executor = Executors.newFixedThreadPool(1, new ListenerThreadFactory());
    }

    public ListenerService(InitialContextInitializer initializer, InitParams params) {
        int poolSize = 1;
        if (params != null && params.getValueParam("asynchPoolSize") != null) {
            poolSize = Integer.parseInt(params.getValueParam("asynchPoolSize").getValue());
        }
        this.executor = Executors.newFixedThreadPool(poolSize, new ListenerThreadFactory());
    }

    public void addListener(Listener listener) {
        this.addListener(listener.getName(), listener);
    }

    public void addListener(String eventName, Listener listener) {
        Class<?> listenerClass = ((Object)((Object)listener)).getClass();
        do {
            if (!listenerClass.isAnnotationPresent(Asynchronous.class)) continue;
            listener = new AsynchronousListener(listener);
            break;
        } while ((listenerClass = listenerClass.getSuperclass()) != null);
        List<Listener> list = this.listeners_.get(eventName);
        if (list == null) {
            list = new ArrayList<Listener>();
            this.listeners_.put(eventName, list);
        }
        list.add(listener);
    }

    public final <S, D> void broadcast(String name, S source, D data) throws Exception {
        List<Listener> list = this.listeners_.get(name);
        if (list == null) {
            return;
        }
        for (Listener listener : list) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("broadcasting event " + name + " on " + listener.getName()));
            }
            try {
                listener.onEvent(new Event<S, D>(name, source, data));
            }
            catch (Exception e) {
                log.error((Object)("Exception on broadcasting events occures: " + e.getMessage()), e.getCause());
                log.info((Object)"Exception occures but keep broadcast events.");
            }
        }
    }

    public final <T extends Event> void broadcast(T event) throws Exception {
        List<Listener> list = this.listeners_.get(event.getEventName());
        if (list == null) {
            return;
        }
        for (Listener listener : list) {
            try {
                listener.onEvent(event);
            }
            catch (Exception e) {
                log.error((Object)("Exception on broadcasting events occures: " + e.getMessage()), e.getCause());
                log.info((Object)"Exception occures but keep broadcast events.");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RunListener<S, D>
    implements Runnable {
        private Listener<S, D> listener;
        private Event<S, D> event;

        public RunListener(Listener<S, D> listener, Event<S, D> event) {
            this.listener = listener;
            this.event = event;
        }

        @Override
        public void run() {
            try {
                this.listener.onEvent(this.event);
            }
            catch (Exception e) {
                log.error((Object)("Exception on broadcasting events occures: " + e.getMessage()), e.getCause());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AsynchronousListener<S, D>
    extends Listener<S, D> {
        private Listener<S, D> listener;

        public AsynchronousListener(Listener<S, D> listener) {
            this.listener = listener;
        }

        public String getName() {
            return this.listener.getName();
        }

        public void setName(String s) {
            this.listener.setName(s);
        }

        public String getDescription() {
            return this.listener.getDescription();
        }

        public void setDescription(String s) {
            this.listener.setDescription(s);
        }

        @Override
        public void onEvent(Event<S, D> event) throws Exception {
            ListenerService.this.executor.execute(new RunListener<S, D>(this.listener, event));
        }
    }
}

