/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.scheduler.impl;

import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;

public class JobEnvironmentConfigListener
implements JobListener,
ComponentPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.common.JobEnvironmentConfigListener");
    static final String NAME = "JobContextConfigListener";

    public void jobToBeExecuted(JobExecutionContext context) {
        String containerName = JobEnvironmentConfigListener.extractContainerName(context);
        ExoContainer container = null;
        if (containerName != null) {
            if (containerName.equals("$Standalone")) {
                container = ExoContainerContext.getTopContainer();
            } else {
                RootContainer rootContainer = RootContainer.getInstance();
                container = (ExoContainer)rootContainer.getComponentInstance((Object)containerName);
            }
        }
        if (container != null) {
            ExoContainerContext.setCurrentContainer(container);
            RequestLifeCycle.begin((ExoContainer)container);
            List components = container.getComponentInstancesOfType(ComponentRequestLifecycle.class);
            for (ComponentRequestLifecycle component : components) {
                try {
                    component.startRequest(container);
                }
                catch (Throwable e) {
                    LOG.warn((Object)("Error starting request of " + component), e);
                }
            }
        }
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException exception) {
        String containerName = JobEnvironmentConfigListener.extractContainerName(context);
        ExoContainer container = null;
        if (containerName != null) {
            if (containerName.equals("$Standalone")) {
                container = ExoContainerContext.getTopContainer();
            } else {
                RootContainer rootContainer = RootContainer.getInstance();
                container = (ExoContainer)rootContainer.getComponentInstance((Object)containerName);
            }
        }
        if (container != null) {
            List components = container.getComponentInstancesOfType(ComponentRequestLifecycle.class);
            for (ComponentRequestLifecycle component : components) {
                try {
                    component.endRequest(container);
                }
                catch (Throwable e) {
                    LOG.warn((Object)("Error ending request of " + component), e);
                }
            }
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer(null);
        }
    }

    public String getName() {
        return NAME;
    }

    public void setName(String s) {
    }

    public String getDescription() {
        return "This JobListener is used to setup the eXo environment properly";
    }

    public void setDescription(String s) {
    }

    private static String extractContainerName(JobExecutionContext context) {
        String group = context.getJobDetail().getKey().getGroup();
        if (group == null || (group = group.trim()).length() == 0) {
            return null;
        }
        int index = group.indexOf(58);
        return index == -1 ? group : group.substring(0, index);
    }
}

