/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.scheduler.impl;

import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.JobExecutionContext;
import org.quartz.Trigger;
import org.quartz.listeners.TriggerListenerSupport;

public class TenantStartingTriggerListener
extends TriggerListenerSupport
implements ComponentPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.common.JobSchedulerServiceImpl");
    public static final String TENANTTRIGGER_NAME = "TenantStartingTriggerListener";
    private String tenantName;
    private String description;

    public TenantStartingTriggerListener(String tenantName) {
        this.tenantName = tenantName;
    }

    public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
        String group = context.getJobDetail().getKey().getGroup();
        if (group.contains(this.tenantName)) {
            LOG.debug("Veto job execution of {} ", new Object[]{context.getJobDetail().getKey().getGroup()});
            return true;
        }
        return false;
    }

    public String getName() {
        return TenantStartingTriggerListener.createName(this.tenantName);
    }

    public void setName(String s) {
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String s) {
        this.description = s;
    }

    public static String createName(String tenantName) {
        return tenantName + ":" + TENANTTRIGGER_NAME;
    }
}

