/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.infinispan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.exoplatform.services.cache.CacheInfo;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheListenerContext;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;

public abstract class AbstractExoCache<K extends Serializable, V>
implements ExoCache<K, V> {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.ext.cache.impl.infinispan.v5.AbstractExoCache");
    private final AtomicInteger hits = new AtomicInteger(0);
    private final AtomicInteger misses = new AtomicInteger(0);
    private String label;
    private String name;
    private boolean distributed;
    private boolean replicated;
    private boolean logEnabled;
    private final CopyOnWriteArrayList<ListenerContext<K, V>> listeners;
    protected final AdvancedCache<K, V> cache;

    public AbstractExoCache(ExoCacheConfig config, Cache<K, V> cache) {
        this.cache = cache.getAdvancedCache();
        this.listeners = new CopyOnWriteArrayList();
        this.setDistributed(config.isDistributed());
        this.setLabel(config.getLabel());
        this.setName(config.getName());
        this.setLogEnabled(config.isLogEnabled());
        this.setReplicated(config.isRepicated());
        cache.addListener((Object)new CacheEventListener());
    }

    public void addCacheListener(CacheListener<? super K, ? super V> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(new ListenerContext<K, V>(listener, this));
    }

    public void clearCache() {
        this.cache.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).clear();
        this.onClearCache();
    }

    public V get(Serializable name) {
        if (name == null) {
            return null;
        }
        Object result = this.cache.get((Object)name);
        if (result == null) {
            this.misses.incrementAndGet();
        } else {
            this.hits.incrementAndGet();
        }
        this.onGet(name, result);
        return (V)result;
    }

    public int getCacheHit() {
        return this.hits.get();
    }

    public int getCacheMiss() {
        return this.misses.get();
    }

    public int getCacheSize() {
        return this.cache.size();
    }

    public List<V> getCachedObjects() {
        Collection values = this.cache.values();
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList(values);
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDistributed() {
        return this.distributed;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public boolean isReplicated() {
        return this.replicated;
    }

    public void put(K key, V value) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("No null cache key accepted");
        }
        this.putOnly(key, value);
        this.onPut(key, value);
    }

    protected void putOnly(K key, V value) {
        this.cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).put(key, value);
    }

    public void putMap(Map<? extends K, ? extends V> objs) throws NullPointerException, IllegalArgumentException {
        if (objs == null) {
            throw new NullPointerException("No null map accepted");
        }
        for (Serializable serializable : objs.keySet()) {
            if (serializable != null) continue;
            throw new IllegalArgumentException("No null cache key accepted");
        }
        this.cache.startBatch();
        try {
            for (Map.Entry entry : objs.entrySet()) {
                this.putOnly((Serializable)entry.getKey(), entry.getValue());
            }
            this.cache.endBatch(true);
            for (Map.Entry entry : objs.entrySet()) {
                this.onPut((Serializable)entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            this.cache.endBatch(false);
            LOG.warn((Object)"An error occurs while executing the putMap method", (Throwable)e);
        }
    }

    public V remove(Serializable name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("No null cache key accepted");
        }
        Object result = this.cache.remove((Object)name);
        this.onRemove(name, result);
        return (V)result;
    }

    public List<V> removeCachedObjects() {
        List<V> list = this.getCachedObjects();
        this.clearCache();
        return list;
    }

    public void select(CachedObjectSelector<? super K, ? super V> selector) throws Exception {
        if (selector == null) {
            throw new IllegalArgumentException("No null selector");
        }
        for (Serializable key : this.cache.keySet()) {
            if (key == null) continue;
            final Object value = this.cache.withFlags(new Flag[]{Flag.SKIP_LOCKING}).get((Object)key);
            ObjectCacheInfo info = new ObjectCacheInfo<V>(){

                public V get() {
                    return value;
                }

                public long getExpireTime() {
                    return -1L;
                }
            };
            if (!selector.select(key, info)) continue;
            selector.onSelect((ExoCache)this, key, info);
        }
    }

    public void setDistributed(boolean distributed) {
        this.distributed = distributed;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReplicated(boolean replicated) {
        this.replicated = replicated;
    }

    void onExpire(K key, V obj) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (ListenerContext<K, V> context : this.listeners) {
            try {
                context.onExpire(key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onRemove(K key, V obj) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (ListenerContext<K, V> context : this.listeners) {
            try {
                context.onRemove(key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onPut(K key, V obj) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (ListenerContext<K, V> context : this.listeners) {
            try {
                context.onPut(key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onGet(K key, V obj) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (ListenerContext<K, V> context : this.listeners) {
            try {
                context.onGet(key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onClearCache() {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (ListenerContext<K, V> context : this.listeners) {
            try {
                context.onClearCache();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    private static class ListenerContext<K extends Serializable, V>
    implements CacheListenerContext,
    CacheInfo {
        private final ExoCache<K, V> cache;
        final CacheListener<? super K, ? super V> listener;

        public ListenerContext(CacheListener<? super K, ? super V> listener, ExoCache<K, V> cache) {
            this.listener = listener;
            this.cache = cache;
        }

        public CacheInfo getCacheInfo() {
            return this;
        }

        public String getName() {
            return this.cache.getName();
        }

        public int getMaxSize() {
            return this.cache.getMaxSize();
        }

        public long getLiveTime() {
            return this.cache.getLiveTime();
        }

        public int getSize() {
            return this.cache.getCacheSize();
        }

        void onExpire(K key, V obj) throws Exception {
            this.listener.onExpire((CacheListenerContext)this, key, obj);
        }

        void onRemove(K key, V obj) throws Exception {
            this.listener.onRemove((CacheListenerContext)this, key, obj);
        }

        void onPut(K key, V obj) throws Exception {
            this.listener.onPut((CacheListenerContext)this, key, obj);
        }

        void onGet(K key, V obj) throws Exception {
            this.listener.onGet((CacheListenerContext)this, key, obj);
        }

        void onClearCache() throws Exception {
            this.listener.onClearCache((CacheListenerContext)this);
        }
    }

    @Listener
    public class CacheEventListener {
        @CacheEntriesEvicted
        public void cacheEntryEvicted(CacheEntriesEvictedEvent<K, V> evt) {
            if (evt.isPre()) {
                for (Map.Entry entry : evt.getEntries().entrySet()) {
                    AbstractExoCache.this.onExpire((Serializable)entry.getKey(), entry.getValue());
                }
            }
        }

        @CacheEntryRemoved
        public void cacheEntryRemoved(CacheEntryRemovedEvent<K, V> evt) {
            if (evt.isPre() && !evt.isOriginLocal()) {
                Serializable key = (Serializable)evt.getKey();
                Object value = evt.getValue();
                AbstractExoCache.this.onRemove(key, value);
            }
        }

        @CacheEntryModified
        public void cacheEntryModified(CacheEntryModifiedEvent<K, V> evt) {
            if (!evt.isOriginLocal() && !evt.isPre()) {
                Serializable key = (Serializable)evt.getKey();
                Object value = evt.getValue();
                AbstractExoCache.this.onPut(key, value);
            }
        }
    }
}

