/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.memcached;

import java.io.Serializable;
import net.spy.memcached.MemcachedClient;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.cache.impl.memcached.MCExoCache;
import org.exoplatform.services.cache.impl.memcached.MCExoCacheConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MCExoCacheCreator {
    private final long defaultExpirationTimeout;

    public MCExoCacheCreator(long defaultExpirationTimeout) {
        this.defaultExpirationTimeout = defaultExpirationTimeout;
    }

    public ExoCache<Serializable, Object> create(ExoContainerContext ctx, ExoCacheConfig config, MemcachedClient cache) throws ExoCacheInitException {
        if (config instanceof MCExoCacheConfig) {
            MCExoCacheConfig eaConfig = (MCExoCacheConfig)config;
            return this.create(ctx, config, cache, eaConfig.getExpirationTimeout());
        }
        long period = config.getLiveTime();
        return this.create(ctx, config, cache, period > 0L ? period * 1000L : this.defaultExpirationTimeout);
    }

    private ExoCache<Serializable, Object> create(ExoContainerContext ctx, ExoCacheConfig config, MemcachedClient cache, long expirationTimeout) throws ExoCacheInitException {
        return new MCExoCache<Serializable, Object>(ctx, config, cache, expirationTimeout);
    }
}

