/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.memcached;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.BinaryConnectionFactory;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.MemcachedClient;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheFactory;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.cache.impl.memcached.ConnectionFactoryCreator;
import org.exoplatform.services.cache.impl.memcached.MCExoCacheCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class ExoCacheFactoryImpl
implements ExoCacheFactory,
Startable {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.ext.cache.impl.memcached.v1.ExoCacheFactoryImpl");
    public static final String CONNECTION_FACTORY_CREATOR = "connection.factory.creator";
    public static final String MEMCACHED_LOCATIONS = "memcached.locations";
    public static final String DEFAULT_EXPIRATION_TIMEOUT = "default.expiration.timeout";
    public static final long DEFAULT_EXPIRATION_TIMEOUT_VALUE = 900000L;
    private final ExoContainerContext ctx;
    private final MemcachedClient cache;
    private final MCExoCacheCreator cacheCreator;

    public ExoCacheFactoryImpl(ExoContainerContext ctx, final InitParams params) throws IOException {
        ValueParam locations;
        this.ctx = ctx;
        if (params == null || (locations = params.getValueParam(MEMCACHED_LOCATIONS)) == null || locations.getValue() == null || locations.getValue().isEmpty()) {
            throw new IllegalArgumentException("The parameter 'memcached.locations' cannot be null or empty");
        }
        final List isaLocations = AddrUtil.getAddresses((String)locations.getValue());
        this.cache = (MemcachedClient)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<MemcachedClient>(){

            @Override
            public MemcachedClient run() throws IOException {
                ObjectParameter op = params.getObjectParam(ExoCacheFactoryImpl.CONNECTION_FACTORY_CREATOR);
                if (op == null || op.getObject() == null) {
                    LOG.debug((Object)"No connection factory creator has been defined, so we will use the BinaryConnectionFactory by default");
                    return new MemcachedClient((ConnectionFactory)new BinaryConnectionFactory(), isaLocations);
                }
                if (!(op.getObject() instanceof ConnectionFactoryCreator)) {
                    throw new IllegalArgumentException("The parameter 'connection.factory.creator' must refer to a ConnectionFactoryCreator.");
                }
                return new MemcachedClient(((ConnectionFactoryCreator)op.getObject()).create(), isaLocations);
            }
        });
        ValueParam vp = params.getValueParam(DEFAULT_EXPIRATION_TIMEOUT);
        if (vp == null || vp.getValue() == null || vp.getValue().isEmpty()) {
            LOG.debug((Object)"No default expiration timeout has been defined");
            this.cacheCreator = new MCExoCacheCreator(900000L);
        } else {
            this.cacheCreator = new MCExoCacheCreator(Long.parseLong(vp.getValue()));
        }
    }

    public ExoCache createCache(ExoCacheConfig config) throws ExoCacheInitException {
        return this.cacheCreator.create(this.ctx, config, this.cache);
    }

    public void start() {
    }

    public void stop() {
        this.cache.shutdown();
    }
}

