/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.weld;

import java.util.List;
import javax.enterprise.inject.spi.Extension;
import org.exoplatform.container.weld.WeldContainerHelper;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicWeldContainerHelper
implements WeldContainerHelper {
    private static final String INCLUDE_PARAM_NAME = "include";
    private static final String EXCLUDE_PARAM_NAME = "exclude";
    private final String[] includes;
    private final String[] excludes;

    public BasicWeldContainerHelper(InitParams p) {
        int i;
        ValuesParam params;
        ValuesParam valuesParam = params = p == null ? null : p.getValuesParam(INCLUDE_PARAM_NAME);
        if (params != null && params.getValues().size() > 0) {
            this.includes = new String[params.getValues().size()];
            i = 0;
            for (String value : params.getValues()) {
                this.includes[i++] = value;
            }
        } else {
            this.includes = null;
        }
        ValuesParam valuesParam2 = params = p == null ? null : p.getValuesParam(EXCLUDE_PARAM_NAME);
        if (params != null && params.getValues().size() > 0) {
            this.excludes = new String[params.getValues().size()];
            i = 0;
            for (String value : params.getValues()) {
                this.excludes[i++] = value;
            }
        } else {
            this.excludes = null;
        }
        if (this.includes == null && this.excludes == null) {
            throw new IllegalArgumentException("The values parameter include and exclude cannot be both empty, please set at least one value to one of them.");
        }
    }

    @Override
    public List<Extension> getExtensions() {
        return null;
    }

    @Override
    public boolean isIncluded(Class<?> clazz) {
        int i;
        int length;
        boolean result;
        String name = clazz.getName();
        if (this.includes != null && this.includes.length > 0) {
            result = false;
            length = this.includes.length;
            for (i = 0; i < length; ++i) {
                if (!name.startsWith(this.includes[i])) continue;
                result = true;
                break;
            }
        } else {
            result = true;
        }
        if (this.excludes != null) {
            length = this.excludes.length;
            for (i = 0; i < length; ++i) {
                if (!name.startsWith(this.excludes[i])) continue;
                result = false;
                break;
            }
        }
        return result;
    }
}

