/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.weld;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Named;
import javax.inject.Singleton;
import org.exoplatform.container.AbstractComponentAdapter;
import org.exoplatform.container.AbstractInterceptor;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.spi.ComponentAdapter;
import org.exoplatform.container.spi.ContainerException;
import org.exoplatform.container.weld.WeldContainerHelper;
import org.exoplatform.container.xml.Component;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.weld.Container;
import org.jboss.weld.environment.se.Weld;

public class WeldContainer
extends AbstractInterceptor {
    private static final long serialVersionUID = -5805946626633663689L;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.ext.provider.impl.weld.v2.WeldContainer");
    private static final String WELD_PACKAGE_NAME = Container.class.getPackage().getName();
    private Weld weld;
    private org.jboss.weld.environment.se.WeldContainer container;
    private WeldContainerHelper helper;
    private Container weldContainer;

    public <T> T getComponentInstance(Object componentKey, Class<T> bindType, boolean autoRegistration) {
        Object result = super.getComponentInstance(componentKey, bindType, autoRegistration);
        if (this.weld != null && result == null) {
            if (componentKey instanceof Class && !((Class)componentKey).isAnnotation()) {
                return this.getInstanceOfType((Class)componentKey);
            }
            if (componentKey instanceof String) {
                Set beans = this.container.getBeanManager().getBeans(bindType, new Annotation[]{WeldContainer.createNamed((String)componentKey)});
                if (beans != null && !beans.isEmpty()) {
                    return bindType.cast(this.container.instance().select(((Bean)beans.iterator().next()).getBeanClass(), new Annotation[0]).get());
                }
            } else if (componentKey instanceof Class) {
                Class annotationType = (Class)componentKey;
                Annotation annotation = WeldContainer.createAnnotation(annotationType);
                Set beans = this.container.getBeanManager().getBeans(bindType, new Annotation[]{annotation});
                if (beans != null && !beans.isEmpty()) {
                    return bindType.cast(this.container.instance().select(((Bean)beans.iterator().next()).getBeanClass(), new Annotation[0]).get());
                }
            }
        }
        return (T)result;
    }

    public <T> T getComponentInstanceOfType(Class<T> componentType, boolean autoRegistration) {
        Object result = super.getComponentInstanceOfType(componentType, autoRegistration);
        if (this.weld != null && result == null) {
            result = this.getInstanceOfType(componentType);
        }
        return (T)result;
    }

    private <T> T getInstanceOfType(Class<T> componentType) {
        Instance instance;
        if (this.helper.isIncluded(componentType) && (instance = this.container.instance().select(componentType, new Annotation[0])) != null) {
            if (instance.isAmbiguous()) {
                Set beans = this.container.getBeanManager().getBeans(componentType, new Annotation[0]);
                for (Bean b : beans) {
                    if (!b.getBeanClass().isAnnotationPresent(Default.class)) continue;
                    instance = this.container.instance().select(b.getBeanClass(), new Annotation[0]);
                    break;
                }
            }
            return (T)instance.get();
        }
        return null;
    }

    public <T> ComponentAdapter<T> getComponentAdapter(Object componentKey, Class<T> bindType, boolean autoRegistration) {
        ComponentAdapter result = super.getComponentAdapter(componentKey, bindType, autoRegistration);
        if (this.weld != null && result == null) {
            if (componentKey instanceof Class && !((Class)componentKey).isAnnotation()) {
                return this.getAdapterOfType((Class)componentKey);
            }
            if (componentKey instanceof String) {
                Set beans = this.container.getBeanManager().getBeans(bindType, new Annotation[]{WeldContainer.createNamed((String)componentKey)});
                if (beans != null && !beans.isEmpty()) {
                    return this.createComponentAdapter(bindType, this.container.instance().select(((Bean)beans.iterator().next()).getBeanClass(), new Annotation[0]));
                }
            } else if (componentKey instanceof Class) {
                Class annotationType = (Class)componentKey;
                Annotation annotation = WeldContainer.createAnnotation(annotationType);
                Set beans = this.container.getBeanManager().getBeans(bindType, new Annotation[]{annotation});
                if (beans != null && !beans.isEmpty()) {
                    return this.createComponentAdapter(bindType, this.container.instance().select(((Bean)beans.iterator().next()).getBeanClass(), new Annotation[0]));
                }
            }
        }
        return result;
    }

    public <T> ComponentAdapter<T> getComponentAdapterOfType(Class<T> componentType, boolean autoRegistration) {
        ComponentAdapter<T> result = super.getComponentAdapterOfType(componentType, autoRegistration);
        if (this.weld != null && result == null) {
            result = this.getAdapterOfType(componentType);
        }
        return result;
    }

    private <T> ComponentAdapter<T> getAdapterOfType(Class<T> componentType) {
        Instance instance;
        if (this.helper.isIncluded(componentType) && (instance = this.container.instance().select(componentType, new Annotation[0])) != null) {
            if (instance.isAmbiguous()) {
                Set beans = this.container.getBeanManager().getBeans(componentType, new Annotation[0]);
                for (Bean b : beans) {
                    if (!b.getBeanClass().isAnnotationPresent(Default.class)) continue;
                    instance = this.container.instance().select(b.getBeanClass(), new Annotation[0]);
                    break;
                }
            }
            return this.createComponentAdapter(componentType, instance);
        }
        return null;
    }

    private <T> ComponentAdapter<T> createComponentAdapter(Class<T> type, final Instance<T> instance) {
        return new AbstractComponentAdapter<T>(type, type){
            private static final long serialVersionUID = 8230487164261120364L;

            public T getComponentInstance() throws ContainerException {
                return instance.get();
            }

            public boolean isSingleton() {
                return false;
            }
        };
    }

    private <T> ComponentAdapter<T> createComponentAdapter(final Class<T> type, final Bean<?> b) {
        return new AbstractComponentAdapter<T>(type, b.getBeanClass()){
            private static final long serialVersionUID = -2398896047339159840L;

            public T getComponentInstance() throws ContainerException {
                return type.cast(WeldContainer.this.container.instance().select(b.getBeanClass(), new Annotation[0]).get());
            }

            public boolean isSingleton() {
                return Singleton.class.equals((Object)b.getScope());
            }
        };
    }

    public <T> List<ComponentAdapter<T>> getComponentAdaptersOfType(Class<T> componentType) {
        ArrayList<ComponentAdapter<T>> result = super.getComponentAdaptersOfType(componentType);
        if (this.weld != null) {
            result = new ArrayList<ComponentAdapter<T>>(result);
            Set beans = this.container.getBeanManager().getBeans(componentType, new Annotation[0]);
            if (beans != null) {
                for (Bean b : beans) {
                    result.add(this.createComponentAdapter(componentType, b));
                }
            }
        }
        return result;
    }

    public <T> List<T> getComponentInstancesOfType(Class<T> componentType) throws ContainerException {
        Instance instance;
        List result = super.getComponentInstancesOfType(componentType);
        if (this.weld != null && (instance = this.container.instance().select(componentType, new Annotation[0])) != null) {
            for (Object t : instance) {
                result.add(t);
            }
        }
        return result;
    }

    public void start() {
        ConfigurationManager cm = (ConfigurationManager)super.getComponentInstanceOfType(ConfigurationManager.class, false);
        Component component = cm.getComponent(WeldContainerHelper.class);
        if (component == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No WeldContainerHelper has been defined, thus the WeldContainer will be disabled. To enable the Weld Integration please define an WeldContainerHelper");
            }
        } else {
            Weld weld = new Weld();
            weld.addExtension((Extension)new WeldExtension());
            WeldContainerHelper helper = (WeldContainerHelper)super.getComponentInstanceOfType(WeldContainerHelper.class, false);
            List<Extension> extensions = helper.getExtensions();
            if (extensions != null) {
                for (Extension e : extensions) {
                    weld.addExtension(e);
                }
            }
            this.helper = helper;
            this.container = weld.initialize();
            this.container.getBeanManager().getBeans(org.jboss.weld.environment.se.WeldContainer.class, new Annotation[0]);
            this.weldContainer = Container.instance();
            this.weld = weld;
            LOG.info((Object)("A WeldContainer has been enabled using the WeldContainerHelper " + helper.getClass()));
        }
        super.start();
    }

    public void stop() {
        super.stop();
        if (this.weld != null) {
            Container currentContainer;
            block4: {
                currentContainer = Container.available() ? Container.instance() : null;
                try {
                    this.weld.shutdown();
                }
                catch (RuntimeException e) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug((Object)"Could not shutdown the weld container properly", (Throwable)e);
                }
            }
            if (currentContainer != this.weldContainer) {
                this.weldContainer.cleanup();
            }
            this.weld = null;
            this.container = null;
            this.helper = null;
            this.weldContainer = null;
        }
    }

    private static Annotation createAnnotation(final Class<? extends Annotation> annotationType) {
        return (Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), annotationType.getInterfaces(), new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                if ("hashCode".equals(method.getName())) {
                    return annotationType.getName().hashCode();
                }
                if ("equals".equals(method.getName())) {
                    return args[0].hashCode() == annotationType.getName().hashCode() && args[0].toString().equals(annotationType.getName());
                }
                if ("toString".equals(method.getName())) {
                    return annotationType.getName();
                }
                return annotationType;
            }
        });
    }

    private static Named createNamed(final String name) {
        return new Named(){

            public Class<? extends Annotation> annotationType() {
                return Named.class;
            }

            public String value() {
                return name;
            }
        };
    }

    public String getId() {
        return "WeldIntegration";
    }

    private static void bindAll(Class<?> clazz, Set<Type> types) {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        types.add(clazz);
        for (Class<?> c : clazz.getInterfaces()) {
            WeldContainer.bindAll(c, types);
        }
        WeldContainer.bindAll(clazz.getSuperclass(), types);
    }

    private static class ComponentAdapterBean<T>
    implements Bean<T> {
        private final ComponentAdapter<T> adapter;
        private Set<Type> types;
        private Set<Annotation> qualifiers;

        public ComponentAdapterBean(ComponentAdapter<T> adapter) {
            this.adapter = adapter;
        }

        public T create(CreationalContext<T> ctx) {
            return (T)this.adapter.getComponentInstance();
        }

        public void destroy(T instance, CreationalContext<T> ctx) {
            ctx.release();
        }

        public Set<Type> getTypes() {
            if (this.types != null) {
                return this.types;
            }
            HashSet<Type> types = new HashSet<Type>();
            if (this.adapter.getComponentKey() instanceof Class && !((Class)this.adapter.getComponentKey()).isAnnotation()) {
                types.add((Class)this.adapter.getComponentKey());
                types.add(this.adapter.getComponentImplementation());
            } else {
                WeldContainer.bindAll(this.adapter.getComponentImplementation(), types);
            }
            types.add((Type)((Object)Object.class));
            this.types = types;
            return this.types;
        }

        public Set<Annotation> getQualifiers() {
            if (this.qualifiers != null) {
                return this.qualifiers;
            }
            HashSet<Annotation> qualifiers = new HashSet<Annotation>();
            if (this.adapter.getComponentKey() instanceof String) {
                qualifiers.add((Annotation)WeldContainer.createNamed((String)this.adapter.getComponentKey()));
            } else if (this.adapter.getComponentKey() instanceof Class && ((Class)this.adapter.getComponentKey()).isAnnotation()) {
                qualifiers.add(WeldContainer.createAnnotation((Class)this.adapter.getComponentKey()));
            } else {
                qualifiers.add((Annotation)new AnnotationLiteral<Default>(){});
                qualifiers.add((Annotation)new AnnotationLiteral<Any>(){});
            }
            this.qualifiers = qualifiers;
            return this.qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return this.adapter.isSingleton() ? Singleton.class : Dependent.class;
        }

        public String getName() {
            return null;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public boolean isAlternative() {
            return false;
        }

        public Class<?> getBeanClass() {
            return this.adapter.getComponentImplementation();
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return Collections.emptySet();
        }

        public boolean isNullable() {
            return false;
        }
    }

    private class WeldExtension
    implements Extension {
        private WeldExtension() {
        }

        void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
            Collection adapters = WeldContainer.this.delegate.getComponentAdapters();
            for (ComponentAdapter adapter : adapters) {
                abd.addBean(new ComponentAdapterBean(adapter));
            }
        }

        <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> pat) {
            Class clazz = pat.getAnnotatedType().getJavaClass();
            if (clazz.getName().startsWith(WELD_PACKAGE_NAME)) {
                return;
            }
            if (!WeldContainer.this.helper.isIncluded(clazz)) {
                pat.veto();
            }
        }
    }
}

