/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.jmx;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.inject.Singleton;
import org.exoplatform.commons.utils.ClassLoading;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ComponentAdapterDependenciesAware;
import org.exoplatform.container.ComponentTask;
import org.exoplatform.container.ComponentTaskContext;
import org.exoplatform.container.ComponentTaskType;
import org.exoplatform.container.ConcurrentContainer;
import org.exoplatform.container.ConcurrentContainerMT;
import org.exoplatform.container.CyclicDependencyException;
import org.exoplatform.container.Dependency;
import org.exoplatform.container.DependencyStackListener;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.LockManager;
import org.exoplatform.container.component.ComponentLifecycle;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.jmx.MX4JComponentAdapter;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ExternalComponentPlugins;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class MX4JComponentAdapterMT<T>
extends MX4JComponentAdapter<T>
implements DependencyStackListener,
ComponentAdapterDependenciesAware<T> {
    private static final long serialVersionUID = -9001193588034229411L;
    private final transient AtomicReference<Collection<Dependency>> createDependencies = new AtomicReference();
    private final transient AtomicReference<Collection<Dependency>> initDependencies = new AtomicReference();
    private final transient AtomicReference<ComponentTask<T>> createTask = new AtomicReference();
    private final transient AtomicReference<Collection<ComponentTask<Void>>> initTasks = new AtomicReference();
    private final transient ConcurrentContainerMT container;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.mt.MX4JComponentAdapterMT");

    public MX4JComponentAdapterMT(ExoContainer holder, ConcurrentContainerMT container, Object key, Class<T> implementation) {
        super(holder, (ConcurrentContainer)container, key, implementation, LockManager.getInstance().createLock());
        this.container = container;
    }

    private void addComponentPlugin(List<ComponentTask<Void>> tasks, Set<Dependency> dependencies, boolean debug, List<org.exoplatform.container.xml.ComponentPlugin> plugins) throws Exception {
        if (plugins == null) {
            return;
        }
        for (org.exoplatform.container.xml.ComponentPlugin plugin : plugins) {
            try {
                Class pluginClass = ClassLoading.forName((String)plugin.getType(), (Object)this);
                ArrayList<Dependency> lDependencies = new ArrayList<Dependency>();
                Constructor constructor = this.container.getConstructor(pluginClass, lDependencies);
                dependencies.addAll(lDependencies);
                tasks.add(this.createPlugin(this, this.container, pluginClass, debug, plugin, constructor, plugin.getInitParams(), lDependencies));
            }
            catch (CyclicDependencyException e) {
                throw e;
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to instanciate plugin " + plugin.getName() + " for component " + this.getComponentImplementation() + ": " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    @Override
    public Collection<Dependency> getCreateDependencies() {
        return this.createDependencies.get();
    }

    @Override
    public Collection<Dependency> getInitDependencies() {
        return this.initDependencies.get();
    }

    @Override
    public void callDependency(ComponentTask<?> task, Dependency dep) {
        if (PropertyManager.isDevelopping()) {
            if (dep.getKey() instanceof String || dep.getKey() instanceof Class && ((Class)dep.getKey()).isAnnotation()) {
                LOG.warn((Object)("An unexpected call of getComponentInstance(" + dep.getKey() + "," + dep.getBindType().getName() + ") has been detected please add the component in your constructor instead"), (Throwable)new Exception("This is the stack trace allowing you to identify where the unexpected call of getComponentInstanceOfType has been done"));
            } else if (dep.getKey() instanceof Class) {
                LOG.warn((Object)("An unexpected call of getComponentInstanceOfType(" + ((Class)dep.getKey()).getName() + ") has been detected please add the component in your constructor instead"), (Throwable)new Exception("This is the stack trace allowing you to identify where the unexpected call of getComponentInstanceOfType has been done"));
            }
        }
        if (dep.getKey().equals(this.getComponentKey())) {
            return;
        }
        if (task.getType() == ComponentTaskType.CREATE) {
            this.getCreateDependencies().add(dep);
        } else if (task.getType() == ComponentTaskType.INIT) {
            this.getInitDependencies().add(dep);
        }
        this.container.getComponentTaskContext().checkDependency(dep.getKey(), task.getType());
    }

    protected ComponentTask<T> getCreateTask() {
        Component component = null;
        InitParams params = null;
        boolean debug = false;
        Object key = this.getComponentKey();
        String componentKey = key instanceof String ? (String)key : ((Class)key).getName();
        try {
            ConfigurationManager manager = (ConfigurationManager)this.exocontainer.getComponentInstanceOfType(ConfigurationManager.class);
            Component component2 = component = manager == null ? null : manager.getComponent(componentKey);
            if (component != null) {
                params = component.getInitParams();
                debug = component.getShowDeployInfo();
            }
            if (debug) {
                LOG.debug((Object)("==> get constructor of the component : " + this.getComponentImplementation()));
            }
            ArrayList<Dependency> lDependencies = new ArrayList<Dependency>();
            Constructor constructor = this.container.getConstructor(this.getComponentImplementation(), lDependencies);
            this.setCreateDependencies(lDependencies);
            if (debug) {
                LOG.debug((Object)("==> create component : " + this.getComponentImplementation()));
            }
            return this.container.createComponentTask(constructor, params, lDependencies, this);
        }
        catch (Exception e) {
            String msg = "Cannot instantiate component " + this.getComponentImplementation();
            if (component != null) {
                msg = "Cannot instantiate component key=" + component.getKey() + " type=" + component.getType() + " found at " + component.getDocumentURL();
            }
            throw new RuntimeException(msg, e);
        }
    }

    protected void setCreateDependencies(List<Dependency> lDependencies) {
        if (this.createDependencies.get() == null) {
            this.createDependencies.compareAndSet(null, new CopyOnWriteArraySet<Dependency>(lDependencies));
        }
    }

    protected Collection<ComponentTask<Void>> getInitTasks() {
        Component component = null;
        boolean debug = false;
        Object key = this.getComponentKey();
        String componentKey = key instanceof String ? (String)key : ((Class)key).getName();
        try {
            ExternalComponentPlugins ecplugins;
            boolean hasOnlyEmptyPublicConstructor;
            ConfigurationManager manager = (ConfigurationManager)this.exocontainer.getComponentInstanceOfType(ConfigurationManager.class);
            Component component2 = component = manager == null ? null : manager.getComponent(componentKey);
            if (component != null) {
                debug = component.getShowDeployInfo();
            }
            ArrayList<ComponentTask<Void>> tasks = new ArrayList<ComponentTask<Void>>();
            HashSet<Dependency> dependencies = new HashSet<Dependency>();
            Class implementationClass = this.getComponentImplementation();
            boolean isSingleton = this.isSingleton;
            boolean isInitialized = this.isInitialized;
            if (debug) {
                LOG.debug((Object)("==> create  component : " + implementationClass.getName()));
            }
            boolean hasInjectableConstructor = !isSingleton || ContainerUtil.hasInjectableConstructor((Class)implementationClass);
            boolean bl = hasOnlyEmptyPublicConstructor = !isSingleton || ContainerUtil.hasOnlyEmptyPublicConstructor((Class)implementationClass);
            if (hasInjectableConstructor || hasOnlyEmptyPublicConstructor) {
                ArrayList<Dependency> lDependencies = new ArrayList<Dependency>();
                boolean isInjectPresent = this.container.initializeComponent(implementationClass, lDependencies, tasks, this);
                dependencies.addAll(lDependencies);
                isSingleton = this.manageScope(isSingleton, isInitialized, hasInjectableConstructor, isInjectPresent);
            } else if (!isInitialized) {
                this.isSingleton = true;
                isSingleton = true;
                this.scope.set(Singleton.class);
            }
            if (component != null && component.getComponentPlugins() != null) {
                this.addComponentPlugin(tasks, dependencies, debug, component.getComponentPlugins());
            }
            ExternalComponentPlugins externalComponentPlugins = ecplugins = manager == null ? null : manager.getConfiguration().getExternalComponentPlugins(componentKey);
            if (ecplugins != null) {
                this.addComponentPlugin(tasks, dependencies, debug, ecplugins.getComponentPlugins());
            }
            this.initDependencies.compareAndSet(null, new CopyOnWriteArraySet<Dependency>(dependencies));
            tasks.add(new ComponentTask<Void>("initialize component " + this.getComponentImplementation().getName(), this.container, (DependencyStackListener)this, ComponentTaskType.INIT){

                @Override
                public Void execute(ConcurrentContainer.CreationalContextComponentAdapter<?> cCtx) throws Exception {
                    if (cCtx.get() instanceof ComponentLifecycle && MX4JComponentAdapterMT.this.exocontainer instanceof ExoContainer) {
                        ComponentLifecycle lc = (ComponentLifecycle)cCtx.get();
                        lc.initComponent(MX4JComponentAdapterMT.this.exocontainer);
                    }
                    return null;
                }
            });
            if (!isInitialized) {
                this.isInitialized = true;
            }
            return tasks;
        }
        catch (Exception e) {
            String msg = "Cannot initialize component " + this.getComponentImplementation();
            if (component != null) {
                msg = "Cannot initialize component key=" + component.getKey() + " type=" + component.getType() + " found at " + component.getDocumentURL();
            }
            throw new RuntimeException(msg, e);
        }
    }

    private ComponentTask<Void> createPlugin(MX4JComponentAdapterMT<T> caller, ConcurrentContainerMT exocontainer, final Class<?> pluginClass, final boolean debug, final org.exoplatform.container.xml.ComponentPlugin plugin, final Constructor<T> constructor, InitParams params, List<Dependency> lDependencies) throws Exception {
        final Object[] args = exocontainer.getArguments(constructor, params, lDependencies);
        return new ComponentTask<Void>("create/add plugin " + plugin.getName() + " for component " + this.getComponentImplementation().getName(), exocontainer, caller, ComponentTaskType.INIT){

            @Override
            public Void execute(final ConcurrentContainer.CreationalContextComponentAdapter<?> cCtx) throws Exception {
                try {
                    this.getContainer().loadArguments(args);
                    ComponentPlugin cplugin = (ComponentPlugin)constructor.newInstance(args);
                    cplugin.setName(plugin.getName());
                    cplugin.setDescription(plugin.getDescription());
                    Class clazz = MX4JComponentAdapterMT.this.getComponentImplementation();
                    final Method m = MX4JComponentAdapter.getSetMethod((Class)clazz, (String)plugin.getSetMethod(), (Class)pluginClass);
                    if (m == null) {
                        LOG.error((Object)("Cannot find the method '" + plugin.getSetMethod() + "' that has only one parameter of type '" + pluginClass.getName() + "' in the class '" + clazz.getName() + "'."));
                        return null;
                    }
                    final Object[] params = new Object[]{cplugin};
                    SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            m.invoke(cCtx.get(), params);
                            return null;
                        }
                    });
                    if (debug) {
                        LOG.debug((Object)("==> add component plugin: " + cplugin));
                    }
                    cplugin.setName(plugin.getName());
                    cplugin.setDescription(plugin.getDescription());
                    return null;
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof Exception) {
                        throw (Exception)e.getCause();
                    }
                    throw e;
                }
            }
        };
    }

    protected T createInstance(final Context ctx) {
        Object result = ctx.get((Contextual)this);
        if (result != null) {
            return (T)result;
        }
        return this.create(new Callable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    Object object = ctx.get((Contextual)MX4JComponentAdapterMT.this, MX4JComponentAdapterMT.this.container.addComponentToCtx(MX4JComponentAdapterMT.this.getComponentKey()));
                    return object;
                }
                finally {
                    MX4JComponentAdapterMT.this.container.removeComponentFromCtx(MX4JComponentAdapterMT.this.getComponentKey());
                }
            }
        });
    }

    protected T create() {
        return this.create(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return MX4JComponentAdapterMT.this.doCreate();
            }
        });
    }

    protected T doCreate() {
        return this.doCreate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T doCreate(boolean useSharedMemory) {
        T t;
        if (this.instance_ != null) {
            return (T)this.instance_;
        }
        boolean toBeLocked = this.isSingleton;
        boolean skipFinally = false;
        try {
            ConcurrentContainer.CreationalContextComponentAdapter ctx;
            if (toBeLocked) {
                if (useSharedMemory) {
                    Object result = this.container.getComponentFromSharedMemory(this.getComponentKey());
                    if (result != null) {
                        LOG.debug((Object)"The value could be found from the shared memory");
                        skipFinally = true;
                        Object t2 = result;
                        return t2;
                    }
                    LOG.debug((Object)"The value could not be found from the shared memory");
                }
                if (!this.lock.tryLock()) {
                    this.lock.lockInterruptibly();
                }
                ctx = this.container.addComponentToCtx(this.getComponentKey());
            } else {
                skipFinally = true;
                ctx = new ConcurrentContainer.CreationalContextComponentAdapter();
            }
            t = this.create((CreationalContext<T>)ctx);
            return t;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            skipFinally = true;
            LOG.debug((Object)"A deadlock has been detected, let's retry using the shared memory");
            t = this.doCreate(true);
            return t;
        }
        finally {
            if (!skipFinally) {
                this.lock.unlock();
                this.container.removeComponentFromCtx(this.getComponentKey());
            }
        }
    }

    private T create(Callable<T> mainCreateTask) {
        ComponentTaskContext ctx = this.container.getComponentTaskContext();
        try {
            this.loadTasks();
            this.loadDependencies(ctx);
            T t = mainCreateTask.call();
            return t;
        }
        catch (CyclicDependencyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create component " + this.getComponentImplementation(), e);
        }
        finally {
            if (ctx == null) {
                this.container.setComponentTaskContext(null);
            }
        }
    }

    private void loadDependencies(ComponentTaskContext ctx) throws Exception {
        ComponentTaskContext createCtx = ctx;
        if (createCtx == null) {
            createCtx = new ComponentTaskContext(this.getComponentKey(), ComponentTaskType.CREATE);
            this.container.setComponentTaskContext(createCtx);
        } else if (!createCtx.isLast(this.getComponentKey())) {
            createCtx = createCtx.addToContext(this.getComponentKey());
            this.container.setComponentTaskContext(createCtx);
        }
        this.container.loadDependencies(this.getComponentKey(), createCtx, this.getCreateDependencies(), ComponentTaskType.CREATE);
    }

    public T create(CreationalContext<T> creationalContext) {
        ConcurrentContainer.CreationalContextComponentAdapter ctx = (ConcurrentContainer.CreationalContextComponentAdapter)creationalContext;
        if (this.instance_ != null) {
            return (T)this.instance_;
        }
        if (ctx.get() != null) {
            return (T)ctx.get();
        }
        ComponentTaskContext taskCtx = this.container.getComponentTaskContext();
        boolean isRoot = taskCtx.isRoot();
        if (!isRoot) {
            taskCtx = taskCtx.setLastTaskType(ComponentTaskType.CREATE);
            this.container.setComponentTaskContext(taskCtx);
        }
        try {
            ComponentTask<T> task = this.createTask.get();
            T result = task.call(ctx);
            if (this.instance_ != null) {
                return (T)this.instance_;
            }
            if (ctx.get() != null) {
                return (T)ctx.get();
            }
            ctx.push(result);
        }
        catch (CyclicDependencyException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create component " + this.getComponentImplementation(), e);
        }
        if (isRoot) {
            taskCtx = taskCtx.resetDependencies(this.getComponentKey(), ComponentTaskType.INIT);
            this.container.setComponentTaskContext(taskCtx);
        } else {
            taskCtx = taskCtx.setLastTaskType(ComponentTaskType.INIT);
            this.container.setComponentTaskContext(taskCtx);
        }
        Collection<ComponentTask<Void>> tasks = this.initTasks.get();
        ComponentTask<Void> task2 = null;
        try {
            if (tasks != null && !tasks.isEmpty()) {
                this.container.loadDependencies(this.getComponentKey(), taskCtx, this.getInitDependencies(), ComponentTaskType.INIT);
                for (ComponentTask<Void> task2 : tasks) {
                    task2.call(ctx);
                    task2 = null;
                }
            }
            if (this.instance_ != null) {
                return (T)this.instance_;
            }
            if (this.instance_ == null && this.isSingleton) {
                this.instance_ = ctx.get();
            }
        }
        catch (CyclicDependencyException e) {
            throw e;
        }
        catch (Exception e) {
            if (task2 != null) {
                throw new RuntimeException("Cannot " + task2.getName() + " for the component " + this.getComponentImplementation(), e);
            }
            throw new RuntimeException("Cannot initialize component " + this.getComponentImplementation(), e);
        }
        if (ctx.get() instanceof Startable && this.exocontainer.canBeStopped()) {
            try {
                ((Startable)ctx.get()).start();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot auto-start component " + this.getComponentImplementation(), e);
            }
        }
        return (T)ctx.get();
    }

    private void loadTasks() {
        if (this.createTask.get() == null) {
            try {
                this.createTask.compareAndSet(null, this.getCreateTask());
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Cannot get the create task of the component " + this.getComponentImplementation(), e);
            }
        }
        if (this.initTasks.get() == null) {
            try {
                this.initTasks.compareAndSet(null, this.getInitTasks());
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Cannot get the init tasks of the component " + this.getComponentImplementation(), e);
            }
        }
    }
}

