/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.deployment;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.gatein.integration.jboss.as7.GateInConfiguration;
import org.gatein.integration.jboss.as7.GateInExtension;
import org.gatein.integration.jboss.as7.deployment.GateInConfigurationKey;
import org.gatein.integration.jboss.as7.web.StartupService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public class GateInStarterDeploymentProcessor
implements DeploymentUnitProcessor {
    private volatile ConcurrentHashMap<ModuleIdentifier, ModuleIdentifier> deploymentModules;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentHashMap<ModuleIdentifier, ModuleIdentifier> getDeploymentModules(GateInConfiguration config) {
        if (this.deploymentModules == null) {
            GateInStarterDeploymentProcessor gateInStarterDeploymentProcessor = this;
            synchronized (gateInStarterDeploymentProcessor) {
                if (this.deploymentModules == null) {
                    ConcurrentHashMap<ModuleIdentifier, ModuleIdentifier> dms = new ConcurrentHashMap<ModuleIdentifier, ModuleIdentifier>();
                    dms.put(config.getGateInEarModule(), config.getGateInEarModule());
                    for (ModuleIdentifier id : config.getGateInExtModules()) {
                        dms.put(id, id);
                    }
                    this.deploymentModules = dms;
                }
            }
        }
        return this.deploymentModules;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit du = phaseContext.getDeploymentUnit();
        if (GateInConfiguration.isGateInArchive(du)) {
            GateInConfiguration config = (GateInConfiguration)du.getAttachment(GateInConfigurationKey.KEY);
            ModuleIdentifier moduleId = (ModuleIdentifier)du.getAttachment(Attachments.MODULE_IDENTIFIER);
            this.getDeploymentModules(config).remove(moduleId);
            if (this.deploymentModules.size() == 0) {
                StartupService startup = new StartupService();
                startup.setGateInModule((Module)du.getAttachment(Attachments.MODULE));
                ServiceBuilder builder = phaseContext.getServiceTarget().addService(StartupService.SERVICE_NAME, (Service)startup);
                builder.addDependency(GateInExtension.deploymentUnitName(config.getGateInEarModule(), Phase.CLEANUP));
                for (ModuleIdentifier id : config.getGateInExtModules()) {
                    builder.addDependency(GateInExtension.deploymentUnitName(id, Phase.CLEANUP));
                }
                for (ServiceName svcName : config.getChildWars()) {
                    builder.addDependency(svcName);
                }
                for (ServiceName svcName : config.getChildSubUnits()) {
                    builder.addDependency(svcName.append(new String[]{Phase.CLEANUP.name()}));
                }
                List<String> prefixes = config.getChildSubUnitComponentPrefixes();
                for (ServiceName name : du.getServiceRegistry().getServiceNames()) {
                    for (String prefix : prefixes) {
                        if (!name.getCanonicalName().startsWith(prefix)) continue;
                        builder.addDependency(name);
                    }
                }
                builder.install();
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

