/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.integration.jboss.as7.deployment;

import org.gatein.integration.jboss.as7.GateInConfiguration;
import org.gatein.integration.jboss.as7.deployment.GateInConfigurationKey;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.msc.service.ServiceName;

public class WarDependenciesDeploymentProcessor
implements DeploymentUnitProcessor {
    private void processWarDeployment(DeploymentUnit du) {
        String pathName;
        WarMetaData warMetaData = (WarMetaData)du.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            return;
        }
        JBossWebMetaData metaData = warMetaData.getMergedJBossWebMetaData();
        if (metaData.getContextRoot() == null) {
            pathName = "/" + du.getName().substring(0, du.getName().length() - 4);
        } else {
            pathName = metaData.getContextRoot();
            if ("/".equals(pathName)) {
                pathName = "";
            } else if (pathName.length() > 0 && pathName.charAt(0) != '/') {
                pathName = "/" + pathName;
            }
        }
        GateInConfiguration config = (GateInConfiguration)du.getAttachment(GateInConfigurationKey.KEY);
        ServiceName deploymentServiceName = WebSubsystemServices.deploymentServiceName((String)"default-host", (String)pathName);
        config.addChildWar(deploymentServiceName);
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit du = phaseContext.getDeploymentUnit();
        DeploymentUnit parent = du.getParent();
        if (parent != null) {
            if (GateInConfiguration.isGateInArchive(parent)) {
                this.processWarDeployment(du);
            }
        } else if (GateInConfiguration.isGateInArchive(du)) {
            this.processWarDeployment(du);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

