/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.common.http.client;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.Hashtable;
import org.exoplatform.common.http.client.HTTPClientModule;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.common.http.client.HttpOutputStream;
import org.exoplatform.common.http.client.NVPair;
import org.exoplatform.common.http.client.ParseException;
import org.exoplatform.common.http.client.ProtocolNotSuppException;
import org.exoplatform.common.http.client.Request;
import org.exoplatform.common.http.client.Response;
import org.exoplatform.common.http.client.RoRequest;
import org.exoplatform.common.http.client.URI;
import org.exoplatform.common.http.client.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

class RedirectionModule
implements HTTPClientModule {
    private static Hashtable perm_redir_cntxt_list = new Hashtable();
    private static Hashtable deferred_redir_list = new Hashtable();
    private int level = 0;
    private URI lastURI = null;
    private boolean new_con;
    private Request saved_req = null;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.commons.RedirectionModule");

    RedirectionModule() {
    }

    public int requestHandler(Request req, Response[] resp) {
        URI cur_loc;
        HTTPConnection con = req.getConnection();
        HttpOutputStream out = req.getStream();
        if (out != null && deferred_redir_list.get(out) != null) {
            this.copyFrom((RedirectionModule)deferred_redir_list.remove(out));
            req.copyFrom(this.saved_req);
            if (this.new_con) {
                return 5;
            }
            return 1;
        }
        try {
            cur_loc = new URI(new URI(con.getProtocol(), con.getHost(), con.getPort(), null), req.getRequestURI());
        }
        catch (ParseException pe) {
            throw new Error("HTTPClient Internal Error: unexpected exception '" + pe + "'", pe);
        }
        Hashtable perm_redir_list = Util.getList(perm_redir_cntxt_list, req.getConnection().getContext());
        URI new_loc = (URI)perm_redir_list.get(cur_loc);
        if (new_loc != null) {
            block11: {
                String nres = new_loc.getPathAndQuery();
                req.setRequestURI(nres);
                try {
                    this.lastURI = new URI(new_loc, nres);
                }
                catch (ParseException pe) {
                    if (!LOG.isTraceEnabled()) break block11;
                    LOG.trace((Object)("An exception occurred: " + pe.getMessage()));
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Matched request in permanent redirection list - redoing request to " + this.lastURI.toExternalForm()));
            }
            if (!con.isCompatibleWith(new_loc)) {
                try {
                    con = new HTTPConnection(new_loc);
                }
                catch (ProtocolNotSuppException e) {
                    throw new Error("HTTPClient Internal Error: unexpected exception '" + e + "'", e);
                }
                con.setContext(req.getConnection().getContext());
                req.setConnection(con);
                return 5;
            }
            return 1;
        }
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) throws IOException {
        int sts = resp.getStatusCode();
        if ((sts < 301 || sts > 307 || sts == 304) && this.lastURI != null) {
            resp.setEffectiveURI(this.lastURI);
        }
    }

    /*
     * Unable to fully structure code
     */
    public int responsePhase2Handler(Response resp, Request req) throws IOException {
        sts = resp.getStatusCode();
        switch (sts) {
            case 302: {
                if (req.getMethod().equals("POST") || req.getMethod().equals("PUT")) {
                    if (RedirectionModule.LOG.isDebugEnabled()) {
                        RedirectionModule.LOG.debug((Object)("Received status: " + sts + " " + resp.getReasonLine() + " - treating as 303"));
                    }
                    sts = 303;
                }
            }
            case 301: 
            case 303: 
            case 307: {
                if (RedirectionModule.LOG.isDebugEnabled()) {
                    RedirectionModule.LOG.debug((Object)("Handling status: " + sts + " " + resp.getReasonLine()));
                }
                if (!req.getMethod().equals("GET") && !req.getMethod().equals("HEAD") && sts != 303) {
                    if (RedirectionModule.LOG.isDebugEnabled()) {
                        RedirectionModule.LOG.debug((Object)"Not redirected because method is neither HEAD nor GET");
                    }
                    if (sts == 301 && resp.getHeader("Location") != null) {
                        RedirectionModule.update_perm_redir_list(req, this.resLocHdr(resp.getHeader("Location"), req));
                    }
                    resp.setEffectiveURI(this.lastURI);
                    return 10;
                }
            }
            case 305: 
            case 306: {
                if ((sts == 305 || sts == 306) && RedirectionModule.LOG.isDebugEnabled()) {
                    RedirectionModule.LOG.debug((Object)("Handling status: " + sts + " " + resp.getReasonLine()));
                }
                if (sts == 305 && req.getConnection().getProxyHost() != null) {
                    if (RedirectionModule.LOG.isDebugEnabled()) {
                        RedirectionModule.LOG.debug((Object)"305 ignored because a proxy is already in use");
                    }
                    resp.setEffectiveURI(this.lastURI);
                    return 10;
                }
                if (this.level >= 15 || resp.getHeader("Location") == null) {
                    if (RedirectionModule.LOG.isDebugEnabled()) {
                        if (this.level >= 15) {
                            RedirectionModule.LOG.debug((Object)"Not redirected because of too many levels of redirection");
                        } else {
                            RedirectionModule.LOG.debug((Object)"Not redirected because no Location header was present");
                        }
                    }
                    resp.setEffectiveURI(this.lastURI);
                    return 10;
                }
                ++this.level;
                loc = this.resLocHdr(resp.getHeader("Location"), req);
                this.new_con = false;
                if (sts == 305) {
                    mvd = new HTTPConnection(req.getConnection().getProtocol(), req.getConnection().getHost(), req.getConnection().getPort());
                    mvd.setCurrentProxy(loc.getHost(), loc.getPort());
                    mvd.setContext(req.getConnection().getContext());
                    this.new_con = true;
                    nres = req.getRequestURI();
                    req.setMethod("GET");
                    req.setData(null);
                    req.setStream(null);
                } else {
                    if (sts == 306) {
                        return 10;
                    }
                    if (req.getConnection().isCompatibleWith(loc)) {
                        mvd = req.getConnection();
                        nres = loc.getPathAndQuery();
                    } else {
                        try {
                            mvd = new HTTPConnection(loc);
                            nres = loc.getPathAndQuery();
                        }
                        catch (ProtocolNotSuppException e) {
                            if (req.getConnection().getProxyHost() == null || !loc.getScheme().equalsIgnoreCase("ftp")) {
                                return 10;
                            }
                            mvd = new HTTPConnection("http", req.getConnection().getProxyHost(), req.getConnection().getProxyPort());
                            mvd.setCurrentProxy(null, 0);
                            nres = loc.toExternalForm();
                        }
                        mvd.setContext(req.getConnection().getContext());
                        this.new_con = true;
                    }
                    if (sts == 303) {
                        if (!req.getMethod().equals("HEAD")) {
                            req.setMethod("GET");
                        }
                        req.setData(null);
                        req.setStream(null);
                    } else {
                        if (req.getStream() != null) {
                            if (!HTTPConnection.deferStreamed) {
                                if (RedirectionModule.LOG.isDebugEnabled()) {
                                    RedirectionModule.LOG.debug((Object)("Status " + sts + " not handled - request has an output stream"));
                                }
                                return 10;
                            }
                            this.saved_req = (Request)req.clone();
                            RedirectionModule.deferred_redir_list.put(req.getStream(), this);
                            req.getStream().reset();
                            resp.setRetryRequest(true);
                        }
                        if (sts == 301) {
                            try {
                                RedirectionModule.update_perm_redir_list(req, new URI(loc, nres));
                            }
                            catch (ParseException pe) {
                                throw new Error("HTTPClient Internal Error: unexpected exception '" + pe + "'", pe);
                            }
                        }
                    }
                    hdrs = req.getHeaders();
                    for (idx = 0; idx < hdrs.length; ++idx) {
                        if (!hdrs[idx].getName().equalsIgnoreCase("Referer")) continue;
                        con = req.getConnection();
                        hdrs[idx] = new NVPair("Referer", con + req.getRequestURI());
                        break;
                    }
                }
                req.setConnection(mvd);
                req.setRequestURI(nres);
                try {
                    resp.getInputStream().close();
                }
                catch (IOException ioe) {
                    if (!RedirectionModule.LOG.isTraceEnabled()) ** GOTO lbl101
                    RedirectionModule.LOG.trace((Object)("An exception occurred: " + ioe.getMessage()));
                }
lbl101:
                // 3 sources

                if (sts == 305 || sts == 306) ** GOTO lbl111
                try {
                    this.lastURI = new URI(loc, nres);
                }
                catch (ParseException pe) {
                    if (!RedirectionModule.LOG.isTraceEnabled()) ** GOTO lbl108
                    RedirectionModule.LOG.trace((Object)("An exception occurred: " + pe.getMessage()));
                }
lbl108:
                // 3 sources

                if (RedirectionModule.LOG.isDebugEnabled()) {
                    RedirectionModule.LOG.debug((Object)("Request redirected to " + this.lastURI.toExternalForm() + " using method " + req.getMethod()));
                }
                ** GOTO lbl113
lbl111:
                // 1 sources

                if (RedirectionModule.LOG.isDebugEnabled()) {
                    RedirectionModule.LOG.debug((Object)("Resending request using proxy " + mvd.getProxyHost() + ":" + mvd.getProxyPort()));
                }
lbl113:
                // 4 sources

                if (req.getStream() != null) {
                    return 10;
                }
                if (this.new_con) {
                    return 15;
                }
                return 13;
            }
        }
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    public void trailerHandler(Response resp, RoRequest req) {
    }

    private static void update_perm_redir_list(RoRequest req, URI new_loc) {
        URI cur_loc;
        HTTPConnection con;
        block3: {
            con = req.getConnection();
            cur_loc = null;
            try {
                cur_loc = new URI(new URI(con.getProtocol(), con.getHost(), con.getPort(), null), req.getRequestURI());
            }
            catch (ParseException pe) {
                if (!LOG.isTraceEnabled()) break block3;
                LOG.trace((Object)("An exception occurred: " + pe.getMessage()));
            }
        }
        if (!cur_loc.equals(new_loc)) {
            Hashtable perm_redir_list = Util.getList(perm_redir_cntxt_list, con.getContext());
            perm_redir_list.put(cur_loc, new_loc);
        }
    }

    private URI resLocHdr(String loc, RoRequest req) throws ProtocolException {
        try {
            URI base = new URI(req.getConnection().getProtocol(), req.getConnection().getHost(), req.getConnection().getPort(), null);
            base = new URI(base, req.getRequestURI());
            URI res = new URI(base, loc);
            if (res.getHost() == null) {
                throw new ProtocolException("Malformed URL in Location header: `" + loc + "' - missing host field");
            }
            return res;
        }
        catch (ParseException pe) {
            throw new ProtocolException("Malformed URL in Location header: `" + loc + "' - exception was: " + pe.getMessage());
        }
    }

    private void copyFrom(RedirectionModule other) {
        this.level = other.level;
        this.lastURI = other.lastURI;
        this.saved_req = other.saved_req;
    }
}

