/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.common.http.client;

import java.io.IOException;
import java.net.ProtocolException;
import org.exoplatform.common.http.client.HTTPClientModule;
import org.exoplatform.common.http.client.Request;
import org.exoplatform.common.http.client.Response;
import org.exoplatform.common.http.client.RoRequest;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

class DefaultModule
implements HTTPClientModule {
    private int req_timeout_retries = 3;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.commons.DefaultModule");

    DefaultModule() {
    }

    public int requestHandler(Request req, Response[] resp) {
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) {
    }

    /*
     * Unable to fully structure code
     */
    public int responsePhase2Handler(Response resp, Request req) throws IOException {
        sts = resp.getStatusCode();
        switch (sts) {
            case 408: {
                if (this.req_timeout_retries-- == 0 || req.getStream() != null) {
                    if (DefaultModule.LOG.isDebugEnabled()) {
                        DefaultModule.LOG.debug((Object)("Status " + sts + " " + resp.getReasonLine() + " not handled - maximum number of retries exceeded"));
                    }
                    return 10;
                }
                if (DefaultModule.LOG.isDebugEnabled()) {
                    DefaultModule.LOG.debug((Object)("Handling " + sts + " " + resp.getReasonLine() + " - resending request"));
                }
                return 13;
            }
            case 411: {
                if (req.getStream() != null && req.getStream().getLength() == -1) {
                    return 10;
                }
                try {
                    resp.getInputStream().close();
                }
                catch (IOException ioe) {
                    if (!DefaultModule.LOG.isTraceEnabled()) ** GOTO lbl20
                    DefaultModule.LOG.trace((Object)("An exception occurred: " + ioe.getMessage()));
                }
lbl20:
                // 3 sources

                if (req.getData() != null) {
                    throw new ProtocolException("Received status code 411 even though Content-Length was sent");
                }
                if (DefaultModule.LOG.isDebugEnabled()) {
                    DefaultModule.LOG.debug((Object)("Handling " + sts + " " + resp.getReasonLine() + " - resending request with 'Content-length: 0'"));
                }
                req.setData(new byte[0]);
                return 13;
            }
            case 505: {
                return 10;
            }
        }
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    public void trailerHandler(Response resp, RoRequest req) {
    }
}

