/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.common.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.exoplatform.commons.utils.Tools;

public class HierarchicalProperty {
    protected List<HierarchicalProperty> children;
    protected QName name;
    protected String value;
    protected HashMap<String, String> attributes = new HashMap();

    public HierarchicalProperty(String name, String value, String namespaceURI) {
        String[] tmp = name.split(":");
        this.name = tmp.length > 1 ? new QName(namespaceURI, tmp[1], tmp[0]) : (namespaceURI == null ? new QName(tmp[0]) : new QName(namespaceURI, tmp[0]));
        this.value = value;
        this.children = new ArrayList<HierarchicalProperty>();
    }

    public HierarchicalProperty(QName name, String value) {
        this.name = name;
        this.value = value;
        this.children = new ArrayList<HierarchicalProperty>();
    }

    public HierarchicalProperty(QName name, Calendar dateValue, String formatPattern) {
        this(name, null);
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatPattern, Locale.ENGLISH);
        dateFormat.setTimeZone(Tools.getTimeZone((String)"GMT"));
        this.value = dateFormat.format(dateValue.getTime());
    }

    public HierarchicalProperty(QName name) {
        this(name, null);
    }

    public HierarchicalProperty addChild(HierarchicalProperty prop) {
        this.children.add(prop);
        return prop;
    }

    public List<HierarchicalProperty> getChildren() {
        return this.children;
    }

    public HierarchicalProperty getChild(QName name) {
        for (HierarchicalProperty child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public HierarchicalProperty getChild(int index) {
        return this.children.get(index);
    }

    public QName getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setAttribute(String attributeName, String attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public void setAttribute(QName attributeName, String attributeValue) {
        this.attributes.put(this.makeStringFromQName(attributeName), attributeValue);
    }

    public String getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public HashMap<String, String> getAttributes() {
        return this.attributes;
    }

    public String getStringName() {
        return this.makeStringFromQName(this.name);
    }

    private String makeStringFromQName(QName qname) {
        StringBuilder str = new StringBuilder();
        if (qname.getPrefix() != null && qname.getPrefix().length() > 0) {
            str.append(qname.getPrefix());
            str.append(":");
        }
        return str.append(qname.getLocalPart()).toString();
    }
}

