/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date;

import java.util.Calendar;
import java.util.Date;
import org.exparity.hamcrest.date.DateFormatter;
import org.exparity.hamcrest.date.DayMonthYear;
import org.exparity.hamcrest.date.Months;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsBefore
extends TypeSafeDiagnosingMatcher<Date> {
    private final Date expected;

    public IsBefore(Date expected) {
        this.expected = expected;
    }

    protected boolean matchesSafely(Date actual, Description mismatchDesc) {
        if (this.expected.compareTo(actual) <= 0) {
            mismatchDesc.appendText("date is ").appendValue((Object)DateFormatter.formatDateWithMillis(actual));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the date is before ").appendValue((Object)DateFormatter.formatDateWithMillis(this.expected));
    }

    @Factory
    public static Matcher<Date> before(Date date) {
        return new IsBefore(date);
    }

    @Factory
    public static Matcher<Date> before(DayMonthYear date) {
        return IsBefore.before(date.getYear(), date.getMonth(), date.getDay());
    }

    @Factory
    public static Matcher<Date> before(int year, Months month, int day) {
        return IsBefore.before(year, month, day, 0, 0, 0);
    }

    @Factory
    public static Matcher<Date> before(int year, Months month, int date, int hour, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month.calendarConstant(), date, hour, minute, second);
        calendar.set(14, 0);
        return new IsBefore(calendar.getTime());
    }
}

