/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date;

import java.util.Calendar;
import java.util.Date;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IsMaximumDatePart
extends TypeSafeDiagnosingMatcher<Date> {
    private final int datePart;
    private final String datePartName;

    @Factory
    public static Matcher<Date> maximumDatePart(int datePart, String descriptionOfDatepart) {
        return new IsMaximumDatePart(datePart, descriptionOfDatepart);
    }

    public IsMaximumDatePart(int datePart, String datePartName) {
        this.datePart = datePart;
        this.datePartName = datePartName;
    }

    protected boolean matchesSafely(Date actual, Description mismatchDesc) {
        int actualDatePart = IsMaximumDatePart.extractDatePart(actual, this.datePart);
        int expected = IsMaximumDatePart.extractMinimumValue(actual, this.datePart);
        if (expected != actualDatePart) {
            mismatchDesc.appendText(String.valueOf(this.datePartName)).appendText(" is ").appendValue((Object)actualDatePart);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the last " + this.datePartName + " value");
    }

    private static int extractDatePart(Date date, int part) {
        return IsMaximumDatePart.convertDateToCalendar(date).get(part);
    }

    private static int extractMinimumValue(Date date, int part) {
        return IsMaximumDatePart.convertDateToCalendar(date).getActualMaximum(part);
    }

    private static Calendar convertDateToCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }
}

