/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.temporal.TemporalField;
import java.time.temporal.ValueRange;
import java.util.Locale;
import org.exparity.hamcrest.date.core.TemporalAdapter;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsMaximum<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final TemporalAdapter<T> adapter;
    private final TemporalField datePart;
    private final String datePartName;

    public IsMaximum(TemporalField datePart, TemporalAdapter<T> adapter) {
        this.adapter = adapter;
        this.datePart = datePart;
        this.datePartName = datePart.getDisplayName(Locale.getDefault());
    }

    protected boolean matchesSafely(T actual, Description mismatchDesc) {
        long actualValue = this.datePart.getFrom(this.adapter.asTemporal(actual));
        ValueRange range = this.datePart.rangeRefinedBy(this.adapter.asTemporal(actual));
        if (range.getMaximum() == actualValue) {
            return true;
        }
        mismatchDesc.appendText("value is " + actualValue + " instead of " + range.getMaximum());
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("the maximum value of " + this.datePartName);
    }
}

