/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.temporal.ChronoField;
import org.exparity.hamcrest.date.core.TemporalAdapter;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsMinute<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final int expected;
    private final TemporalAdapter<T> accessor;

    public IsMinute(int expected, TemporalAdapter<T> accessor) {
        this.expected = expected;
        this.accessor = accessor;
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        int actualMinute = this.accessor.asTemporal(actual).get(ChronoField.MINUTE_OF_HOUR);
        if (this.expected == actualMinute) {
            return true;
        }
        mismatchDescription.appendText("the date has the minute " + actualMinute);
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("the date has the minute " + this.expected);
    }
}

