/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalField;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.exparity.hamcrest.date.DayMonthYear;
import org.exparity.hamcrest.date.Months;
import org.exparity.hamcrest.date.Weekdays;
import org.exparity.hamcrest.date.core.IsAfter;
import org.exparity.hamcrest.date.core.IsBefore;
import org.exparity.hamcrest.date.core.IsDayOfMonth;
import org.exparity.hamcrest.date.core.IsDayOfWeek;
import org.exparity.hamcrest.date.core.IsHour;
import org.exparity.hamcrest.date.core.IsLeapYear;
import org.exparity.hamcrest.date.core.IsMaximum;
import org.exparity.hamcrest.date.core.IsMillisecond;
import org.exparity.hamcrest.date.core.IsMinimum;
import org.exparity.hamcrest.date.core.IsMinute;
import org.exparity.hamcrest.date.core.IsMonth;
import org.exparity.hamcrest.date.core.IsSame;
import org.exparity.hamcrest.date.core.IsSameDay;
import org.exparity.hamcrest.date.core.IsSameOrAfter;
import org.exparity.hamcrest.date.core.IsSameOrBefore;
import org.exparity.hamcrest.date.core.IsSecond;
import org.exparity.hamcrest.date.core.IsWithin;
import org.exparity.hamcrest.date.core.IsYear;
import org.exparity.hamcrest.date.core.format.DateFormatter;
import org.exparity.hamcrest.date.core.wrapper.DateWrapper;
import org.hamcrest.Matcher;

public abstract class DateMatchers {
    public static Matcher<Date> after(Date date) {
        return new IsAfter<Date>(new DateWrapper(date), new DateFormatter());
    }

    @Deprecated
    public static Matcher<Date> after(DayMonthYear date) {
        return DateMatchers.after(date.toLocalDate());
    }

    public static Matcher<Date> after(LocalDate date) {
        return new IsAfter<Date>(new DateWrapper(date), new DateFormatter());
    }

    @Deprecated
    public static Matcher<Date> after(int year, Months month, int day) {
        return new IsAfter<Date>(new DateWrapper(year, month.month(), day), new DateFormatter());
    }

    public static Matcher<Date> after(int year, Month month, int day) {
        return new IsAfter<Date>(new DateWrapper(year, month, day), new DateFormatter());
    }

    @Deprecated
    public static Matcher<Date> after(int year, Months month, int dayOfMonth, int hour, int minute, int second) {
        return DateMatchers.after(year, month.month(), dayOfMonth, hour, minute, second);
    }

    public static Matcher<Date> after(int year, Month month, int dayOfMonth, int hour, int minute, int second) {
        return new IsAfter<Date>(new DateWrapper(year, month, dayOfMonth, hour, minute, second), new DateFormatter());
    }

    public static Matcher<Date> before(Date date) {
        return new IsBefore<Date>(new DateWrapper(date), new DateFormatter());
    }

    public static Matcher<Date> before(LocalDate date) {
        return new IsBefore<Date>(new DateWrapper(date), new DateFormatter());
    }

    @Deprecated
    public static Matcher<Date> before(DayMonthYear date) {
        return DateMatchers.before(date.toLocalDate());
    }

    @Deprecated
    public static Matcher<Date> before(int year, Months month, int dayOfMonth) {
        return new IsBefore<Date>(new DateWrapper(year, month.month(), dayOfMonth), new DateFormatter());
    }

    public static Matcher<Date> before(int year, Month month, int dayOfMonth) {
        return new IsBefore<Date>(new DateWrapper(year, month, dayOfMonth), new DateFormatter());
    }

    @Deprecated
    public static Matcher<Date> before(int year, Months month, int dayOfMonth, int hour, int minute, int second) {
        return DateMatchers.before(year, month.month(), dayOfMonth, hour, minute, second);
    }

    public static Matcher<Date> before(int year, Month month, int dayOfMonth, int hour, int minute, int second) {
        return new IsBefore<Date>(new DateWrapper(year, month, dayOfMonth, hour, minute, second), new DateFormatter());
    }

    public static Matcher<Date> sameDayOfWeek(Date date) {
        return DateMatchers.isDayOfWeek(DayOfWeek.from(date.toInstant().atZone(ZoneId.systemDefault())));
    }

    @Deprecated
    public static Matcher<Date> isDayOfWeek(Weekdays dayOfWeek) {
        return new IsDayOfWeek<Date>(Arrays.asList(dayOfWeek.getAsDayOfWeek()), DateMatchers::dateToZoneDateTime);
    }

    public static Matcher<Date> isDayOfWeek(DayOfWeek ... daysOfWeek) {
        return new IsDayOfWeek<Date>(Arrays.asList(daysOfWeek), DateMatchers::dateToZoneDateTime);
    }

    public static Matcher<Date> sameDayOfMonth(Date date) {
        return DateMatchers.isDayOfMonth(DateMatchers.extractField(date, ChronoField.DAY_OF_MONTH));
    }

    public static Matcher<Date> isDayOfMonth(int dayOfMonth) {
        return new IsDayOfMonth<Date>(dayOfMonth, DateMatchers::dateToZoneDateTime);
    }

    public static Matcher<Date> sameDay(Date date) {
        return new IsSameDay<Date>(new DateWrapper(date), new DateFormatter());
    }

    @Deprecated
    public static Matcher<Date> sameDay(DayMonthYear date) {
        return DateMatchers.sameDay(date.toLocalDate());
    }

    public static Matcher<Date> sameDay(LocalDate date) {
        return new IsSameDay<Date>(new DateWrapper(date), new DateFormatter());
    }

    @Deprecated
    public static Matcher<Date> sameDay(int year, Months month, int day) {
        return DateMatchers.isDay(year, month.month(), day);
    }

    public static Matcher<Date> isDay(int year, Month month, int dayOfMonth) {
        return DateMatchers.sameDay(LocalDate.of(year, month, dayOfMonth));
    }

    @Deprecated
    public static Matcher<Date> sameHour(Date date) {
        return DateMatchers.sameHourOfDay(date);
    }

    public static Matcher<Date> sameHourOfDay(Date date) {
        return DateMatchers.isHour(DateMatchers.extractField(date, ChronoField.HOUR_OF_DAY));
    }

    @Deprecated
    public static Matcher<Date> sameHour(int hour) {
        return DateMatchers.isHour(hour);
    }

    public static Matcher<Date> isHour(int hour) {
        return new IsHour<Date>(hour, DateMatchers::dateToZoneDateTime);
    }

    public static Matcher<Date> sameInstant(Date date) {
        return new IsSame<Date>(new DateWrapper(date), new DateFormatter());
    }

    public static Matcher<Date> sameInstant(long timestamp) {
        return new IsSame<Date>(new DateWrapper(new Date(timestamp)), new DateFormatter());
    }

    @Deprecated
    public static Matcher<Date> sameInstant(int year, Months month, int dayOfMonth, int hour, int minute, int second, int milliseconds) {
        return DateMatchers.isInstant(year, month.month(), dayOfMonth, hour, minute, second, milliseconds);
    }

    public static Matcher<Date> isInstant(int year, Month month, int dayOfMonth, int hour, int minute, int second, int milliseconds) {
        return new IsSame<Date>(new DateWrapper(year, month, dayOfMonth, hour, minute, second, milliseconds), new DateFormatter());
    }

    public static Matcher<Date> sameOrBefore(Date date) {
        return new IsSameOrBefore<Date>(new DateWrapper(date), new DateFormatter());
    }

    public static Matcher<Date> sameOrBefore(LocalDate date) {
        return new IsSameOrBefore<Date>(new DateWrapper(date), new DateFormatter());
    }

    @Deprecated
    public static Matcher<Date> sameOrBefore(DayMonthYear date) {
        return DateMatchers.sameOrBefore(date.toLocalDate());
    }

    @Deprecated
    public static Matcher<Date> sameOrBefore(int year, Months month, int dayOfMonth) {
        return DateMatchers.sameOrBefore(year, month.month(), dayOfMonth);
    }

    public static Matcher<Date> sameOrBefore(int year, Month month, int dayOfMonth) {
        return new IsSameOrBefore<Date>(new DateWrapper(LocalDate.of(year, month, dayOfMonth)), new DateFormatter());
    }

    @Deprecated
    public static Matcher<Date> sameOrBefore(int year, Months month, int dayOfMonth, int hour, int minute, int second) {
        return DateMatchers.sameOrBefore(year, month.month(), dayOfMonth, hour, minute, second);
    }

    public static Matcher<Date> sameOrBefore(int year, Month month, int dayOfMonth, int hour, int minute, int second) {
        return new IsSameOrBefore<Date>(new DateWrapper(year, month, dayOfMonth, hour, minute, second), new DateFormatter());
    }

    public static Matcher<Date> sameOrAfter(Date date) {
        return new IsSameOrAfter<Date>(new DateWrapper(date), new DateFormatter());
    }

    public static Matcher<Date> sameOrAfter(LocalDate date) {
        return new IsSameOrAfter<Date>(new DateWrapper(date), new DateFormatter());
    }

    @Deprecated
    public static Matcher<Date> sameOrAfter(DayMonthYear date) {
        return DateMatchers.sameOrAfter(date.toLocalDate());
    }

    @Deprecated
    public static Matcher<Date> sameOrAfter(int year, Months month, int dayOfMonth) {
        return DateMatchers.sameOrAfter(year, month.month(), dayOfMonth);
    }

    public static Matcher<Date> sameOrAfter(int year, Month month, int dayOfMonth) {
        return new IsSameOrAfter<Date>(new DateWrapper(year, month, dayOfMonth), new DateFormatter());
    }

    @Deprecated
    public static Matcher<Date> sameOrAfter(int year, Months month, int dayOfMonth, int hour, int minute, int second) {
        return DateMatchers.sameOrAfter(year, month.month(), dayOfMonth, hour, minute, second);
    }

    public static Matcher<Date> sameOrAfter(int year, Month month, int dayOfMonth, int hour, int minute, int second) {
        return new IsSameOrAfter<Date>(new DateWrapper(year, month, dayOfMonth, hour, minute, second), new DateFormatter());
    }

    @Deprecated
    public static Matcher<Date> sameMinute(Date date) {
        return DateMatchers.sameMinuteOfHour(date);
    }

    public static Matcher<Date> sameMinuteOfHour(Date date) {
        return DateMatchers.isMinute(DateMatchers.extractField(date, ChronoField.MINUTE_OF_HOUR));
    }

    @Deprecated
    public static Matcher<Date> sameMinute(int minute) {
        return DateMatchers.isMinute(minute);
    }

    public static Matcher<Date> isMinute(int minute) {
        return new IsMinute<Date>(minute, DateMatchers::dateToZoneDateTime);
    }

    @Deprecated
    public static Matcher<Date> sameMonth(Date date) {
        return DateMatchers.sameMonthOfYear(date);
    }

    public static Matcher<Date> sameMonthOfYear(Date date) {
        return DateMatchers.isMonth(Month.of(date.toInstant().atZone(ZoneId.systemDefault()).get(ChronoField.MONTH_OF_YEAR)));
    }

    @Deprecated
    public static Matcher<Date> sameMonth(Months month) {
        return DateMatchers.sameMonthOfYear(month);
    }

    @Deprecated
    public static Matcher<Date> sameMonthOfYear(Months month) {
        return DateMatchers.isMonth(month.month());
    }

    @Deprecated
    public static Matcher<Date> sameSecond(Date date) {
        return DateMatchers.sameSecondOfMinute(date);
    }

    public static Matcher<Date> sameSecondOfMinute(Date date) {
        return DateMatchers.isSecond(DateMatchers.extractField(date, ChronoField.SECOND_OF_MINUTE));
    }

    @Deprecated
    public static Matcher<Date> sameSecond(int second) {
        return DateMatchers.isSecond(second);
    }

    public static Matcher<Date> isSecond(int second) {
        return new IsSecond<Date>(second, DateMatchers::dateToZoneDateTime);
    }

    @Deprecated
    public static Matcher<Date> sameMillisecond(Date date) {
        return DateMatchers.sameMillisecondOfSecond(date);
    }

    public static Matcher<Date> sameMillisecondOfSecond(Date date) {
        return DateMatchers.isMillisecond(DateMatchers.extractField(date, ChronoField.MILLI_OF_SECOND));
    }

    @Deprecated
    public static Matcher<Date> sameMillisecond(int millisecond) {
        return DateMatchers.isMillisecond(millisecond);
    }

    public static Matcher<Date> isMillisecond(int millisecond) {
        return new IsMillisecond<Date>(millisecond, DateMatchers::dateToZoneDateTime);
    }

    public static Matcher<Date> sameYear(Date date) {
        return DateMatchers.isYear(DateMatchers.extractField(date, ChronoField.YEAR));
    }

    public static Matcher<Date> isYear(int year) {
        return new IsYear<Date>(year, DateMatchers::dateToZoneDateTime);
    }

    @Deprecated
    public static Matcher<Date> within(long period, TimeUnit unit, Date date) {
        return DateMatchers.within(period, DateMatchers.convertUnit(unit), date);
    }

    public static Matcher<Date> within(long period, ChronoUnit unit, Date date) {
        return new IsWithin<Date>(period, unit, new DateWrapper(date), new DateFormatter());
    }

    public static Matcher<Date> within(long period, ChronoUnit unit, LocalDate date) {
        return new IsWithin<Date>(period, unit, new DateWrapper(date), new DateFormatter());
    }

    @Deprecated
    public static Matcher<Date> within(long period, TimeUnit unit, DayMonthYear date) {
        return DateMatchers.within(period, DateMatchers.convertUnit(unit), date.toLocalDate());
    }

    @Deprecated
    public static Matcher<Date> within(long period, TimeUnit unit, int year, Months month, int dayOfMonth) {
        return DateMatchers.within(period, DateMatchers.convertUnit(unit), year, month.month(), dayOfMonth);
    }

    public static Matcher<Date> within(long period, ChronoUnit unit, int year, Month month, int dayOfMonth) {
        return DateMatchers.within(period, unit, LocalDate.of(year, month, dayOfMonth));
    }

    @Deprecated
    public static Matcher<Date> within(long period, TimeUnit unit, int year, Months month, int dayOfMonth, int hour, int minute, int second, int milliseconds) {
        return DateMatchers.within(period, DateMatchers.convertUnit(unit), year, month.month(), dayOfMonth, hour, minute, second, milliseconds);
    }

    public static Matcher<Date> within(long period, ChronoUnit unit, int year, Month month, int dayOfMonth, int hour, int minute, int second, int milliseconds) {
        return new IsWithin<Date>(period, unit, new DateWrapper(year, month, dayOfMonth, hour, minute, second, milliseconds), new DateFormatter());
    }

    public static Matcher<Date> isYesterday() {
        return DateMatchers.sameDay(LocalDate.now().minusDays(1L));
    }

    public static Matcher<Date> isToday() {
        return DateMatchers.sameDay(LocalDate.now());
    }

    public static Matcher<Date> isTomorrow() {
        return DateMatchers.sameDay(LocalDate.now().plusDays(1L));
    }

    public static Matcher<Date> isMonday() {
        return new IsDayOfWeek<Date>(DayOfWeek.MONDAY, DateMatchers::dateToZoneDateTime);
    }

    public static Matcher<Date> isTuesday() {
        return new IsDayOfWeek<Date>(DayOfWeek.TUESDAY, DateMatchers::dateToZoneDateTime);
    }

    public static Matcher<Date> isWednesday() {
        return new IsDayOfWeek<Date>(DayOfWeek.WEDNESDAY, DateMatchers::dateToZoneDateTime);
    }

    public static Matcher<Date> isThursday() {
        return new IsDayOfWeek<Date>(DayOfWeek.THURSDAY, DateMatchers::dateToZoneDateTime);
    }

    public static Matcher<Date> isFriday() {
        return new IsDayOfWeek<Date>(DayOfWeek.FRIDAY, DateMatchers::dateToZoneDateTime);
    }

    public static Matcher<Date> isSaturday() {
        return new IsDayOfWeek<Date>(DayOfWeek.SATURDAY, DateMatchers::dateToZoneDateTime);
    }

    public static Matcher<Date> isSunday() {
        return new IsDayOfWeek<Date>(DayOfWeek.SUNDAY, DateMatchers::dateToZoneDateTime);
    }

    public static Matcher<Date> isWeekday() {
        return DateMatchers.isDayOfWeek(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    }

    public static Matcher<Date> isWeekend() {
        return DateMatchers.isDayOfWeek(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public static Matcher<Date> isFirstDayOfMonth() {
        return DateMatchers.isMinimum(ChronoField.DAY_OF_MONTH);
    }

    public static Matcher<Date> isMinimum(TemporalField field) {
        return new IsMinimum<Date>(field, DateMatchers::dateToZoneDateTime);
    }

    public static Matcher<Date> isLastDayOfMonth() {
        return DateMatchers.isMaximum(ChronoField.DAY_OF_MONTH);
    }

    public static Matcher<Date> isMaximum(TemporalField field) {
        return new IsMaximum<Date>(field, DateMatchers::dateToZoneDateTime);
    }

    public static Matcher<Date> isMonth(Month month) {
        return new IsMonth<Date>(month, DateMatchers::dateToZoneDateTime);
    }

    public static Matcher<Date> isJanuary() {
        return DateMatchers.isMonth(Month.JANUARY);
    }

    public static Matcher<Date> isFebruary() {
        return DateMatchers.isMonth(Month.FEBRUARY);
    }

    public static Matcher<Date> isMarch() {
        return DateMatchers.isMonth(Month.MARCH);
    }

    public static Matcher<Date> isApril() {
        return DateMatchers.isMonth(Month.APRIL);
    }

    public static Matcher<Date> isMay() {
        return DateMatchers.isMonth(Month.MAY);
    }

    public static Matcher<Date> isJune() {
        return DateMatchers.isMonth(Month.JUNE);
    }

    public static Matcher<Date> isJuly() {
        return DateMatchers.isMonth(Month.JULY);
    }

    public static Matcher<Date> isAugust() {
        return DateMatchers.isMonth(Month.AUGUST);
    }

    public static Matcher<Date> isSeptember() {
        return DateMatchers.isMonth(Month.SEPTEMBER);
    }

    public static Matcher<Date> isOctober() {
        return DateMatchers.isMonth(Month.OCTOBER);
    }

    public static Matcher<Date> isNovember() {
        return DateMatchers.isMonth(Month.NOVEMBER);
    }

    public static Matcher<Date> isDecember() {
        return DateMatchers.isMonth(Month.DECEMBER);
    }

    public static Matcher<Date> isLeapYear() {
        return new IsLeapYear<Date>(DateMatchers::dateToZoneDateTime, new DateFormatter());
    }

    private static ChronoUnit convertUnit(TimeUnit unit) {
        switch (unit) {
            case DAYS: {
                return ChronoUnit.DAYS;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
        }
        throw new IllegalArgumentException("Unknown TimeUnit '" + (Object)((Object)unit) + "'");
    }

    private static int extractField(Date date, ChronoField field) {
        return DateMatchers.dateToZoneDateTime(date).get(field);
    }

    private static Temporal dateToZoneDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault());
    }
}

