/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalField;
import java.util.Arrays;
import org.exparity.hamcrest.date.core.IsAfter;
import org.exparity.hamcrest.date.core.IsBefore;
import org.exparity.hamcrest.date.core.IsDayOfMonth;
import org.exparity.hamcrest.date.core.IsDayOfWeek;
import org.exparity.hamcrest.date.core.IsHour;
import org.exparity.hamcrest.date.core.IsLeapYear;
import org.exparity.hamcrest.date.core.IsMaximum;
import org.exparity.hamcrest.date.core.IsMinimum;
import org.exparity.hamcrest.date.core.IsMinute;
import org.exparity.hamcrest.date.core.IsMonth;
import org.exparity.hamcrest.date.core.IsSame;
import org.exparity.hamcrest.date.core.IsSameDay;
import org.exparity.hamcrest.date.core.IsSameOrAfter;
import org.exparity.hamcrest.date.core.IsSameOrBefore;
import org.exparity.hamcrest.date.core.IsSecond;
import org.exparity.hamcrest.date.core.IsWithin;
import org.exparity.hamcrest.date.core.IsYear;
import org.exparity.hamcrest.date.core.format.LocalDateTimeFormatter;
import org.exparity.hamcrest.date.core.wrapper.LocalDateTimeWrapper;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public abstract class LocalDateTimeMatchers {
    public static Matcher<LocalDateTime> after(LocalDateTime date) {
        return new IsAfter<LocalDateTime>(new LocalDateTimeWrapper(date), new LocalDateTimeFormatter());
    }

    public static Matcher<LocalDateTime> after(int year, Month month, int dayOfMonth, int hour, int minute, int second) {
        return new IsAfter<LocalDateTime>(new LocalDateTimeWrapper(year, month, dayOfMonth, hour, minute, second), new LocalDateTimeFormatter());
    }

    public static Matcher<LocalDateTime> before(LocalDateTime date) {
        return new IsBefore<LocalDateTime>(new LocalDateTimeWrapper(date), new LocalDateTimeFormatter());
    }

    public static Matcher<LocalDateTime> before(int year, Month month, int dayOfMonth, int hour, int minute, int second) {
        return new IsBefore<LocalDateTime>(new LocalDateTimeWrapper(year, month, dayOfMonth, hour, minute, second), new LocalDateTimeFormatter());
    }

    public static Matcher<LocalDateTime> sameDay(LocalDateTime date) {
        return new IsSameDay<LocalDateTime>(new LocalDateTimeWrapper(date), new LocalDateTimeFormatter());
    }

    public static Matcher<LocalDateTime> isDay(int year, Month month, int dayOfMonth) {
        return new IsSameDay<LocalDateTime>(new LocalDateTimeWrapper(year, month, dayOfMonth), new LocalDateTimeFormatter());
    }

    public static Matcher<LocalDateTime> sameInstant(LocalDateTime date) {
        return new IsSame<LocalDateTime>(new LocalDateTimeWrapper(date), new LocalDateTimeFormatter());
    }

    public static Matcher<LocalDateTime> isInstant(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanos) {
        return new IsSame<LocalDateTime>(new LocalDateTimeWrapper(year, month, dayOfMonth, hour, minute, second, nanos), new LocalDateTimeFormatter());
    }

    public static Matcher<LocalDateTime> sameOrBefore(LocalDateTime date) {
        return new IsSameOrBefore<LocalDateTime>(new LocalDateTimeWrapper(date), new LocalDateTimeFormatter());
    }

    @Factory
    public static Matcher<LocalDateTime> sameOrBefore(int year, Month month, int day, int hour, int minute, int second) {
        return new IsSameOrBefore<LocalDateTime>(new LocalDateTimeWrapper(year, month, day, hour, minute, second), new LocalDateTimeFormatter());
    }

    public static Matcher<LocalDateTime> sameOrAfter(LocalDateTime date) {
        return new IsSameOrAfter<LocalDateTime>(new LocalDateTimeWrapper(date), new LocalDateTimeFormatter());
    }

    public static Matcher<LocalDateTime> sameOrAfter(int year, Month month, int day, int hour, int minute, int second) {
        return LocalDateTimeMatchers.sameOrAfter(LocalDateTime.of(year, month, day, hour, minute, second));
    }

    public static Matcher<LocalDateTime> sameMonthOfYear(LocalDateTime date) {
        return LocalDateTimeMatchers.isMonth(date.getMonth());
    }

    public static Matcher<LocalDateTime> sameDayOfMonth(LocalDateTime date) {
        return LocalDateTimeMatchers.isDayOfMonth(date.getDayOfMonth());
    }

    public static Matcher<LocalDateTime> isDayOfMonth(int dayOfMonth) {
        return new IsDayOfMonth<LocalDateTime>(dayOfMonth, t -> t);
    }

    public static Matcher<LocalDateTime> sameYear(LocalDateTime date) {
        return LocalDateTimeMatchers.isYear(date.getYear());
    }

    public static Matcher<LocalDateTime> isYear(int year) {
        return new IsYear<LocalDateTime>(year, t -> t);
    }

    public static Matcher<LocalDateTime> within(long period, ChronoUnit unit, LocalDateTime date) {
        return new IsWithin<LocalDateTime>(period, unit, new LocalDateTimeWrapper(date), new LocalDateTimeFormatter());
    }

    public static Matcher<LocalDateTime> within(long period, ChronoUnit unit, int year, Month month, int dayofMonth, int hour, int minute, int second, int nanos) {
        return new IsWithin<LocalDateTime>(period, unit, new LocalDateTimeWrapper(year, month, dayofMonth, hour, minute, second, nanos), new LocalDateTimeFormatter());
    }

    public static Matcher<LocalDateTime> isYesterday() {
        return LocalDateTimeMatchers.sameDay(LocalDateTime.now().minusDays(1L));
    }

    public static Matcher<LocalDateTime> isToday() {
        return LocalDateTimeMatchers.sameDay(LocalDateTime.now());
    }

    public static Matcher<LocalDateTime> isTomorrow() {
        return LocalDateTimeMatchers.sameDay(LocalDateTime.now().plusDays(1L));
    }

    public static Matcher<LocalDateTime> sameDayOfWeek(LocalDateTime date) {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.from(date));
    }

    public static Matcher<LocalDateTime> isDayOfWeek(DayOfWeek ... dayOfWeek) {
        return new IsDayOfWeek<LocalDateTime>(Arrays.asList(dayOfWeek), t -> t);
    }

    public static Matcher<LocalDateTime> isMonday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.MONDAY);
    }

    public static Matcher<LocalDateTime> isTuesday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.TUESDAY);
    }

    public static Matcher<LocalDateTime> isWednesday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.WEDNESDAY);
    }

    public static Matcher<LocalDateTime> isThursday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.THURSDAY);
    }

    public static Matcher<LocalDateTime> isFriday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.FRIDAY);
    }

    public static Matcher<LocalDateTime> isSaturday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.SATURDAY);
    }

    public static Matcher<LocalDateTime> isSunday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.SUNDAY);
    }

    public static Matcher<LocalDateTime> isWeekday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    }

    public static Matcher<LocalDateTime> isWeekend() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public static Matcher<LocalDateTime> isFirstDayOfMonth() {
        return LocalDateTimeMatchers.isMinimum(ChronoField.DAY_OF_MONTH);
    }

    public static Matcher<LocalDateTime> isMinimum(TemporalField field) {
        return new IsMinimum<LocalDateTime>(field, t -> t);
    }

    public static Matcher<LocalDateTime> isLastDayOfMonth() {
        return LocalDateTimeMatchers.isMaximum(ChronoField.DAY_OF_MONTH);
    }

    public static Matcher<LocalDateTime> isMaximum(TemporalField field) {
        return new IsMaximum<LocalDateTime>(field, t -> t);
    }

    public static Matcher<LocalDateTime> isMonth(Month month) {
        return new IsMonth<LocalDateTime>(month, t -> t);
    }

    public static Matcher<LocalDateTime> isJanuary() {
        return LocalDateTimeMatchers.isMonth(Month.JANUARY);
    }

    public static Matcher<LocalDateTime> isFebruary() {
        return LocalDateTimeMatchers.isMonth(Month.FEBRUARY);
    }

    public static Matcher<LocalDateTime> isMarch() {
        return LocalDateTimeMatchers.isMonth(Month.MARCH);
    }

    public static Matcher<LocalDateTime> isApril() {
        return LocalDateTimeMatchers.isMonth(Month.APRIL);
    }

    public static Matcher<LocalDateTime> isMay() {
        return LocalDateTimeMatchers.isMonth(Month.MAY);
    }

    public static Matcher<LocalDateTime> isJune() {
        return LocalDateTimeMatchers.isMonth(Month.JUNE);
    }

    public static Matcher<LocalDateTime> isJuly() {
        return LocalDateTimeMatchers.isMonth(Month.JULY);
    }

    public static Matcher<LocalDateTime> isAugust() {
        return LocalDateTimeMatchers.isMonth(Month.AUGUST);
    }

    public static Matcher<LocalDateTime> isSeptember() {
        return LocalDateTimeMatchers.isMonth(Month.SEPTEMBER);
    }

    public static Matcher<LocalDateTime> isOctober() {
        return LocalDateTimeMatchers.isMonth(Month.OCTOBER);
    }

    public static Matcher<LocalDateTime> isNovember() {
        return LocalDateTimeMatchers.isMonth(Month.NOVEMBER);
    }

    public static Matcher<LocalDateTime> isDecember() {
        return LocalDateTimeMatchers.isMonth(Month.DECEMBER);
    }

    public static Matcher<LocalDateTime> isLeapYear() {
        return new IsLeapYear<LocalDateTime>(t -> t, new LocalDateTimeFormatter());
    }

    public static Matcher<LocalDateTime> isHour(int hour) {
        return new IsHour<LocalDateTime>(hour, t -> t);
    }

    public static Matcher<LocalDateTime> sameHourOfDay(LocalDateTime date) {
        return LocalDateTimeMatchers.isHour(date.getHour());
    }

    public static Matcher<LocalDateTime> isMinute(int minute) {
        return new IsMinute<LocalDateTime>(minute, t -> t);
    }

    public static Matcher<LocalDateTime> sameMinuteOfHour(LocalDateTime date) {
        return LocalDateTimeMatchers.isMinute(date.getMinute());
    }

    public static Matcher<LocalDateTime> isSecond(int Second) {
        return new IsSecond<LocalDateTime>(Second, t -> t);
    }

    public static Matcher<LocalDateTime> sameSecondOfMinute(LocalDateTime date) {
        return LocalDateTimeMatchers.isSecond(date.getSecond());
    }
}

