/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.temporal.ChronoField;
import org.exparity.hamcrest.date.core.TemporalAdapter;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsDayOfMonth<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final int expected;
    private final TemporalAdapter<T> adapter;

    public IsDayOfMonth(int expected, TemporalAdapter<T> adapter) {
        this.expected = expected;
        this.adapter = adapter;
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        int actualValue = this.adapter.asTemporal(actual).get(ChronoField.DAY_OF_MONTH);
        if (this.expected == actualValue) {
            return true;
        }
        mismatchDescription.appendText("the date has the day of the month " + actualValue);
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("the date has the day of the month " + this.expected);
    }
}

