/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import org.exparity.hamcrest.date.core.TemporalFormatter;
import org.exparity.hamcrest.date.core.TemporalWrapper;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsSameOrBefore<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final TemporalWrapper<T> expected;
    private final TemporalFormatter<T> describer;

    public IsSameOrBefore(TemporalWrapper<T> expected, TemporalFormatter<T> describer) {
        this.expected = expected;
        this.describer = describer;
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        if (this.expected.isBefore(actual)) {
            mismatchDescription.appendText("date is " + this.describer.describe(actual));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the date is on same day or before " + this.describer.describe(this.expected.unwrap()));
    }
}

