/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalField;
import java.util.Arrays;
import org.exparity.hamcrest.date.core.IsAfter;
import org.exparity.hamcrest.date.core.IsBefore;
import org.exparity.hamcrest.date.core.IsDayOfMonth;
import org.exparity.hamcrest.date.core.IsDayOfWeek;
import org.exparity.hamcrest.date.core.IsLeapYear;
import org.exparity.hamcrest.date.core.IsMaximum;
import org.exparity.hamcrest.date.core.IsMinimum;
import org.exparity.hamcrest.date.core.IsMonth;
import org.exparity.hamcrest.date.core.IsSameDay;
import org.exparity.hamcrest.date.core.IsSameOrAfter;
import org.exparity.hamcrest.date.core.IsSameOrBefore;
import org.exparity.hamcrest.date.core.IsWithin;
import org.exparity.hamcrest.date.core.IsYear;
import org.exparity.hamcrest.date.core.format.LocalDateFormatter;
import org.exparity.hamcrest.date.core.wrapper.LocalDateWrapper;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public abstract class LocalDateMatchers {
    public static Matcher<LocalDate> after(LocalDate date) {
        return new IsAfter<LocalDate>(new LocalDateWrapper(date), new LocalDateFormatter());
    }

    public static Matcher<LocalDate> after(int year, Month month, int dayOfMonth) {
        return LocalDateMatchers.after(LocalDate.of(year, month, dayOfMonth));
    }

    public static Matcher<LocalDate> before(LocalDate date) {
        return new IsBefore<LocalDate>(new LocalDateWrapper(date), new LocalDateFormatter());
    }

    public static Matcher<LocalDate> before(int year, Month month, int dayOfMonth) {
        return LocalDateMatchers.before(LocalDate.of(year, month, dayOfMonth));
    }

    public static Matcher<LocalDate> sameDay(LocalDate date) {
        return new IsSameDay<LocalDate>(new LocalDateWrapper(date), new LocalDateFormatter());
    }

    public static Matcher<LocalDate> isDay(int year, Month month, int dayOfMonth) {
        return LocalDateMatchers.sameDay(LocalDate.of(year, month, dayOfMonth));
    }

    public static Matcher<LocalDate> sameOrBefore(LocalDate date) {
        return new IsSameOrBefore<LocalDate>(new LocalDateWrapper(date), new LocalDateFormatter());
    }

    @Factory
    public static Matcher<LocalDate> sameOrBefore(int year, Month month, int day) {
        return LocalDateMatchers.sameOrBefore(LocalDate.of(year, month, day));
    }

    public static Matcher<LocalDate> sameOrAfter(LocalDate date) {
        return new IsSameOrAfter<LocalDate>(new LocalDateWrapper(date), new LocalDateFormatter());
    }

    public static Matcher<LocalDate> sameOrAfter(int year, Month month, int day) {
        return LocalDateMatchers.sameOrAfter(LocalDate.of(year, month, day));
    }

    public static Matcher<LocalDate> sameMonthOfYear(LocalDate date) {
        return LocalDateMatchers.isMonth(date.getMonth());
    }

    public static Matcher<LocalDate> sameDayOfMonth(LocalDate date) {
        return LocalDateMatchers.isDayOfMonth(date.getDayOfMonth());
    }

    public static Matcher<LocalDate> isDayOfMonth(int dayOfMonth) {
        return new IsDayOfMonth<LocalDate>(dayOfMonth, t -> t);
    }

    public static Matcher<LocalDate> sameYear(LocalDate date) {
        return LocalDateMatchers.isYear(date.getYear());
    }

    public static Matcher<LocalDate> isYear(int year) {
        return new IsYear<LocalDate>(year, t -> t);
    }

    public static Matcher<LocalDate> within(long period, ChronoUnit unit, LocalDate date) {
        return new IsWithin<LocalDate>(period, unit, new LocalDateWrapper(date), new LocalDateFormatter());
    }

    public static Matcher<LocalDate> within(long period, ChronoUnit unit, int year, Month month, int dayofMonth) {
        return LocalDateMatchers.within(period, unit, LocalDate.of(year, month, dayofMonth));
    }

    public static Matcher<LocalDate> isYesterday() {
        return LocalDateMatchers.sameDay(LocalDate.now().plusDays(-1L));
    }

    public static Matcher<LocalDate> isToday() {
        return LocalDateMatchers.sameDay(LocalDate.now());
    }

    public static Matcher<LocalDate> isTomorrow() {
        return LocalDateMatchers.sameDay(LocalDate.now().plusDays(1L));
    }

    public static Matcher<LocalDate> sameDayOfWeek(LocalDate date) {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.from(date));
    }

    public static Matcher<LocalDate> isDayOfWeek(DayOfWeek ... dayOfWeek) {
        return new IsDayOfWeek<LocalDate>(Arrays.asList(dayOfWeek), t -> t);
    }

    public static Matcher<LocalDate> isMonday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.MONDAY);
    }

    public static Matcher<LocalDate> isTuesday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.TUESDAY);
    }

    public static Matcher<LocalDate> isWednesday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.WEDNESDAY);
    }

    public static Matcher<LocalDate> isThursday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.THURSDAY);
    }

    public static Matcher<LocalDate> isFriday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.FRIDAY);
    }

    public static Matcher<LocalDate> isSaturday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.SATURDAY);
    }

    public static Matcher<LocalDate> isSunday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.SUNDAY);
    }

    public static Matcher<LocalDate> isWeekday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    }

    public static Matcher<LocalDate> isWeekend() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public static Matcher<LocalDate> isFirstDayOfMonth() {
        return LocalDateMatchers.isMinimum(ChronoField.DAY_OF_MONTH);
    }

    public static Matcher<LocalDate> isMinimum(TemporalField field) {
        return new IsMinimum<LocalDate>(field, t -> t);
    }

    public static Matcher<LocalDate> isLastDayOfMonth() {
        return LocalDateMatchers.isMaximum(ChronoField.DAY_OF_MONTH);
    }

    public static Matcher<LocalDate> isMaximum(TemporalField field) {
        return new IsMaximum<LocalDate>(field, t -> t);
    }

    public static Matcher<LocalDate> isMonth(Month month) {
        return new IsMonth<LocalDate>(month, t -> t);
    }

    public static Matcher<LocalDate> isJanuary() {
        return LocalDateMatchers.isMonth(Month.JANUARY);
    }

    public static Matcher<LocalDate> isFebruary() {
        return LocalDateMatchers.isMonth(Month.FEBRUARY);
    }

    public static Matcher<LocalDate> isMarch() {
        return LocalDateMatchers.isMonth(Month.MARCH);
    }

    public static Matcher<LocalDate> isApril() {
        return LocalDateMatchers.isMonth(Month.APRIL);
    }

    public static Matcher<LocalDate> isMay() {
        return LocalDateMatchers.isMonth(Month.MAY);
    }

    public static Matcher<LocalDate> isJune() {
        return LocalDateMatchers.isMonth(Month.JUNE);
    }

    public static Matcher<LocalDate> isJuly() {
        return LocalDateMatchers.isMonth(Month.JULY);
    }

    public static Matcher<LocalDate> isAugust() {
        return LocalDateMatchers.isMonth(Month.AUGUST);
    }

    public static Matcher<LocalDate> isSeptember() {
        return LocalDateMatchers.isMonth(Month.SEPTEMBER);
    }

    public static Matcher<LocalDate> isOctober() {
        return LocalDateMatchers.isMonth(Month.OCTOBER);
    }

    public static Matcher<LocalDate> isNovember() {
        return LocalDateMatchers.isMonth(Month.NOVEMBER);
    }

    public static Matcher<LocalDate> isDecember() {
        return LocalDateMatchers.isMonth(Month.DECEMBER);
    }

    public static Matcher<LocalDate> isLeapYear() {
        return new IsLeapYear<LocalDate>(t -> t, new LocalDateFormatter());
    }
}

