/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.exparity.hamcrest.date.DayMonthYear;
import org.exparity.hamcrest.date.Months;
import org.exparity.hamcrest.date.Weekdays;
import org.exparity.hamcrest.date.core.AnyOf;
import org.exparity.hamcrest.date.core.DateMatcher;
import org.exparity.hamcrest.date.core.IsAfter;
import org.exparity.hamcrest.date.core.IsBefore;
import org.exparity.hamcrest.date.core.IsDayOfMonth;
import org.exparity.hamcrest.date.core.IsDayOfWeek;
import org.exparity.hamcrest.date.core.IsHour;
import org.exparity.hamcrest.date.core.IsLeapYear;
import org.exparity.hamcrest.date.core.IsMaximum;
import org.exparity.hamcrest.date.core.IsMillisecond;
import org.exparity.hamcrest.date.core.IsMinimum;
import org.exparity.hamcrest.date.core.IsMinute;
import org.exparity.hamcrest.date.core.IsMonth;
import org.exparity.hamcrest.date.core.IsSame;
import org.exparity.hamcrest.date.core.IsSameDay;
import org.exparity.hamcrest.date.core.IsSameOrAfter;
import org.exparity.hamcrest.date.core.IsSameOrBefore;
import org.exparity.hamcrest.date.core.IsSecond;
import org.exparity.hamcrest.date.core.IsWithin;
import org.exparity.hamcrest.date.core.IsYear;
import org.exparity.hamcrest.date.core.format.DateFormatter;
import org.exparity.hamcrest.date.core.format.DatePartFormatter;
import org.exparity.hamcrest.date.core.wrapper.DateWrapper;
import org.exparity.hamcrest.date.core.wrapper.FieldDateWrapper;

public abstract class DateMatchers {
    public static DateMatcher<Date> after(Date date) {
        return new IsAfter<Date>(new DateWrapper(date), new DateFormatter());
    }

    @Deprecated
    public static DateMatcher<Date> after(DayMonthYear date) {
        return DateMatchers.after(date.toLocalDate());
    }

    public static DateMatcher<Date> after(LocalDate date) {
        return new IsAfter<Date>(new DateWrapper(date), new DateFormatter());
    }

    @Deprecated
    public static DateMatcher<Date> after(int year, Months month, int day) {
        return new IsAfter<Date>(new DateWrapper(year, month.month(), day), new DateFormatter());
    }

    public static DateMatcher<Date> after(int year, Month month, int day) {
        return new IsAfter<Date>(new DateWrapper(year, month, day), new DateFormatter());
    }

    @Deprecated
    public static DateMatcher<Date> after(int year, Months month, int dayOfMonth, int hour, int minute, int second) {
        return DateMatchers.after(year, month.month(), dayOfMonth, hour, minute, second);
    }

    public static DateMatcher<Date> after(int year, Month month, int dayOfMonth, int hour, int minute, int second) {
        return new IsAfter<Date>(new DateWrapper(year, month, dayOfMonth, hour, minute, second), new DateFormatter());
    }

    public static DateMatcher<Date> before(Date date) {
        return new IsBefore<Date>(new DateWrapper(date), new DateFormatter());
    }

    public static DateMatcher<Date> before(LocalDate date) {
        return new IsBefore<Date>(new DateWrapper(date), new DateFormatter());
    }

    @Deprecated
    public static DateMatcher<Date> before(DayMonthYear date) {
        return DateMatchers.before(date.toLocalDate());
    }

    @Deprecated
    public static DateMatcher<Date> before(int year, Months month, int dayOfMonth) {
        return new IsBefore<Date>(new DateWrapper(year, month.month(), dayOfMonth), new DateFormatter());
    }

    public static DateMatcher<Date> before(int year, Month month, int dayOfMonth) {
        return new IsBefore<Date>(new DateWrapper(year, month, dayOfMonth), new DateFormatter());
    }

    @Deprecated
    public static DateMatcher<Date> before(int year, Months month, int dayOfMonth, int hour, int minute, int second) {
        return DateMatchers.before(year, month.month(), dayOfMonth, hour, minute, second);
    }

    public static DateMatcher<Date> before(int year, Month month, int dayOfMonth, int hour, int minute, int second) {
        return new IsBefore<Date>(new DateWrapper(year, month, dayOfMonth, hour, minute, second), new DateFormatter());
    }

    public static DateMatcher<Date> sameDayOfWeek(Date date) {
        return DateMatchers.isDayOfWeek(DayOfWeek.from(date.toInstant().atZone(ZoneId.systemDefault())));
    }

    @Deprecated
    public static DateMatcher<Date> isDayOfWeek(Weekdays dayOfWeek) {
        return DateMatchers.isDayOfWeek(dayOfWeek.getAsDayOfWeek());
    }

    public static DateMatcher<Date> isDayOfWeek(DayOfWeek dayOfWeek) {
        return new IsDayOfWeek<Date>(new FieldDateWrapper(dayOfWeek.getValue(), ChronoField.DAY_OF_WEEK), (d, z) -> d.toInstant().atZone(z).get(ChronoField.DAY_OF_WEEK));
    }

    public static DateMatcher<Date> isDayOfWeek(DayOfWeek ... daysOfWeek) {
        return new AnyOf<Date>(Stream.of(daysOfWeek).map(DateMatchers::isDayOfWeek), (d, z) -> "the date is on a " + d.toInstant().atZone((ZoneId)z).getDayOfWeek().name().toLowerCase());
    }

    public static DateMatcher<Date> sameDayOfMonth(Date date) {
        return new IsDayOfMonth<Date>(new FieldDateWrapper(date, ChronoField.DAY_OF_MONTH), (d, z) -> d.toInstant().atZone(z).get(ChronoField.DAY_OF_MONTH));
    }

    public static DateMatcher<Date> isDayOfMonth(int dayOfMonth) {
        return new IsDayOfMonth<Date>(new FieldDateWrapper(dayOfMonth, ChronoField.DAY_OF_MONTH), (d, z) -> d.toInstant().atZone(z).get(ChronoField.DAY_OF_MONTH));
    }

    public static DateMatcher<Date> sameDay(Date date) {
        return new IsSameDay<Date>(new DateWrapper(date, (TemporalUnit)ChronoUnit.DAYS), new DateFormatter());
    }

    @Deprecated
    public static DateMatcher<Date> sameDay(DayMonthYear date) {
        return DateMatchers.sameDay(date.toLocalDate());
    }

    public static DateMatcher<Date> sameDay(LocalDate date) {
        return new IsSameDay<Date>(new DateWrapper(date), new DateFormatter());
    }

    @Deprecated
    public static DateMatcher<Date> sameDay(int year, Months month, int day) {
        return DateMatchers.isDay(year, month.month(), day);
    }

    public static DateMatcher<Date> isDay(int year, Month month, int dayOfMonth) {
        return DateMatchers.sameDay(LocalDate.of(year, month, dayOfMonth));
    }

    @Deprecated
    public static DateMatcher<Date> sameHour(Date date) {
        return DateMatchers.sameHourOfDay(date);
    }

    public static DateMatcher<Date> sameHourOfDay(Date date) {
        return new IsHour<Date>(new FieldDateWrapper(date, ChronoField.HOUR_OF_DAY), (d, z) -> d.toInstant().atZone(z).get(ChronoField.HOUR_OF_DAY));
    }

    @Deprecated
    public static DateMatcher<Date> sameHour(int hour) {
        return DateMatchers.isHour(hour);
    }

    public static DateMatcher<Date> isHour(int hour) {
        return new IsHour<Date>(new FieldDateWrapper(hour, ChronoField.HOUR_OF_DAY), (d, z) -> d.toInstant().atZone(z).get(ChronoField.HOUR_OF_DAY));
    }

    public static DateMatcher<Date> sameInstant(Date date) {
        return new IsSame<Date>(new DateWrapper(date), new DateFormatter());
    }

    public static DateMatcher<Date> sameInstant(long timestamp) {
        return new IsSame<Date>(new DateWrapper(new Date(timestamp)), new DateFormatter());
    }

    @Deprecated
    public static DateMatcher<Date> sameInstant(int year, Months month, int dayOfMonth, int hour, int minute, int second, int milliseconds) {
        return DateMatchers.isInstant(year, month.month(), dayOfMonth, hour, minute, second, milliseconds);
    }

    public static DateMatcher<Date> isInstant(int year, Month month, int dayOfMonth, int hour, int minute, int second, int milliseconds) {
        return new IsSame<Date>(new DateWrapper(year, month, dayOfMonth, hour, minute, second, milliseconds), new DateFormatter());
    }

    public static DateMatcher<Date> sameOrBefore(Date date) {
        return new IsSameOrBefore<Date>(new DateWrapper(date), new DateFormatter());
    }

    public static DateMatcher<Date> sameOrBefore(LocalDate date) {
        return new IsSameOrBefore<Date>(new DateWrapper(date), new DateFormatter());
    }

    @Deprecated
    public static DateMatcher<Date> sameOrBefore(DayMonthYear date) {
        return DateMatchers.sameOrBefore(date.toLocalDate());
    }

    @Deprecated
    public static DateMatcher<Date> sameOrBefore(int year, Months month, int dayOfMonth) {
        return DateMatchers.sameOrBefore(year, month.month(), dayOfMonth);
    }

    public static DateMatcher<Date> sameOrBefore(int year, Month month, int dayOfMonth) {
        return new IsSameOrBefore<Date>(new DateWrapper(LocalDate.of(year, month, dayOfMonth)), new DateFormatter());
    }

    @Deprecated
    public static DateMatcher<Date> sameOrBefore(int year, Months month, int dayOfMonth, int hour, int minute, int second) {
        return DateMatchers.sameOrBefore(year, month.month(), dayOfMonth, hour, minute, second);
    }

    public static DateMatcher<Date> sameOrBefore(int year, Month month, int dayOfMonth, int hour, int minute, int second) {
        return new IsSameOrBefore<Date>(new DateWrapper(year, month, dayOfMonth, hour, minute, second), new DateFormatter());
    }

    public static DateMatcher<Date> sameOrAfter(Date date) {
        return new IsSameOrAfter<Date>(new DateWrapper(date), new DateFormatter());
    }

    public static DateMatcher<Date> sameOrAfter(LocalDate date) {
        return new IsSameOrAfter<Date>(new DateWrapper(date), new DateFormatter());
    }

    @Deprecated
    public static DateMatcher<Date> sameOrAfter(DayMonthYear date) {
        return DateMatchers.sameOrAfter(date.toLocalDate());
    }

    @Deprecated
    public static DateMatcher<Date> sameOrAfter(int year, Months month, int dayOfMonth) {
        return DateMatchers.sameOrAfter(year, month.month(), dayOfMonth);
    }

    public static DateMatcher<Date> sameOrAfter(int year, Month month, int dayOfMonth) {
        return new IsSameOrAfter<Date>(new DateWrapper(year, month, dayOfMonth), new DateFormatter());
    }

    @Deprecated
    public static DateMatcher<Date> sameOrAfter(int year, Months month, int dayOfMonth, int hour, int minute, int second) {
        return DateMatchers.sameOrAfter(year, month.month(), dayOfMonth, hour, minute, second);
    }

    public static DateMatcher<Date> sameOrAfter(int year, Month month, int dayOfMonth, int hour, int minute, int second) {
        return new IsSameOrAfter<Date>(new DateWrapper(year, month, dayOfMonth, hour, minute, second), new DateFormatter());
    }

    @Deprecated
    public static DateMatcher<Date> sameMinute(Date date) {
        return DateMatchers.sameMinuteOfHour(date);
    }

    public static DateMatcher<Date> sameMinuteOfHour(Date date) {
        return new IsMinute<Date>(new FieldDateWrapper(date, ChronoField.MINUTE_OF_HOUR), (d, z) -> d.toInstant().atZone(z).get(ChronoField.MINUTE_OF_HOUR));
    }

    @Deprecated
    public static DateMatcher<Date> sameMinute(int minute) {
        return DateMatchers.isMinute(minute);
    }

    public static DateMatcher<Date> isMinute(int minute) {
        return new IsMinute<Date>(new FieldDateWrapper(minute, ChronoField.MINUTE_OF_HOUR), (d, z) -> d.toInstant().atZone(z).get(ChronoField.MINUTE_OF_HOUR));
    }

    @Deprecated
    public static DateMatcher<Date> sameMonth(Date date) {
        return DateMatchers.sameMonthOfYear(date);
    }

    public static DateMatcher<Date> sameMonthOfYear(Date date) {
        return DateMatchers.isMonth(Month.of(date.toInstant().atZone(ZoneId.systemDefault()).get(ChronoField.MONTH_OF_YEAR)));
    }

    @Deprecated
    public static DateMatcher<Date> sameMonth(Months month) {
        return DateMatchers.sameMonthOfYear(month);
    }

    @Deprecated
    public static DateMatcher<Date> sameMonthOfYear(Months month) {
        return DateMatchers.isMonth(month.month());
    }

    @Deprecated
    public static DateMatcher<Date> sameSecond(Date date) {
        return DateMatchers.sameSecondOfMinute(date);
    }

    public static DateMatcher<Date> sameSecondOfMinute(Date date) {
        return new IsSecond<Date>(new FieldDateWrapper(date, ChronoField.SECOND_OF_MINUTE), (d, z) -> d.toInstant().atZone(z).get(ChronoField.SECOND_OF_MINUTE));
    }

    @Deprecated
    public static DateMatcher<Date> sameSecond(int second) {
        return DateMatchers.isSecond(second);
    }

    public static DateMatcher<Date> isSecond(int second) {
        return new IsSecond<Date>(new FieldDateWrapper(second, ChronoField.SECOND_OF_MINUTE), (d, z) -> d.toInstant().atZone(z).get(ChronoField.SECOND_OF_MINUTE));
    }

    @Deprecated
    public static DateMatcher<Date> sameMillisecond(Date date) {
        return DateMatchers.sameMillisecondOfSecond(date);
    }

    public static DateMatcher<Date> sameMillisecondOfSecond(Date date) {
        return new IsMillisecond<Date>(new FieldDateWrapper(date, ChronoField.MILLI_OF_SECOND), (d, z) -> d.toInstant().atZone(z).get(ChronoField.MILLI_OF_SECOND));
    }

    @Deprecated
    public static DateMatcher<Date> sameMillisecond(int millisecond) {
        return DateMatchers.isMillisecond(millisecond);
    }

    public static DateMatcher<Date> isMillisecond(int millisecond) {
        return new IsMillisecond<Date>(new FieldDateWrapper(millisecond, ChronoField.MILLI_OF_SECOND), (d, z) -> d.toInstant().atZone(z).get(ChronoField.MILLI_OF_SECOND));
    }

    public static DateMatcher<Date> sameYear(Date date) {
        return new IsYear<Date>(new FieldDateWrapper(date, ChronoField.YEAR), (d, z) -> d.toInstant().atZone(z).get(ChronoField.YEAR));
    }

    public static DateMatcher<Date> isYear(int year) {
        return new IsYear<Date>(new FieldDateWrapper(year, ChronoField.YEAR), (d, z) -> d.toInstant().atZone(z).get(ChronoField.YEAR));
    }

    @Deprecated
    public static DateMatcher<Date> within(long period, TimeUnit unit, Date date) {
        return DateMatchers.within(period, DateMatchers.convertUnit(unit), date);
    }

    public static DateMatcher<Date> within(long period, ChronoUnit unit, Date date) {
        return new IsWithin<Date>(period, unit, new DateWrapper(date), new DateFormatter());
    }

    public static DateMatcher<Date> within(long period, ChronoUnit unit, LocalDate date) {
        return new IsWithin<Date>(period, unit, new DateWrapper(date), new DateFormatter());
    }

    @Deprecated
    public static DateMatcher<Date> within(long period, TimeUnit unit, DayMonthYear date) {
        return DateMatchers.within(period, DateMatchers.convertUnit(unit), date.toLocalDate());
    }

    @Deprecated
    public static DateMatcher<Date> within(long period, TimeUnit unit, int year, Months month, int dayOfMonth) {
        return DateMatchers.within(period, DateMatchers.convertUnit(unit), year, month.month(), dayOfMonth);
    }

    public static DateMatcher<Date> within(long period, ChronoUnit unit, int year, Month month, int dayOfMonth) {
        return DateMatchers.within(period, unit, LocalDate.of(year, month, dayOfMonth));
    }

    @Deprecated
    public static DateMatcher<Date> within(long period, TimeUnit unit, int year, Months month, int dayOfMonth, int hour, int minute, int second, int milliseconds) {
        return DateMatchers.within(period, DateMatchers.convertUnit(unit), year, month.month(), dayOfMonth, hour, minute, second, milliseconds);
    }

    public static DateMatcher<Date> within(long period, ChronoUnit unit, int year, Month month, int dayOfMonth, int hour, int minute, int second, int milliseconds) {
        return new IsWithin<Date>(period, unit, new DateWrapper(year, month, dayOfMonth, hour, minute, second, milliseconds), new DateFormatter());
    }

    public static DateMatcher<Date> isYesterday() {
        return DateMatchers.sameDay(LocalDate.now().minusDays(1L));
    }

    public static DateMatcher<Date> isToday() {
        return DateMatchers.sameDay(LocalDate.now());
    }

    public static DateMatcher<Date> isTomorrow() {
        return DateMatchers.sameDay(LocalDate.now().plusDays(1L));
    }

    public static DateMatcher<Date> isMonday() {
        return DateMatchers.isDayOfWeek(DayOfWeek.MONDAY);
    }

    public static DateMatcher<Date> isTuesday() {
        return DateMatchers.isDayOfWeek(DayOfWeek.TUESDAY);
    }

    public static DateMatcher<Date> isWednesday() {
        return DateMatchers.isDayOfWeek(DayOfWeek.WEDNESDAY);
    }

    public static DateMatcher<Date> isThursday() {
        return DateMatchers.isDayOfWeek(DayOfWeek.THURSDAY);
    }

    public static DateMatcher<Date> isFriday() {
        return DateMatchers.isDayOfWeek(DayOfWeek.FRIDAY);
    }

    public static DateMatcher<Date> isSaturday() {
        return DateMatchers.isDayOfWeek(DayOfWeek.SATURDAY);
    }

    public static DateMatcher<Date> isSunday() {
        return DateMatchers.isDayOfWeek(DayOfWeek.SUNDAY);
    }

    public static DateMatcher<Date> isWeekday() {
        return DateMatchers.isDayOfWeek(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    }

    public static DateMatcher<Date> isWeekend() {
        return DateMatchers.isDayOfWeek(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public static DateMatcher<Date> isFirstDayOfMonth() {
        return new IsMinimum<Date>(ChronoField.DAY_OF_MONTH, (d, z) -> d.toInstant().atZone(z).get(ChronoField.DAY_OF_MONTH), (d, z) -> ChronoField.DAY_OF_MONTH.rangeRefinedBy(d.toInstant().atZone(z)), new DatePartFormatter(), () -> "the date is the first day of the month");
    }

    public static DateMatcher<Date> isMinimum(ChronoField field) {
        return new IsMinimum<Date>(field, (d, z) -> d.toInstant().atZone(z).get(field), (d, z) -> field.rangeRefinedBy(d.toInstant().atZone(z)), new DatePartFormatter());
    }

    public static DateMatcher<Date> isLastDayOfMonth() {
        return new IsMaximum<Date>(ChronoField.DAY_OF_MONTH, (d, z) -> d.toInstant().atZone(z).get(ChronoField.DAY_OF_MONTH), (d, z) -> ChronoField.DAY_OF_MONTH.rangeRefinedBy(d.toInstant().atZone(z)), new DatePartFormatter(), () -> "the date is the last day of the month");
    }

    public static DateMatcher<Date> isMaximum(ChronoField field) {
        return new IsMaximum<Date>(field, (d, z) -> d.toInstant().atZone(z).get(field), (d, z) -> field.rangeRefinedBy(d.toInstant().atZone(z)), new DatePartFormatter());
    }

    public static DateMatcher<Date> isMonth(Month month) {
        return new IsMonth<Date>(new FieldDateWrapper(month.getValue(), ChronoField.MONTH_OF_YEAR), (d, z) -> d.toInstant().atZone(z).get(ChronoField.MONTH_OF_YEAR));
    }

    public static DateMatcher<Date> isJanuary() {
        return DateMatchers.isMonth(Month.JANUARY);
    }

    public static DateMatcher<Date> isFebruary() {
        return DateMatchers.isMonth(Month.FEBRUARY);
    }

    public static DateMatcher<Date> isMarch() {
        return DateMatchers.isMonth(Month.MARCH);
    }

    public static DateMatcher<Date> isApril() {
        return DateMatchers.isMonth(Month.APRIL);
    }

    public static DateMatcher<Date> isMay() {
        return DateMatchers.isMonth(Month.MAY);
    }

    public static DateMatcher<Date> isJune() {
        return DateMatchers.isMonth(Month.JUNE);
    }

    public static DateMatcher<Date> isJuly() {
        return DateMatchers.isMonth(Month.JULY);
    }

    public static DateMatcher<Date> isAugust() {
        return DateMatchers.isMonth(Month.AUGUST);
    }

    public static DateMatcher<Date> isSeptember() {
        return DateMatchers.isMonth(Month.SEPTEMBER);
    }

    public static DateMatcher<Date> isOctober() {
        return DateMatchers.isMonth(Month.OCTOBER);
    }

    public static DateMatcher<Date> isNovember() {
        return DateMatchers.isMonth(Month.NOVEMBER);
    }

    public static DateMatcher<Date> isDecember() {
        return DateMatchers.isMonth(Month.DECEMBER);
    }

    public static DateMatcher<Date> isLeapYear() {
        return new IsLeapYear<Date>(DateMatchers::dateToZoneDateTime, new DateFormatter());
    }

    private static ChronoUnit convertUnit(TimeUnit unit) {
        switch (unit) {
            case DAYS: {
                return ChronoUnit.DAYS;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
        }
        throw new IllegalArgumentException("Unknown TimeUnit '" + (Object)((Object)unit) + "'");
    }

    private static Temporal dateToZoneDateTime(Date date, ZoneId zone) {
        return date.toInstant().atZone(zone);
    }
}

