/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.stream.Stream;
import org.exparity.hamcrest.date.core.AnyOf;
import org.exparity.hamcrest.date.core.DateMatcher;
import org.exparity.hamcrest.date.core.IsAfter;
import org.exparity.hamcrest.date.core.IsBefore;
import org.exparity.hamcrest.date.core.IsDayOfMonth;
import org.exparity.hamcrest.date.core.IsDayOfWeek;
import org.exparity.hamcrest.date.core.IsHour;
import org.exparity.hamcrest.date.core.IsLeapYear;
import org.exparity.hamcrest.date.core.IsMaximum;
import org.exparity.hamcrest.date.core.IsMinimum;
import org.exparity.hamcrest.date.core.IsMinute;
import org.exparity.hamcrest.date.core.IsMonth;
import org.exparity.hamcrest.date.core.IsSame;
import org.exparity.hamcrest.date.core.IsSameDay;
import org.exparity.hamcrest.date.core.IsSameOrAfter;
import org.exparity.hamcrest.date.core.IsSameOrBefore;
import org.exparity.hamcrest.date.core.IsSecond;
import org.exparity.hamcrest.date.core.IsWithin;
import org.exparity.hamcrest.date.core.IsYear;
import org.exparity.hamcrest.date.core.format.DatePartFormatter;
import org.exparity.hamcrest.date.core.format.LocalDateTimeFormatter;
import org.exparity.hamcrest.date.core.wrapper.FieldLocalDateTimeWrapper;
import org.exparity.hamcrest.date.core.wrapper.LocalDateTimeWrapper;
import org.hamcrest.Factory;

public abstract class LocalDateTimeMatchers {
    public static DateMatcher<LocalDateTime> after(LocalDateTime date) {
        return new IsAfter<LocalDateTime>(new LocalDateTimeWrapper(date), new LocalDateTimeFormatter());
    }

    public static DateMatcher<LocalDateTime> after(int year, Month month, int dayOfMonth, int hour, int minute, int second) {
        return new IsAfter<LocalDateTime>(new LocalDateTimeWrapper(year, month, dayOfMonth, hour, minute, second), new LocalDateTimeFormatter());
    }

    public static DateMatcher<LocalDateTime> before(LocalDateTime date) {
        return new IsBefore<LocalDateTime>(new LocalDateTimeWrapper(date), new LocalDateTimeFormatter());
    }

    public static DateMatcher<LocalDateTime> before(int year, Month month, int dayOfMonth, int hour, int minute, int second) {
        return new IsBefore<LocalDateTime>(new LocalDateTimeWrapper(year, month, dayOfMonth, hour, minute, second), new LocalDateTimeFormatter());
    }

    public static DateMatcher<LocalDateTime> sameDay(LocalDateTime date) {
        return new IsSameDay<LocalDateTime>(new LocalDateTimeWrapper(date), new LocalDateTimeFormatter());
    }

    public static DateMatcher<LocalDateTime> isDay(int year, Month month, int dayOfMonth) {
        return new IsSameDay<LocalDateTime>(new LocalDateTimeWrapper(year, month, dayOfMonth), new LocalDateTimeFormatter());
    }

    public static DateMatcher<LocalDateTime> sameInstant(LocalDateTime date) {
        return new IsSame<LocalDateTime>(new LocalDateTimeWrapper(date), new LocalDateTimeFormatter());
    }

    public static DateMatcher<LocalDateTime> isInstant(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanos) {
        return new IsSame<LocalDateTime>(new LocalDateTimeWrapper(year, month, dayOfMonth, hour, minute, second, nanos), new LocalDateTimeFormatter());
    }

    public static DateMatcher<LocalDateTime> sameOrBefore(LocalDateTime date) {
        return new IsSameOrBefore<LocalDateTime>(new LocalDateTimeWrapper(date), new LocalDateTimeFormatter());
    }

    @Factory
    public static DateMatcher<LocalDateTime> sameOrBefore(int year, Month month, int day, int hour, int minute, int second) {
        return new IsSameOrBefore<LocalDateTime>(new LocalDateTimeWrapper(year, month, day, hour, minute, second), new LocalDateTimeFormatter());
    }

    public static DateMatcher<LocalDateTime> sameOrAfter(LocalDateTime date) {
        return new IsSameOrAfter<LocalDateTime>(new LocalDateTimeWrapper(date), new LocalDateTimeFormatter());
    }

    public static DateMatcher<LocalDateTime> sameOrAfter(int year, Month month, int day, int hour, int minute, int second) {
        return LocalDateTimeMatchers.sameOrAfter(LocalDateTime.of(year, month, day, hour, minute, second));
    }

    public static DateMatcher<LocalDateTime> sameMonthOfYear(LocalDateTime date) {
        return new IsMonth<LocalDateTime>(new FieldLocalDateTimeWrapper(date, ChronoField.MONTH_OF_YEAR), (d, z) -> ZonedDateTime.of(d, z).getMonthValue());
    }

    public static DateMatcher<LocalDateTime> sameDayOfMonth(LocalDateTime date) {
        return new IsDayOfMonth<LocalDateTime>(new FieldLocalDateTimeWrapper(date, ChronoField.DAY_OF_MONTH), (d, z) -> ZonedDateTime.of(d, z).getDayOfMonth());
    }

    public static DateMatcher<LocalDateTime> isDayOfMonth(int dayOfMonth) {
        return new IsDayOfMonth<LocalDateTime>(new FieldLocalDateTimeWrapper(dayOfMonth, ChronoField.DAY_OF_MONTH), (d, z) -> ZonedDateTime.of(d, z).getDayOfMonth());
    }

    public static DateMatcher<LocalDateTime> sameYear(LocalDateTime date) {
        return new IsYear<LocalDateTime>(new FieldLocalDateTimeWrapper(date, ChronoField.YEAR), (d, z) -> ZonedDateTime.of(d, z).getYear());
    }

    public static DateMatcher<LocalDateTime> isYear(int year) {
        return new IsYear<LocalDateTime>(new FieldLocalDateTimeWrapper(year, ChronoField.YEAR), (d, z) -> ZonedDateTime.of(d, z).getYear());
    }

    public static DateMatcher<LocalDateTime> within(long period, ChronoUnit unit, LocalDateTime date) {
        return new IsWithin<LocalDateTime>(period, unit, new LocalDateTimeWrapper(date), new LocalDateTimeFormatter());
    }

    public static DateMatcher<LocalDateTime> within(long period, ChronoUnit unit, int year, Month month, int dayofMonth, int hour, int minute, int second, int nanos) {
        return new IsWithin<LocalDateTime>(period, unit, new LocalDateTimeWrapper(year, month, dayofMonth, hour, minute, second, nanos), new LocalDateTimeFormatter());
    }

    public static DateMatcher<LocalDateTime> isYesterday() {
        return LocalDateTimeMatchers.sameDay(LocalDateTime.now().minusDays(1L));
    }

    public static DateMatcher<LocalDateTime> isToday() {
        return LocalDateTimeMatchers.sameDay(LocalDateTime.now());
    }

    public static DateMatcher<LocalDateTime> isTomorrow() {
        return LocalDateTimeMatchers.sameDay(LocalDateTime.now(ZoneId.systemDefault()).plusDays(1L));
    }

    public static DateMatcher<LocalDateTime> sameDayOfWeek(LocalDateTime date) {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.from(date));
    }

    public static DateMatcher<LocalDateTime> isDayOfWeek(DayOfWeek dayOfWeek) {
        return new IsDayOfWeek<LocalDateTime>(new FieldLocalDateTimeWrapper(dayOfWeek.getValue(), ChronoField.DAY_OF_WEEK), (d, z) -> ZonedDateTime.of(d, z).getDayOfWeek().getValue());
    }

    public static DateMatcher<LocalDateTime> isDayOfWeek(DayOfWeek ... daysOfWeek) {
        return new AnyOf<LocalDateTime>(Stream.of(daysOfWeek).map(LocalDateTimeMatchers::isDayOfWeek), (d, z) -> "the date is on a " + d.atZone((ZoneId)z).getDayOfWeek().name().toLowerCase());
    }

    public static DateMatcher<LocalDateTime> isMonday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.MONDAY);
    }

    public static DateMatcher<LocalDateTime> isTuesday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.TUESDAY);
    }

    public static DateMatcher<LocalDateTime> isWednesday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.WEDNESDAY);
    }

    public static DateMatcher<LocalDateTime> isThursday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.THURSDAY);
    }

    public static DateMatcher<LocalDateTime> isFriday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.FRIDAY);
    }

    public static DateMatcher<LocalDateTime> isSaturday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.SATURDAY);
    }

    public static DateMatcher<LocalDateTime> isSunday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.SUNDAY);
    }

    public static DateMatcher<LocalDateTime> isWeekday() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    }

    public static DateMatcher<LocalDateTime> isWeekend() {
        return LocalDateTimeMatchers.isDayOfWeek(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public static DateMatcher<LocalDateTime> isFirstDayOfMonth() {
        return new IsMinimum<LocalDateTime>(ChronoField.DAY_OF_MONTH, (d, z) -> d.atZone(z).get(ChronoField.DAY_OF_MONTH), (d, z) -> ChronoField.DAY_OF_MONTH.rangeRefinedBy(d.atZone(z)), new DatePartFormatter(), () -> "the date is the first day of the month");
    }

    public static DateMatcher<LocalDateTime> isMinimum(ChronoField field) {
        return new IsMinimum<LocalDateTime>(field, (d, z) -> d.atZone(z).get(field), (d, z) -> field.rangeRefinedBy(d.atZone(z)), new DatePartFormatter());
    }

    public static DateMatcher<LocalDateTime> isLastDayOfMonth() {
        return new IsMaximum<LocalDateTime>(ChronoField.DAY_OF_MONTH, (d, z) -> d.atZone(z).get(ChronoField.DAY_OF_MONTH), (d, z) -> ChronoField.DAY_OF_MONTH.rangeRefinedBy(d.atZone(z)), new DatePartFormatter(), () -> "the date is the last day of the month");
    }

    public static DateMatcher<LocalDateTime> isMaximum(ChronoField field) {
        return new IsMaximum<LocalDateTime>(field, (d, z) -> d.atZone(z).get(field), (d, z) -> field.rangeRefinedBy(d.atZone(z)), new DatePartFormatter());
    }

    public static DateMatcher<LocalDateTime> isMonth(Month month) {
        return new IsMonth<LocalDateTime>(new FieldLocalDateTimeWrapper(month.getValue(), ChronoField.MONTH_OF_YEAR), (d, z) -> ZonedDateTime.of(d, z).getMonthValue());
    }

    public static DateMatcher<LocalDateTime> isJanuary() {
        return LocalDateTimeMatchers.isMonth(Month.JANUARY);
    }

    public static DateMatcher<LocalDateTime> isFebruary() {
        return LocalDateTimeMatchers.isMonth(Month.FEBRUARY);
    }

    public static DateMatcher<LocalDateTime> isMarch() {
        return LocalDateTimeMatchers.isMonth(Month.MARCH);
    }

    public static DateMatcher<LocalDateTime> isApril() {
        return LocalDateTimeMatchers.isMonth(Month.APRIL);
    }

    public static DateMatcher<LocalDateTime> isMay() {
        return LocalDateTimeMatchers.isMonth(Month.MAY);
    }

    public static DateMatcher<LocalDateTime> isJune() {
        return LocalDateTimeMatchers.isMonth(Month.JUNE);
    }

    public static DateMatcher<LocalDateTime> isJuly() {
        return LocalDateTimeMatchers.isMonth(Month.JULY);
    }

    public static DateMatcher<LocalDateTime> isAugust() {
        return LocalDateTimeMatchers.isMonth(Month.AUGUST);
    }

    public static DateMatcher<LocalDateTime> isSeptember() {
        return LocalDateTimeMatchers.isMonth(Month.SEPTEMBER);
    }

    public static DateMatcher<LocalDateTime> isOctober() {
        return LocalDateTimeMatchers.isMonth(Month.OCTOBER);
    }

    public static DateMatcher<LocalDateTime> isNovember() {
        return LocalDateTimeMatchers.isMonth(Month.NOVEMBER);
    }

    public static DateMatcher<LocalDateTime> isDecember() {
        return LocalDateTimeMatchers.isMonth(Month.DECEMBER);
    }

    public static DateMatcher<LocalDateTime> isLeapYear() {
        return new IsLeapYear<LocalDateTime>((d, z) -> d, new LocalDateTimeFormatter());
    }

    public static DateMatcher<LocalDateTime> isHour(int hour) {
        return new IsHour<LocalDateTime>(new FieldLocalDateTimeWrapper(hour, ChronoField.HOUR_OF_DAY), (d, z) -> ZonedDateTime.of(d, z).getHour());
    }

    public static DateMatcher<LocalDateTime> sameHourOfDay(LocalDateTime date) {
        return new IsHour<LocalDateTime>(new FieldLocalDateTimeWrapper(date, ChronoField.HOUR_OF_DAY), (d, z) -> ZonedDateTime.of(d, z).getHour());
    }

    public static DateMatcher<LocalDateTime> isMinute(int minute) {
        return new IsMinute<LocalDateTime>(new FieldLocalDateTimeWrapper(minute, ChronoField.MINUTE_OF_HOUR), (d, z) -> ZonedDateTime.of(d, z).getMinute());
    }

    public static DateMatcher<LocalDateTime> sameMinuteOfHour(LocalDateTime date) {
        return new IsMinute<LocalDateTime>(new FieldLocalDateTimeWrapper(date, ChronoField.MINUTE_OF_HOUR), (d, z) -> ZonedDateTime.of(d, z).getMinute());
    }

    public static DateMatcher<LocalDateTime> isSecond(int second) {
        return new IsSecond<LocalDateTime>(new FieldLocalDateTimeWrapper(second, ChronoField.SECOND_OF_MINUTE), (d, z) -> ZonedDateTime.of(d, z).getSecond());
    }

    public static DateMatcher<LocalDateTime> sameSecondOfMinute(LocalDateTime date) {
        return new IsSecond<LocalDateTime>(new FieldLocalDateTimeWrapper(date, ChronoField.SECOND_OF_MINUTE), (d, z) -> ZonedDateTime.of(d, z).getSecond());
    }
}

