/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core.wrapper;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.function.Function;
import org.exparity.hamcrest.date.core.TemporalWrapper;

public class DateWrapper
implements TemporalWrapper<Date> {
    private final Function<ZoneId, ZonedDateTime> wrapped;
    private final ZoneId zone;
    private final TemporalUnit accuracy;

    private DateWrapper(Function<ZoneId, ZonedDateTime> wrapped, ZoneId zone, TemporalUnit accuracy) {
        this.wrapped = wrapped;
        this.zone = zone;
        this.accuracy = accuracy;
    }

    public DateWrapper(Date date) {
        this(date, (TemporalUnit)ChronoUnit.MILLIS);
    }

    public DateWrapper(Date date, TemporalUnit accuracy) {
        this.zone = ZoneId.systemDefault();
        this.wrapped = z -> date.toInstant().atZone((ZoneId)z);
        this.accuracy = accuracy;
    }

    public DateWrapper(LocalDate date) {
        this(date, (TemporalUnit)ChronoUnit.DAYS);
    }

    public DateWrapper(LocalDate date, TemporalUnit accuracy) {
        this.zone = ZoneId.systemDefault();
        this.wrapped = date::atStartOfDay;
        this.accuracy = accuracy;
    }

    public DateWrapper(int year, Month month, int dayOfMonth) {
        this(LocalDate.of(year, month, dayOfMonth));
    }

    public DateWrapper(int year, Month month, int dayOfMonth, int hour, int minute, int second) {
        this.zone = ZoneId.systemDefault();
        this.wrapped = z -> LocalDateTime.of(year, month, dayOfMonth, hour, minute, second).atZone((ZoneId)z);
        this.accuracy = ChronoUnit.SECONDS;
    }

    public DateWrapper(int year, Month month, int dayOfMonth, int hour, int minute, int second, int millis) {
        this.zone = ZoneId.systemDefault();
        this.wrapped = z -> LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, millis * 1000000).atZone((ZoneId)z);
        this.accuracy = ChronoUnit.MILLIS;
    }

    @Override
    public long difference(Date other, ChronoUnit unit) {
        return Math.abs(this.wrapped.apply(this.zone).truncatedTo(this.accuracy).toInstant().until(other.toInstant().atZone(this.zone).truncatedTo(this.accuracy).toInstant(), unit));
    }

    @Override
    public boolean isAfter(Date other) {
        return this.wrapped.apply(this.zone).truncatedTo(this.accuracy).toInstant().isAfter(other.toInstant().atZone(this.zone).truncatedTo(this.accuracy).toInstant());
    }

    @Override
    public boolean isBefore(Date other) {
        return this.wrapped.apply(this.zone).truncatedTo(this.accuracy).toInstant().isBefore(other.toInstant().atZone(this.zone).truncatedTo(this.accuracy).toInstant());
    }

    @Override
    public boolean isSame(Date other) {
        return this.wrapped.apply(this.zone).truncatedTo(this.accuracy).toInstant().equals(other.toInstant().atZone(this.zone).truncatedTo(this.accuracy).toInstant());
    }

    @Override
    public Date unwrap() {
        return new Date(this.wrapped.apply(this.zone).toInstant().toEpochMilli());
    }

    public DateWrapper withZone(ZoneId zone) {
        return new DateWrapper(this.wrapped, zone, this.accuracy);
    }
}

