/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core.wrapper;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.util.function.ToIntFunction;
import org.exparity.hamcrest.date.core.TemporalFieldWrapper;

public class FieldLocalDateTimeWrapper
implements TemporalFieldWrapper<LocalDateTime> {
    private final ToIntFunction<ZoneId> wrapped;
    private final ChronoField field;
    private final ZoneId zone;

    private FieldLocalDateTimeWrapper(ToIntFunction<ZoneId> wrapped, ChronoField field, ZoneId zone) {
        this.wrapped = wrapped;
        this.field = field;
        this.zone = zone;
    }

    public FieldLocalDateTimeWrapper(int value, ChronoField field) {
        this.wrapped = ignored -> value;
        this.field = field;
        this.zone = ZoneId.systemDefault();
    }

    public FieldLocalDateTimeWrapper(LocalDateTime date, ChronoField field) {
        this.wrapped = z -> date.atZone((ZoneId)z).get(field);
        this.field = field;
        this.zone = ZoneId.systemDefault();
    }

    @Override
    public boolean isAfter(LocalDateTime other) {
        return this.wrapped.applyAsInt(this.zone) > other.atZone(this.zone).get(this.field);
    }

    @Override
    public boolean isBefore(LocalDateTime other) {
        return this.wrapped.applyAsInt(this.zone) < other.atZone(this.zone).get(this.field);
    }

    @Override
    public boolean isSame(LocalDateTime other) {
        return this.wrapped.applyAsInt(this.zone) == other.atZone(this.zone).get(this.field);
    }

    @Override
    public int unwrap() {
        return this.wrapped.applyAsInt(this.zone);
    }

    @Override
    public TemporalFieldWrapper<LocalDateTime> withZone(ZoneId zone) {
        return new FieldLocalDateTimeWrapper(this.wrapped, this.field, zone);
    }
}

