/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core.wrapper;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.function.Function;
import org.exparity.hamcrest.date.core.TemporalWrapper;

public class ZonedDateTimeWrapper
implements TemporalWrapper<ZonedDateTime> {
    private final Function<ZoneId, ZonedDateTime> wrapped;
    private final ZoneId zone;
    private final TemporalUnit accuracy;

    private ZonedDateTimeWrapper(Function<ZoneId, ZonedDateTime> wrapped, ZoneId zone, TemporalUnit accuracy) {
        this.wrapped = wrapped;
        this.zone = zone;
        this.accuracy = accuracy;
    }

    public ZonedDateTimeWrapper(Date date) {
        this(date, (TemporalUnit)ChronoUnit.MILLIS);
    }

    public ZonedDateTimeWrapper(Date date, TemporalUnit accuracy) {
        this.zone = ZoneId.systemDefault();
        this.wrapped = z -> date.toInstant().atZone((ZoneId)z);
        this.accuracy = accuracy;
    }

    public ZonedDateTimeWrapper(ZonedDateTime date) {
        this(date, (TemporalUnit)ChronoUnit.NANOS);
    }

    public ZonedDateTimeWrapper(ZonedDateTime date, TemporalUnit accuracy) {
        this.zone = ZoneId.systemDefault();
        this.wrapped = date::withZoneSameInstant;
        this.accuracy = accuracy;
    }

    public ZonedDateTimeWrapper(LocalDateTime date, ZoneId zone) {
        this(date, zone, (TemporalUnit)ChronoUnit.NANOS);
    }

    public ZonedDateTimeWrapper(LocalDateTime date, ZoneId zone, TemporalUnit accuracy) {
        this.zone = zone;
        this.wrapped = date::atZone;
        this.accuracy = accuracy;
    }

    public ZonedDateTimeWrapper(int year, Month month, int dayOfMonth, int hour, int minute, int second, ZoneId zone) {
        this.zone = zone;
        this.wrapped = z -> LocalDateTime.of(year, month, dayOfMonth, hour, minute, second).atZone(zone);
        this.accuracy = ChronoUnit.SECONDS;
    }

    public ZonedDateTimeWrapper(int year, Month month, int dayOfMonth, int hour, int minute, int second, int nanos, ZoneId zone) {
        this.zone = zone;
        this.wrapped = z -> LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, nanos).atZone(zone);
        this.accuracy = ChronoUnit.NANOS;
    }

    public ZonedDateTimeWrapper(int year, Month month, int dayOfMonth, ZoneId zone) {
        this.zone = zone;
        this.wrapped = z -> LocalDate.of(year, month, dayOfMonth).atStartOfDay().atZone(zone);
        this.accuracy = ChronoUnit.DAYS;
    }

    @Override
    public long difference(ZonedDateTime other, ChronoUnit unit) {
        return Math.abs(this.wrapped.apply(this.zone).truncatedTo(this.accuracy).toInstant().until(other.toInstant(), unit));
    }

    @Override
    public boolean isAfter(ZonedDateTime other) {
        return this.wrapped.apply(this.zone).truncatedTo(this.accuracy).toInstant().isAfter(other.truncatedTo(this.accuracy).toInstant());
    }

    @Override
    public boolean isBefore(ZonedDateTime other) {
        return this.wrapped.apply(this.zone).truncatedTo(this.accuracy).toInstant().isBefore(other.truncatedTo(this.accuracy).toInstant());
    }

    @Override
    public boolean isSame(ZonedDateTime other) {
        return this.wrapped.apply(this.zone).truncatedTo(this.accuracy).toInstant().equals(other.truncatedTo(this.accuracy).toInstant());
    }

    @Override
    public ZonedDateTime unwrap() {
        return this.wrapped.apply(this.zone);
    }

    @Override
    public TemporalWrapper<ZonedDateTime> withZone(ZoneId zone) {
        return new ZonedDateTimeWrapper(this.wrapped, zone, this.accuracy);
    }
}

