/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.test.builder;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.exparity.test.builder.BeanBuilderException;
import org.exparity.test.builder.RandomBuilder;
import org.exparity.test.builder.ValueFactories;
import org.exparity.test.builder.ValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.it.modular.beans.BeanNamingStrategy;
import uk.co.it.modular.beans.BeanPropertyPath;
import uk.co.it.modular.beans.Type;
import uk.co.it.modular.beans.TypeProperty;
import uk.co.it.modular.beans.naming.ForceRootNameNamingStrategy;
import uk.co.it.modular.beans.naming.LowerCaseNamingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanBuilder<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BeanBuilder.class);
    private final Set<String> excludedProperties = new HashSet<String>();
    private final Set<String> excludedPaths = new HashSet<String>();
    private final Map<String, ValueFactory> paths = new HashMap<String, ValueFactory>();
    private final Map<String, ValueFactory> properties = new HashMap<String, ValueFactory>();
    private final Map<Class<?>, ValueFactory> types = new HashMap();
    private final Class<T> type;
    private final BeanBuilderType builderType;
    private final BeanNamingStrategy naming;
    private CollectionSize defaultCollectionSize = new CollectionSize(1, 5);
    private final Map<String, CollectionSize> collectionSizeForPaths = new HashMap<String, CollectionSize>();
    private final Map<String, CollectionSize> collectionSizeForProperties = new HashMap<String, CollectionSize>();
    private static final Map<Class<?>, ValueFactory> RANDOM_FACTORIES = new HashMap<Class<?>, ValueFactory>(){
        {
            this.put(Short.class, ValueFactories.aRandomShort());
            this.put(Short.TYPE, ValueFactories.aRandomShort());
            this.put(Integer.class, ValueFactories.aRandomInteger());
            this.put(Integer.TYPE, ValueFactories.aRandomInteger());
            this.put(Long.class, ValueFactories.aRandomLong());
            this.put(Long.TYPE, ValueFactories.aRandomLong());
            this.put(Double.class, ValueFactories.aRandomDouble());
            this.put(Double.TYPE, ValueFactories.aRandomDouble());
            this.put(Float.class, ValueFactories.aRandomFloat());
            this.put(Float.TYPE, ValueFactories.aRandomFloat());
            this.put(Boolean.class, ValueFactories.aRandomBoolean());
            this.put(Boolean.TYPE, ValueFactories.aRandomBoolean());
            this.put(Byte.class, ValueFactories.aRandomByte());
            this.put(Byte.TYPE, ValueFactories.aRandomByte());
            this.put(Character.class, ValueFactories.aRandomChar());
            this.put(Character.TYPE, ValueFactories.aRandomChar());
            this.put(String.class, ValueFactories.aRandomString());
            this.put(BigDecimal.class, ValueFactories.aRandomDecimal());
            this.put(Date.class, ValueFactories.aRandomDate());
        }
    };
    private static final Map<Class<?>, ValueFactory> EMPTY_FACTORIES = new HashMap<Class<?>, ValueFactory>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Short.class, ValueFactories.aNullValue());
            this.put(Short.TYPE, ValueFactories.theValue((short)0));
            this.put(Integer.class, ValueFactories.aNullValue());
            this.put(Integer.TYPE, ValueFactories.theValue(0));
            this.put(Long.class, ValueFactories.aNullValue());
            this.put(Long.TYPE, ValueFactories.theValue(0));
            this.put(Double.class, ValueFactories.aNullValue());
            this.put(Double.TYPE, ValueFactories.theValue(0.0));
            this.put(Float.class, ValueFactories.aNullValue());
            this.put(Float.TYPE, ValueFactories.theValue(Float.valueOf(0.0f)));
            this.put(Boolean.class, ValueFactories.aNullValue());
            this.put(Boolean.TYPE, ValueFactories.theValue(false));
            this.put(Byte.class, ValueFactories.aNullValue());
            this.put(Byte.TYPE, ValueFactories.theValue((byte)0));
            this.put(Character.class, ValueFactories.aNullValue());
            this.put(Character.TYPE, ValueFactories.theValue(Character.valueOf('\u0000')));
            this.put(String.class, ValueFactories.aNullValue());
            this.put(BigDecimal.class, ValueFactories.aNullValue());
            this.put(Date.class, ValueFactories.aNullValue());
        }
    };

    public static <T> BeanBuilder<T> anInstanceOf(Class<T> type) {
        return new BeanBuilder<T>(type, BeanBuilderType.NULL, (BeanNamingStrategy)new LowerCaseNamingStrategy());
    }

    public static <T> BeanBuilder<T> anInstanceOf(Class<T> type, String rootName) {
        return new BeanBuilder<T>(type, BeanBuilderType.NULL, (BeanNamingStrategy)new ForceRootNameNamingStrategy((BeanNamingStrategy)new LowerCaseNamingStrategy(), rootName));
    }

    public static <T> BeanBuilder<T> anEmptyInstanceOf(Class<T> type) {
        return new BeanBuilder<T>(type, BeanBuilderType.EMPTY, (BeanNamingStrategy)new LowerCaseNamingStrategy());
    }

    public static <T> BeanBuilder<T> anEmptyInstanceOf(Class<T> type, String rootName) {
        return new BeanBuilder<T>(type, BeanBuilderType.EMPTY, (BeanNamingStrategy)new ForceRootNameNamingStrategy((BeanNamingStrategy)new LowerCaseNamingStrategy(), rootName));
    }

    public static <T> BeanBuilder<T> aRandomInstanceOf(Class<T> type) {
        return new BeanBuilder<T>(type, BeanBuilderType.RANDOM, (BeanNamingStrategy)new LowerCaseNamingStrategy());
    }

    public static <T> BeanBuilder<T> aRandomInstanceOf(Class<T> type, String rootName) {
        return new BeanBuilder<T>(type, BeanBuilderType.RANDOM, (BeanNamingStrategy)new ForceRootNameNamingStrategy((BeanNamingStrategy)new LowerCaseNamingStrategy(), rootName));
    }

    private BeanBuilder(Class<T> type, BeanBuilderType builderType, BeanNamingStrategy naming) {
        this.type = type;
        this.builderType = builderType;
        this.naming = naming;
    }

    public BeanBuilder<T> with(String propertyOrPathName, Object value) {
        return this.with(propertyOrPathName, ValueFactories.theValue(value));
    }

    public <V> BeanBuilder<T> with(Class<V> type, ValueFactory<V> factory) {
        this.types.put(type, factory);
        return this;
    }

    public BeanBuilder<T> with(String propertyOrPathName, ValueFactory<?> factory) {
        this.path(propertyOrPathName, factory);
        this.property(propertyOrPathName, factory);
        return this;
    }

    public BeanBuilder<T> property(String propertyName, Object value) {
        return this.property(propertyName, ValueFactories.theValue(value));
    }

    public BeanBuilder<T> property(String propertyName, ValueFactory<?> factory) {
        this.properties.put(StringUtils.lowerCase((String)propertyName), factory);
        return this;
    }

    public <X> BeanBuilder<T> factory(Class<X> type, ValueFactory<X> factory) {
        this.types.put(type, factory);
        return this;
    }

    public BeanBuilder<T> excludeProperty(String propertyName) {
        this.excludedProperties.add(StringUtils.lowerCase((String)propertyName));
        return this;
    }

    public BeanBuilder<T> path(String path, Object value) {
        return this.path(path, ValueFactories.theValue(value));
    }

    public BeanBuilder<T> path(String path, ValueFactory<?> factory) {
        this.paths.put(StringUtils.lowerCase((String)path), factory);
        return this;
    }

    public BeanBuilder<T> excludePath(String path) {
        this.excludedPaths.add(StringUtils.lowerCase((String)path));
        return this;
    }

    public BeanBuilder<T> collectionSizeOf(int size) {
        return this.collectionSizeRangeOf(size, size);
    }

    public BeanBuilder<T> collectionSizeRangeOf(int min, int max) {
        this.defaultCollectionSize = new CollectionSize(min, max);
        return this;
    }

    public BeanBuilder<T> collectionSizeRangeForPropertyOf(String property, int min, int max) {
        this.collectionSizeForProperties.put(property, new CollectionSize(min, max));
        return this;
    }

    public BeanBuilder<T> collectionSizeForPropertyOf(String property, int size) {
        return this.collectionSizeRangeForPropertyOf(property, size, size);
    }

    public BeanBuilder<T> collectionSizeForPathOf(String path, int size) {
        return this.collectionSizeRangeForPathOf(path, size, size);
    }

    public BeanBuilder<T> collectionSizeRangeForPathOf(String path, int min, int max) {
        this.collectionSizeForPaths.put(path, new CollectionSize(min, max));
        return this;
    }

    public <X> BeanBuilder<T> subtype(Class<X> supertype, Class<? extends X> subtype) {
        return this.with(supertype, ValueFactories.oneOf(this.createInstanceOfFactoriesForTypes(subtype)));
    }

    public <X> BeanBuilder<T> subtype(Class<X> supertype, Class<? extends X> ... subtypes) {
        return this.with(supertype, ValueFactories.oneOf(this.createInstanceOfFactoriesForTypes(subtypes)));
    }

    public T build() {
        return this.populate(this.createNewInstance(), new BeanPropertyPath(this.naming.describeRoot(this.type)), new Stack(Type.type(this.type)));
    }

    private <I> I populate(I instance, BeanPropertyPath path, Stack stack) {
        if (instance != null) {
            for (TypeProperty property : Type.type(instance).setNamingStrategy(this.naming).propertyList()) {
                this.populateProperty(instance, property, path.append(property.getName()), stack);
            }
            return instance;
        }
        return instance;
    }

    private void populateProperty(Object instance, TypeProperty property, BeanPropertyPath path, Stack stack) {
        if (this.isExcludedPath(path) || this.isExcludedProperty(property)) {
            LOG.trace("Ignore [{}]. Explicity excluded", (Object)path);
            return;
        }
        ValueFactory factory = this.factoryForPath(property, path);
        if (factory != null) {
            this.assignValue(instance, property, path, this.createValue(factory, this.type), stack);
            return;
        }
        if (this.isPropertySet(instance, property) || this.isChildOfAssignedPath(path) || this.isOverflowing(property, path, stack)) {
            return;
        }
        if (property.isArray()) {
            property.setValue(instance, this.createArray(property.getType().getComponentType(), path, stack));
        } else if (property.isMap()) {
            property.setValue(instance, this.createMap(property.getTypeParameter(0), property.getTypeParameter(1), this.collectionSize(path), path, stack));
        } else if (property.isSet()) {
            property.setValue(instance, this.createSet(property.getTypeParameter(0), this.collectionSize(path), path, stack));
        } else if (property.isList() || property.isCollection()) {
            property.setValue(instance, this.createList(property.getTypeParameter(0), this.collectionSize(path), path, stack));
        } else {
            this.assignValue(instance, property, path, this.createValue(property.getType()), stack);
        }
    }

    private boolean isPropertySet(Object instance, TypeProperty property) {
        if (property.getValue(instance) == null) {
            return false;
        }
        if (property.isCollection()) {
            return !((Collection)property.getValue(instance, Collection.class)).isEmpty();
        }
        if (property.isMap()) {
            return !((Map)property.getValue(instance, Map.class)).isEmpty();
        }
        return true;
    }

    private boolean isOverflowing(TypeProperty property, BeanPropertyPath path, Stack stack) {
        if (stack.contains(property.getType())) {
            LOG.trace("Ignore {}. Avoids stack overflow caused by type {}", (Object)path, (Object)property.getTypeSimpleName());
            return true;
        }
        for (Class genericType : property.getTypeParameters()) {
            if (!stack.contains(genericType)) continue;
            LOG.trace("Ignore {}. Avoids stack overflow caused by type {}", (Object)path, (Object)genericType.getSimpleName());
            return true;
        }
        return false;
    }

    private ValueFactory factoryForPath(TypeProperty property, BeanPropertyPath path) {
        return this.selectNotNull(this.paths.get(path.fullPath()), this.paths.get(path.fullPathWithNoIndexes()), this.properties.get(property.getName()));
    }

    private boolean isExcludedProperty(TypeProperty property) {
        return this.excludedProperties.contains(property.getName());
    }

    private boolean isExcludedPath(BeanPropertyPath path) {
        return this.excludedPaths.contains(path.fullPath()) || this.excludedPaths.contains(path.fullPathWithNoIndexes());
    }

    private boolean isChildOfAssignedPath(BeanPropertyPath path) {
        for (String assignedPath : this.paths.keySet()) {
            if (!path.startsWith(assignedPath + ".")) continue;
            LOG.trace("Ignore {}. Child of assigned path {}", (Object)path, (Object)assignedPath);
            return true;
        }
        return false;
    }

    private void assignValue(Object instance, TypeProperty property, BeanPropertyPath path, Object value, Stack stack) {
        if (value != null) {
            LOG.trace("Assign {} value [{}:{}]", new Object[]{path, value.getClass().getSimpleName(), System.identityHashCode(value)});
            property.setValue(instance, this.populate(value, path, stack.append(Type.type((Object)value))));
        } else {
            LOG.trace("Assign {} value [null]", (Object)path);
        }
    }

    private <E> E createValue(Class<E> type) {
        for (Map.Entry<Class<?>, ValueFactory> keyedFactory : this.types.entrySet()) {
            if (!type.isAssignableFrom(keyedFactory.getKey())) continue;
            ValueFactory factory = keyedFactory.getValue();
            return this.createValue(factory, type);
        }
        switch (this.builderType) {
            case RANDOM: {
                ValueFactory factory = RANDOM_FACTORIES.get(type);
                if (factory != null) {
                    return this.createValue(factory, type);
                }
                if (type.isEnum()) {
                    return this.createValue(ValueFactories.aRandomEnum(type), type);
                }
                return this.createValue(ValueFactories.aNewInstanceOf(type), type);
            }
            case EMPTY: {
                ValueFactory factory = EMPTY_FACTORIES.get(type);
                if (factory != null) {
                    return this.createValue(factory, type);
                }
                if (type.isEnum()) {
                    return null;
                }
                return this.createValue(ValueFactories.aNewInstanceOf(type), type);
            }
        }
        return null;
    }

    private <E> E createValue(ValueFactory<E> factory, Class<E> type) {
        E value = factory != null ? (E)factory.createValue() : null;
        LOG.trace("Create Value [{}] for Type [{}]", value, (Object)Type.type(type).simpleName());
        return value;
    }

    private <E> Object createArray(Class<E> type, BeanPropertyPath path, Stack stack) {
        switch (this.builderType) {
            case RANDOM: 
            case EMPTY: {
                Object array = Array.newInstance(type, this.collectionSize(path));
                for (int i = 0; i < Array.getLength(array); ++i) {
                    Array.set(array, i, this.populate(this.createValue(type), path.appendIndex(i), stack.append(type)));
                }
                return array;
            }
        }
        return null;
    }

    private <E> Set<E> createSet(Class<E> type, int length, BeanPropertyPath path, Stack stack) {
        switch (this.builderType) {
            case RANDOM: 
            case EMPTY: {
                HashSet<E> set = new HashSet<E>();
                for (int i = 0; i < length; ++i) {
                    E value = this.populate(this.createValue(type), path.appendIndex(i), stack.append(type));
                    if (value == null) continue;
                    set.add(value);
                }
                return set;
            }
        }
        return null;
    }

    private <E> List<E> createList(Class<E> type, int length, BeanPropertyPath path, Stack stack) {
        switch (this.builderType) {
            case RANDOM: 
            case EMPTY: {
                ArrayList<E> list = new ArrayList<E>();
                for (int i = 0; i < length; ++i) {
                    E value = this.populate(this.createValue(type), path.appendIndex(i), stack.append(type));
                    if (value == null) continue;
                    list.add(value);
                }
                return list;
            }
        }
        return null;
    }

    private <K, V> Map<K, V> createMap(Class<K> keyType, Class<V> valueType, int length, BeanPropertyPath path, Stack stack) {
        switch (this.builderType) {
            case RANDOM: 
            case EMPTY: {
                HashMap<K, V> map = new HashMap<K, V>();
                for (int i = 0; i < length; ++i) {
                    K key = this.populate(this.createValue(keyType), path.appendIndex(i), stack.append(keyType).append(valueType));
                    if (key == null) continue;
                    map.put(key, this.createValue(valueType));
                }
                return map;
            }
        }
        return null;
    }

    private T createNewInstance() {
        try {
            return this.type.newInstance();
        }
        catch (InstantiationException e) {
            throw new BeanBuilderException("Failed to instantiate '" + this.type + "'. Error [" + e.getMessage() + "]", e);
        }
        catch (IllegalAccessException e) {
            throw new BeanBuilderException("Failed to instantiate '" + this.type + "'. Error [" + e.getMessage() + "]", e);
        }
    }

    private int collectionSize(BeanPropertyPath path) {
        return this.selectNotNull(this.collectionSizeForPaths.get(path.fullPath()), this.collectionSizeForPaths.get(path.fullPathWithNoIndexes()), this.collectionSizeForProperties.get(this.propertyName(path)), this.defaultCollectionSize).aRandomSize();
    }

    private String propertyName(BeanPropertyPath path) {
        return StringUtils.substringAfterLast((String)path.fullPathWithNoIndexes(), (String)".");
    }

    private <X> List<ValueFactory<X>> createInstanceOfFactoriesForTypes(Class<? extends X> ... subtypes) {
        ArrayList<ValueFactory<X>> factories = new ArrayList<ValueFactory<X>>();
        for (Class<? extends X> subtype : subtypes) {
            factories.add(ValueFactories.aNewInstanceOf(subtype));
        }
        return factories;
    }

    private <T> T selectNotNull(T ... options) {
        for (T option : options) {
            if (option == null) continue;
            return option;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BeanBuilderType {
        RANDOM,
        EMPTY,
        NULL;

    }

    private static class CollectionSize {
        private final int min;
        private final int max;

        public CollectionSize(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int aRandomSize() {
            if (this.min == this.max) {
                return this.min;
            }
            return RandomBuilder.aRandomInteger(this.min, this.max);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Stack {
        private final Type[] stack;

        private Stack(Type type) {
            this(new Type[]{type});
        }

        private Stack(Type[] stack) {
            this.stack = stack;
        }

        public boolean contains(Class<?> type) {
            int hits = 0;
            for (Type entry : this.stack) {
                if (!entry.is(type) || ++hits <= 1) continue;
                return true;
            }
            return false;
        }

        public Stack append(Class<?> value) {
            return this.append(Type.type(value));
        }

        public Stack append(Type value) {
            Type[] newStack = Arrays.copyOf(this.stack, this.stack.length + 1);
            newStack[this.stack.length] = value;
            return new Stack(newStack);
        }
    }
}

