/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.orbitz.consul.BaseClient;
import com.orbitz.consul.config.ClientConfig;
import com.orbitz.consul.model.acl.AclResponse;
import com.orbitz.consul.model.acl.AclToken;
import com.orbitz.consul.model.acl.AclTokenId;
import com.orbitz.consul.model.acl.BindingRule;
import com.orbitz.consul.model.acl.Login;
import com.orbitz.consul.model.acl.LoginResponse;
import com.orbitz.consul.model.acl.Policy;
import com.orbitz.consul.model.acl.PolicyResponse;
import com.orbitz.consul.model.acl.Role;
import com.orbitz.consul.model.acl.RoleListResponse;
import com.orbitz.consul.model.acl.RoleResponse;
import com.orbitz.consul.model.acl.Token;
import com.orbitz.consul.model.acl.TokenListResponse;
import com.orbitz.consul.model.acl.TokenResponse;
import com.orbitz.consul.monitoring.ClientEventCallback;
import com.orbitz.consul.option.RoleOptions;
import com.orbitz.consul.option.TokenQueryOptions;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public class AclClient
extends BaseClient {
    private static String CLIENT_NAME = "acl";
    private final Api api;

    AclClient(Retrofit retrofit, ClientConfig config, ClientEventCallback eventCallback) {
        super(CLIENT_NAME, config, eventCallback);
        this.api = (Api)retrofit.create(Api.class);
    }

    @Deprecated
    public String createAcl(AclToken aclToken) {
        return this.http.extract(this.api.createAcl(aclToken), new Integer[0]).id();
    }

    @Deprecated
    public void updateAcl(AclToken aclToken) {
        this.http.handle(this.api.updateAcl(aclToken), new Integer[0]);
    }

    @Deprecated
    public void destroyAcl(String id) {
        this.http.handle(this.api.destroyAcl(id), new Integer[0]);
    }

    @Deprecated
    public List<AclResponse> getAclInfo(String id) {
        return this.http.extract(this.api.getAclInfo(id), new Integer[0]);
    }

    @Deprecated
    public String cloneAcl(String id) {
        return this.http.extract(this.api.cloneAcl(id), new Integer[0]).id();
    }

    @Deprecated
    public List<AclResponse> listAcls() {
        return this.http.extract(this.api.listAcls(), new Integer[0]);
    }

    public PolicyResponse createPolicy(Policy policy) {
        return this.http.extract(this.api.createPolicy(policy), new Integer[0]);
    }

    public PolicyResponse readPolicy(String id) {
        return this.http.extract(this.api.readPolicy(id), new Integer[0]);
    }

    public PolicyResponse readPolicyByName(String name) {
        return this.http.extract(this.api.readPolicyByName(name), new Integer[0]);
    }

    public PolicyResponse updatePolicy(String id, Policy policy) {
        return this.http.extract(this.api.updatePolicy(id, policy), new Integer[0]);
    }

    public void deletePolicy(String id) {
        this.http.extract(this.api.deletePolicy(id), new Integer[0]);
    }

    public List<PolicyResponse> listPolicies() {
        return this.http.extract(this.api.listPolicies(), new Integer[0]);
    }

    public TokenResponse createToken(Token token) {
        return this.http.extract(this.api.createToken(token), new Integer[0]);
    }

    public TokenResponse cloneToken(String id, Token token) {
        return this.http.extract(this.api.cloneToken(id, token), new Integer[0]);
    }

    public TokenResponse readToken(String id) {
        return this.http.extract(this.api.readToken(id), new Integer[0]);
    }

    public TokenResponse readSelfToken() {
        return this.http.extract(this.api.readToken("self"), new Integer[0]);
    }

    public TokenResponse updateToken(String id, Token token) {
        return this.http.extract(this.api.updateToken(id, token), new Integer[0]);
    }

    public List<TokenListResponse> listTokens() {
        return this.listTokens(TokenQueryOptions.BLANK);
    }

    public List<TokenListResponse> listTokens(TokenQueryOptions queryOptions) {
        return this.http.extract(this.api.listTokens(queryOptions.toQuery()), new Integer[0]);
    }

    public void deleteToken(String id) {
        this.http.extract(this.api.deleteToken(id), new Integer[0]);
    }

    public RoleResponse createRole(Role token) {
        return this.http.extract(this.api.createRole(token), new Integer[0]);
    }

    public RoleResponse readRole(String id) {
        return this.http.extract(this.api.readRole(id), new Integer[0]);
    }

    public RoleResponse readRoleByName(String name) {
        return this.http.extract(this.api.readRoleByName(name), new Integer[0]);
    }

    public RoleResponse updateRole(String id, Role role) {
        return this.http.extract(this.api.updateRole(id, role), new Integer[0]);
    }

    public List<RoleListResponse> listRoles() {
        return this.listRoles(RoleOptions.BLANK);
    }

    public List<RoleListResponse> listRoles(RoleOptions roleOptions) {
        return this.http.extract(this.api.listRoles(roleOptions.toQuery()), new Integer[0]);
    }

    public void deleteRole(String id) {
        this.http.extract(this.api.deleteRole(id), new Integer[0]);
    }

    public BindingRule readBindingRule(String id) {
        return this.http.extract(this.api.readBindingRule(id), new Integer[0]);
    }

    public List<BindingRule> listBindingRules() {
        return this.http.extract(this.api.listBindingRules(), new Integer[0]);
    }

    public BindingRule createBindingRule(BindingRule bindingRule) {
        return this.http.extract(this.api.createBindingRule(bindingRule), new Integer[0]);
    }

    public Boolean deleteBindingRule(String id) {
        return this.http.extract(this.api.deleteBindingRule(id), new Integer[0]);
    }

    public LoginResponse login(Login login) {
        return this.http.extract(this.api.login(login), new Integer[0]);
    }

    public void logout() {
        this.api.logout();
    }

    static interface Api {
        @Deprecated
        @PUT(value="acl/create")
        public Call<AclTokenId> createAcl(@Body AclToken var1);

        @Deprecated
        @PUT(value="acl/update")
        public Call<Void> updateAcl(@Body AclToken var1);

        @Deprecated
        @PUT(value="acl/destroy/{id}")
        public Call<Void> destroyAcl(@Path(value="id") String var1);

        @Deprecated
        @GET(value="acl/info/{id}")
        public Call<List<AclResponse>> getAclInfo(@Path(value="id") String var1);

        @Deprecated
        @PUT(value="acl/clone/{id}")
        public Call<AclTokenId> cloneAcl(@Path(value="id") String var1);

        @Deprecated
        @GET(value="acl/list")
        public Call<List<AclResponse>> listAcls();

        @PUT(value="acl/policy")
        public Call<PolicyResponse> createPolicy(@Body Policy var1);

        @GET(value="acl/policy/{id}")
        public Call<PolicyResponse> readPolicy(@Path(value="id") String var1);

        @GET(value="acl/policy/name/{name}")
        public Call<PolicyResponse> readPolicyByName(@Path(value="name") String var1);

        @PUT(value="acl/policy/{id}")
        public Call<PolicyResponse> updatePolicy(@Path(value="id") String var1, @Body Policy var2);

        @DELETE(value="acl/policy/{id}")
        public Call<Void> deletePolicy(@Path(value="id") String var1);

        @GET(value="acl/policies")
        public Call<List<PolicyResponse>> listPolicies();

        @PUT(value="acl/token")
        public Call<TokenResponse> createToken(@Body Token var1);

        @PUT(value="acl/token/{id}/clone")
        public Call<TokenResponse> cloneToken(@Path(value="id") String var1, @Body Token var2);

        @GET(value="acl/token/{id}")
        public Call<TokenResponse> readToken(@Path(value="id") String var1);

        @PUT(value="acl/token/{id}")
        public Call<TokenResponse> updateToken(@Path(value="id") String var1, @Body Token var2);

        @GET(value="acl/tokens")
        public Call<List<TokenListResponse>> listTokens(@QueryMap Map<String, Object> var1);

        @DELETE(value="acl/token/{id}")
        public Call<Void> deleteToken(@Path(value="id") String var1);

        @PUT(value="acl/role")
        public Call<RoleResponse> createRole(@Body Role var1);

        @GET(value="acl/role/{id}")
        public Call<RoleResponse> readRole(@Path(value="id") String var1);

        @GET(value="acl/role/name/{name}")
        public Call<RoleResponse> readRoleByName(@Path(value="name") String var1);

        @PUT(value="acl/role/{id}")
        public Call<RoleResponse> updateRole(@Path(value="id") String var1, @Body Role var2);

        @DELETE(value="acl/role/{id}")
        public Call<Void> deleteRole(@Path(value="id") String var1);

        @GET(value="acl/roles")
        public Call<List<RoleListResponse>> listRoles(@QueryMap Map<String, Object> var1);

        @GET(value="acl/binding-rule/{id}")
        public Call<BindingRule> readBindingRule(@Path(value="id") String var1);

        @GET(value="acl/binding-rules")
        public Call<List<BindingRule>> listBindingRules();

        @PUT(value="acl/binding-rule")
        public Call<BindingRule> createBindingRule(@Body BindingRule var1);

        @DELETE(value="acl/binding-rule/{id}")
        public Call<Boolean> deleteBindingRule(@Path(value="id") String var1);

        @POST(value="acl/login")
        public Call<LoginResponse> login(@Body Login var1);

        @POST(value="acl/logout")
        public Call<Void> logout();
    }
}

