/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.orbitz.consul.BaseCacheableClient;
import com.orbitz.consul.Consul;
import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.config.ClientConfig;
import com.orbitz.consul.model.ConsulResponse;
import com.orbitz.consul.model.catalog.CatalogDeregistration;
import com.orbitz.consul.model.catalog.CatalogNode;
import com.orbitz.consul.model.catalog.CatalogRegistration;
import com.orbitz.consul.model.catalog.CatalogService;
import com.orbitz.consul.model.catalog.NodeServicesResponse;
import com.orbitz.consul.model.health.Node;
import com.orbitz.consul.monitoring.ClientEventCallback;
import com.orbitz.consul.option.QueryOptions;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HeaderMap;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

public class CatalogClient
extends BaseCacheableClient {
    private static String CLIENT_NAME = "catalog";
    private final Api api;

    CatalogClient(Retrofit retrofit, ClientConfig config, ClientEventCallback eventCallback, Consul.NetworkTimeoutConfig networkTimeoutConfig) {
        super(CLIENT_NAME, config, eventCallback, networkTimeoutConfig);
        this.api = (Api)retrofit.create(Api.class);
    }

    public List<String> getDatacenters() {
        return this.getDatacenters(QueryOptions.BLANK);
    }

    public List<String> getDatacenters(QueryOptions queryOptions) {
        return this.http.extract(this.api.getDatacenters(queryOptions.toHeaders()), new Integer[0]);
    }

    public ConsulResponse<List<Node>> getNodes() {
        return this.getNodes(QueryOptions.BLANK);
    }

    public ConsulResponse<List<Node>> getNodes(QueryOptions queryOptions) {
        return this.http.extractConsulResponse(this.api.getNodes(queryOptions.toQuery(), queryOptions.getTag(), queryOptions.getNodeMeta(), queryOptions.toHeaders()), new Integer[0]);
    }

    public void getNodes(QueryOptions queryOptions, ConsulResponseCallback<List<Node>> callback) {
        this.http.extractConsulResponse(this.api.getNodes(queryOptions.toQuery(), queryOptions.getTag(), queryOptions.getNodeMeta(), queryOptions.toHeaders()), callback, new Integer[0]);
    }

    public ConsulResponse<Map<String, List<String>>> getServices() {
        return this.getServices(QueryOptions.BLANK);
    }

    public void getServices(ConsulResponseCallback<Map<String, List<String>>> callback) {
        this.getServices(QueryOptions.BLANK, callback);
    }

    public ConsulResponse<Map<String, List<String>>> getServices(QueryOptions queryOptions) {
        return this.http.extractConsulResponse(this.api.getServices(queryOptions.toQuery(), queryOptions.getTag(), queryOptions.getNodeMeta(), queryOptions.toHeaders()), new Integer[0]);
    }

    public void getServices(QueryOptions queryOptions, ConsulResponseCallback<Map<String, List<String>>> callback) {
        this.http.extractConsulResponse(this.api.getServices(queryOptions.toQuery(), queryOptions.getTag(), queryOptions.getNodeMeta(), queryOptions.toHeaders()), callback, new Integer[0]);
    }

    public ConsulResponse<List<CatalogService>> getService(String service) {
        return this.getService(service, QueryOptions.BLANK);
    }

    public ConsulResponse<List<CatalogService>> getService(String service, QueryOptions queryOptions) {
        return this.http.extractConsulResponse(this.api.getService(service, queryOptions.toQuery(), queryOptions.getTag(), queryOptions.getNodeMeta(), queryOptions.toHeaders()), new Integer[0]);
    }

    public void getService(String service, QueryOptions queryOptions, ConsulResponseCallback<List<CatalogService>> callback) {
        this.http.extractConsulResponse(this.api.getService(service, queryOptions.toQuery(), queryOptions.getTag(), queryOptions.getNodeMeta(), queryOptions.toHeaders()), callback, new Integer[0]);
    }

    public ConsulResponse<NodeServicesResponse> getNodeServices(String nodeName) {
        return this.getNodeServices(nodeName, QueryOptions.BLANK);
    }

    public ConsulResponse<NodeServicesResponse> getNodeServices(String nodeName, QueryOptions queryOptions) {
        return this.http.extractConsulResponse(this.api.getNodeServices(nodeName, queryOptions.toQuery(), queryOptions.toHeaders()), new Integer[0]);
    }

    public ConsulResponse<CatalogNode> getNode(String node) {
        return this.getNode(node, QueryOptions.BLANK);
    }

    public ConsulResponse<CatalogNode> getNode(String node, QueryOptions queryOptions) {
        return this.http.extractConsulResponse(this.api.getNode(node, queryOptions.toQuery(), queryOptions.getTag(), queryOptions.getNodeMeta(), queryOptions.toHeaders()), new Integer[0]);
    }

    public void getNode(String node, QueryOptions queryOptions, ConsulResponseCallback<CatalogNode> callback) {
        this.http.extractConsulResponse(this.api.getNode(node, queryOptions.toQuery(), queryOptions.getTag(), queryOptions.getNodeMeta(), queryOptions.toHeaders()), callback, new Integer[0]);
    }

    public void register(CatalogRegistration registration) {
        this.register(registration, QueryOptions.BLANK);
    }

    public void register(CatalogRegistration registration, QueryOptions options) {
        this.http.handle(this.api.register(registration, options.toQuery()), new Integer[0]);
    }

    public void deregister(CatalogDeregistration deregistration) {
        this.deregister(deregistration, QueryOptions.BLANK);
    }

    public void deregister(CatalogDeregistration deregistration, QueryOptions options) {
        this.http.handle(this.api.deregister(deregistration, options.toQuery()), new Integer[0]);
    }

    static interface Api {
        @GET(value="catalog/datacenters")
        public Call<List<String>> getDatacenters(@HeaderMap Map<String, String> var1);

        @GET(value="catalog/nodes")
        public Call<List<Node>> getNodes(@QueryMap Map<String, Object> var1, @Query(value="tag") List<String> var2, @Query(value="node-meta") List<String> var3, @HeaderMap Map<String, String> var4);

        @GET(value="catalog/node/{node}")
        public Call<CatalogNode> getNode(@Path(value="node") String var1, @QueryMap Map<String, Object> var2, @Query(value="tag") List<String> var3, @Query(value="node-meta") List<String> var4, @HeaderMap Map<String, String> var5);

        @GET(value="catalog/services")
        public Call<Map<String, List<String>>> getServices(@QueryMap Map<String, Object> var1, @Query(value="tag") List<String> var2, @Query(value="node-meta") List<String> var3, @HeaderMap Map<String, String> var4);

        @GET(value="catalog/service/{service}")
        public Call<List<CatalogService>> getService(@Path(value="service") String var1, @QueryMap Map<String, Object> var2, @Query(value="tag") List<String> var3, @Query(value="node-meta") List<String> var4, @HeaderMap Map<String, String> var5);

        @GET(value="catalog/node-services/{node-name}")
        public Call<NodeServicesResponse> getNodeServices(@Path(value="node-name") String var1, @QueryMap Map<String, Object> var2, @HeaderMap Map<String, String> var3);

        @PUT(value="catalog/register")
        public Call<Void> register(@Body CatalogRegistration var1, @QueryMap Map<String, Object> var2);

        @PUT(value="catalog/deregister")
        public Call<Void> deregister(@Body CatalogDeregistration var1, @QueryMap Map<String, Object> var2);
    }
}

