/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.acl.BindingRule;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="BindingRule", generator="Immutables")
@Immutable
public final class ImmutableBindingRule
extends BindingRule {
    @Nullable
    private final String id;
    @Nullable
    private final String description;
    private final String authMethod;
    @Nullable
    private final String selector;
    private final String bindType;
    private final String bindName;
    @Nullable
    private final Long createIndex;
    @Nullable
    private final Long modifyIndex;

    private ImmutableBindingRule(@Nullable String id, @Nullable String description, String authMethod, @Nullable String selector, String bindType, String bindName, @Nullable Long createIndex, @Nullable Long modifyIndex) {
        this.id = id;
        this.description = description;
        this.authMethod = authMethod;
        this.selector = selector;
        this.bindType = bindType;
        this.bindName = bindName;
        this.createIndex = createIndex;
        this.modifyIndex = modifyIndex;
    }

    @Override
    @JsonProperty(value="ID")
    public Optional<String> getId() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="Description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="AuthMethod")
    public String getAuthMethod() {
        return this.authMethod;
    }

    @Override
    @JsonProperty(value="Selector")
    public Optional<String> getSelector() {
        return Optional.ofNullable(this.selector);
    }

    @Override
    @JsonProperty(value="BindType")
    public String getBindType() {
        return this.bindType;
    }

    @Override
    @JsonProperty(value="BindName")
    public String getBindName() {
        return this.bindName;
    }

    @Override
    @JsonProperty(value="CreateIndex")
    public OptionalLong getCreateIndex() {
        return this.createIndex != null ? OptionalLong.of(this.createIndex) : OptionalLong.empty();
    }

    @Override
    @JsonProperty(value="ModifyIndex")
    public OptionalLong getModifyIndex() {
        return this.modifyIndex != null ? OptionalLong.of(this.modifyIndex) : OptionalLong.empty();
    }

    public final ImmutableBindingRule withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutableBindingRule(newValue, this.description, this.authMethod, this.selector, this.bindType, this.bindName, this.createIndex, this.modifyIndex);
    }

    public final ImmutableBindingRule withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableBindingRule(value, this.description, this.authMethod, this.selector, this.bindType, this.bindName, this.createIndex, this.modifyIndex);
    }

    public final ImmutableBindingRule withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableBindingRule(this.id, newValue, this.authMethod, this.selector, this.bindType, this.bindName, this.createIndex, this.modifyIndex);
    }

    public final ImmutableBindingRule withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableBindingRule(this.id, value, this.authMethod, this.selector, this.bindType, this.bindName, this.createIndex, this.modifyIndex);
    }

    public final ImmutableBindingRule withAuthMethod(String value) {
        String newValue = Objects.requireNonNull(value, "authMethod");
        if (this.authMethod.equals(newValue)) {
            return this;
        }
        return new ImmutableBindingRule(this.id, this.description, newValue, this.selector, this.bindType, this.bindName, this.createIndex, this.modifyIndex);
    }

    public final ImmutableBindingRule withSelector(String value) {
        String newValue = Objects.requireNonNull(value, "selector");
        if (Objects.equals(this.selector, newValue)) {
            return this;
        }
        return new ImmutableBindingRule(this.id, this.description, this.authMethod, newValue, this.bindType, this.bindName, this.createIndex, this.modifyIndex);
    }

    public final ImmutableBindingRule withSelector(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.selector, value)) {
            return this;
        }
        return new ImmutableBindingRule(this.id, this.description, this.authMethod, value, this.bindType, this.bindName, this.createIndex, this.modifyIndex);
    }

    public final ImmutableBindingRule withBindType(String value) {
        String newValue = Objects.requireNonNull(value, "bindType");
        if (this.bindType.equals(newValue)) {
            return this;
        }
        return new ImmutableBindingRule(this.id, this.description, this.authMethod, this.selector, newValue, this.bindName, this.createIndex, this.modifyIndex);
    }

    public final ImmutableBindingRule withBindName(String value) {
        String newValue = Objects.requireNonNull(value, "bindName");
        if (this.bindName.equals(newValue)) {
            return this;
        }
        return new ImmutableBindingRule(this.id, this.description, this.authMethod, this.selector, this.bindType, newValue, this.createIndex, this.modifyIndex);
    }

    public final ImmutableBindingRule withCreateIndex(long value) {
        Long newValue = value;
        if (Objects.equals(this.createIndex, newValue)) {
            return this;
        }
        return new ImmutableBindingRule(this.id, this.description, this.authMethod, this.selector, this.bindType, this.bindName, newValue, this.modifyIndex);
    }

    public final ImmutableBindingRule withCreateIndex(OptionalLong optional) {
        Long value;
        Long l = value = optional.isPresent() ? Long.valueOf(optional.getAsLong()) : null;
        if (Objects.equals(this.createIndex, value)) {
            return this;
        }
        return new ImmutableBindingRule(this.id, this.description, this.authMethod, this.selector, this.bindType, this.bindName, value, this.modifyIndex);
    }

    public final ImmutableBindingRule withModifyIndex(long value) {
        Long newValue = value;
        if (Objects.equals(this.modifyIndex, newValue)) {
            return this;
        }
        return new ImmutableBindingRule(this.id, this.description, this.authMethod, this.selector, this.bindType, this.bindName, this.createIndex, newValue);
    }

    public final ImmutableBindingRule withModifyIndex(OptionalLong optional) {
        Long value;
        Long l = value = optional.isPresent() ? Long.valueOf(optional.getAsLong()) : null;
        if (Objects.equals(this.modifyIndex, value)) {
            return this;
        }
        return new ImmutableBindingRule(this.id, this.description, this.authMethod, this.selector, this.bindType, this.bindName, this.createIndex, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBindingRule && this.equalTo((ImmutableBindingRule)another);
    }

    private boolean equalTo(ImmutableBindingRule another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.description, another.description) && this.authMethod.equals(another.authMethod) && Objects.equals(this.selector, another.selector) && this.bindType.equals(another.bindType) && this.bindName.equals(another.bindName) && Objects.equals(this.createIndex, another.createIndex) && Objects.equals(this.modifyIndex, another.modifyIndex);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.authMethod.hashCode();
        h += (h << 5) + Objects.hashCode(this.selector);
        h += (h << 5) + this.bindType.hashCode();
        h += (h << 5) + this.bindName.hashCode();
        h += (h << 5) + Objects.hashCode(this.createIndex);
        h += (h << 5) + Objects.hashCode(this.modifyIndex);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BindingRule").omitNullValues().add("id", (Object)this.id).add("description", (Object)this.description).add("authMethod", (Object)this.authMethod).add("selector", (Object)this.selector).add("bindType", (Object)this.bindType).add("bindName", (Object)this.bindName).add("createIndex", (Object)this.createIndex).add("modifyIndex", (Object)this.modifyIndex).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBindingRule fromJson(Json json) {
        Builder builder = ImmutableBindingRule.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.description != null) {
            builder.setDescription(json.description);
        }
        if (json.authMethod != null) {
            builder.setAuthMethod(json.authMethod);
        }
        if (json.selector != null) {
            builder.setSelector(json.selector);
        }
        if (json.bindType != null) {
            builder.setBindType(json.bindType);
        }
        if (json.bindName != null) {
            builder.setBindName(json.bindName);
        }
        if (json.createIndex != null) {
            builder.setCreateIndex(json.createIndex);
        }
        if (json.modifyIndex != null) {
            builder.setModifyIndex(json.modifyIndex);
        }
        return builder.build();
    }

    public static ImmutableBindingRule copyOf(BindingRule instance) {
        if (instance instanceof ImmutableBindingRule) {
            return (ImmutableBindingRule)instance;
        }
        return ImmutableBindingRule.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BindingRule", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_AUTH_METHOD = 1L;
        private static final long INIT_BIT_BIND_TYPE = 2L;
        private static final long INIT_BIT_BIND_NAME = 4L;
        private long initBits = 7L;
        @Nullable
        private String id;
        @Nullable
        private String description;
        @Nullable
        private String authMethod;
        @Nullable
        private String selector;
        @Nullable
        private String bindType;
        @Nullable
        private String bindName;
        @Nullable
        private Long createIndex;
        @Nullable
        private Long modifyIndex;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BindingRule instance) {
            OptionalLong modifyIndexOptional;
            Optional<String> descriptionOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> idOptional = instance.getId();
            if (idOptional.isPresent()) {
                this.setId(idOptional);
            }
            if ((descriptionOptional = instance.getDescription()).isPresent()) {
                this.setDescription(descriptionOptional);
            }
            this.setAuthMethod(instance.getAuthMethod());
            Optional<String> selectorOptional = instance.getSelector();
            if (selectorOptional.isPresent()) {
                this.setSelector(selectorOptional);
            }
            this.setBindType(instance.getBindType());
            this.setBindName(instance.getBindName());
            OptionalLong createIndexOptional = instance.getCreateIndex();
            if (createIndexOptional.isPresent()) {
                this.setCreateIndex(createIndexOptional);
            }
            if ((modifyIndexOptional = instance.getModifyIndex()).isPresent()) {
                this.setModifyIndex(modifyIndexOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty(value="ID")
        @CanIgnoreReturnValue
        public final Builder setId(Optional<String> id) {
            this.id = id.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setDescription(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="Description")
        @CanIgnoreReturnValue
        public final Builder setDescription(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @JsonProperty(value="AuthMethod")
        @CanIgnoreReturnValue
        public final Builder setAuthMethod(String authMethod) {
            this.authMethod = Objects.requireNonNull(authMethod, "authMethod");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setSelector(String selector) {
            this.selector = Objects.requireNonNull(selector, "selector");
            return this;
        }

        @JsonProperty(value="Selector")
        @CanIgnoreReturnValue
        public final Builder setSelector(Optional<String> selector) {
            this.selector = selector.orElse(null);
            return this;
        }

        @JsonProperty(value="BindType")
        @CanIgnoreReturnValue
        public final Builder setBindType(String bindType) {
            this.bindType = Objects.requireNonNull(bindType, "bindType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="BindName")
        @CanIgnoreReturnValue
        public final Builder setBindName(String bindName) {
            this.bindName = Objects.requireNonNull(bindName, "bindName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setCreateIndex(long createIndex) {
            this.createIndex = createIndex;
            return this;
        }

        @JsonProperty(value="CreateIndex")
        @CanIgnoreReturnValue
        public final Builder setCreateIndex(OptionalLong createIndex) {
            this.createIndex = createIndex.isPresent() ? Long.valueOf(createIndex.getAsLong()) : null;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setModifyIndex(long modifyIndex) {
            this.modifyIndex = modifyIndex;
            return this;
        }

        @JsonProperty(value="ModifyIndex")
        @CanIgnoreReturnValue
        public final Builder setModifyIndex(OptionalLong modifyIndex) {
            this.modifyIndex = modifyIndex.isPresent() ? Long.valueOf(modifyIndex.getAsLong()) : null;
            return this;
        }

        public ImmutableBindingRule build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBindingRule(this.id, this.description, this.authMethod, this.selector, this.bindType, this.bindName, this.createIndex, this.modifyIndex);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("authMethod");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("bindType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("bindName");
            }
            return "Cannot build BindingRule, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BindingRule", generator="Immutables")
    static final class Json
    extends BindingRule {
        @Nullable
        Optional<String> id = Optional.empty();
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        String authMethod;
        @Nullable
        Optional<String> selector = Optional.empty();
        @Nullable
        String bindType;
        @Nullable
        String bindName;
        @Nullable
        OptionalLong createIndex = OptionalLong.empty();
        @Nullable
        OptionalLong modifyIndex = OptionalLong.empty();

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(Optional<String> id) {
            this.id = id;
        }

        @JsonProperty(value="Description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty(value="AuthMethod")
        public void setAuthMethod(String authMethod) {
            this.authMethod = authMethod;
        }

        @JsonProperty(value="Selector")
        public void setSelector(Optional<String> selector) {
            this.selector = selector;
        }

        @JsonProperty(value="BindType")
        public void setBindType(String bindType) {
            this.bindType = bindType;
        }

        @JsonProperty(value="BindName")
        public void setBindName(String bindName) {
            this.bindName = bindName;
        }

        @JsonProperty(value="CreateIndex")
        public void setCreateIndex(OptionalLong createIndex) {
            this.createIndex = createIndex;
        }

        @JsonProperty(value="ModifyIndex")
        public void setModifyIndex(OptionalLong modifyIndex) {
            this.modifyIndex = modifyIndex;
        }

        @Override
        public Optional<String> getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAuthMethod() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getSelector() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBindType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBindName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OptionalLong getCreateIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OptionalLong getModifyIndex() {
            throw new UnsupportedOperationException();
        }
    }
}

