/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.acl.Login;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Login", generator="Immutables")
@Immutable
public final class ImmutableLogin
extends Login {
    private final String authMethod;
    private final String bearerToken;
    @Nullable
    private final Map<String, String> meta;

    private ImmutableLogin(String authMethod, String bearerToken, @Nullable Map<String, String> meta) {
        this.authMethod = authMethod;
        this.bearerToken = bearerToken;
        this.meta = meta;
    }

    @Override
    @JsonProperty(value="AuthMethod")
    public String getAuthMethod() {
        return this.authMethod;
    }

    @Override
    @JsonProperty(value="BearerToken")
    public String getBearerToken() {
        return this.bearerToken;
    }

    @Override
    @JsonProperty(value="Meta")
    public Optional<Map<String, String>> getMeta() {
        return Optional.ofNullable(this.meta);
    }

    public final ImmutableLogin withAuthMethod(String value) {
        String newValue = Objects.requireNonNull(value, "authMethod");
        if (this.authMethod.equals(newValue)) {
            return this;
        }
        return new ImmutableLogin(newValue, this.bearerToken, this.meta);
    }

    public final ImmutableLogin withBearerToken(String value) {
        String newValue = Objects.requireNonNull(value, "bearerToken");
        if (this.bearerToken.equals(newValue)) {
            return this;
        }
        return new ImmutableLogin(this.authMethod, newValue, this.meta);
    }

    public final ImmutableLogin withMeta(Map<String, String> value) {
        Map<String, String> newValue = Objects.requireNonNull(value, "meta");
        if (this.meta == newValue) {
            return this;
        }
        return new ImmutableLogin(this.authMethod, this.bearerToken, newValue);
    }

    public final ImmutableLogin withMeta(Optional<? extends Map<String, String>> optional) {
        Map value = optional.orElse(null);
        if (this.meta == value) {
            return this;
        }
        return new ImmutableLogin(this.authMethod, this.bearerToken, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLogin && this.equalTo((ImmutableLogin)another);
    }

    private boolean equalTo(ImmutableLogin another) {
        return this.authMethod.equals(another.authMethod) && this.bearerToken.equals(another.bearerToken) && Objects.equals(this.meta, another.meta);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.authMethod.hashCode();
        h += (h << 5) + this.bearerToken.hashCode();
        h += (h << 5) + Objects.hashCode(this.meta);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Login").omitNullValues().add("authMethod", (Object)this.authMethod).add("bearerToken", (Object)this.bearerToken).add("meta", this.meta).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLogin fromJson(Json json) {
        Builder builder = ImmutableLogin.builder();
        if (json.authMethod != null) {
            builder.setAuthMethod(json.authMethod);
        }
        if (json.bearerToken != null) {
            builder.setBearerToken(json.bearerToken);
        }
        if (json.meta != null) {
            builder.setMeta(json.meta);
        }
        return builder.build();
    }

    public static ImmutableLogin copyOf(Login instance) {
        if (instance instanceof ImmutableLogin) {
            return (ImmutableLogin)instance;
        }
        return ImmutableLogin.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Login", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_AUTH_METHOD = 1L;
        private static final long INIT_BIT_BEARER_TOKEN = 2L;
        private long initBits = 3L;
        @Nullable
        private String authMethod;
        @Nullable
        private String bearerToken;
        @Nullable
        private Map<String, String> meta;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Login instance) {
            Objects.requireNonNull(instance, "instance");
            this.setAuthMethod(instance.getAuthMethod());
            this.setBearerToken(instance.getBearerToken());
            Optional<Map<String, String>> metaOptional = instance.getMeta();
            if (metaOptional.isPresent()) {
                this.setMeta(metaOptional);
            }
            return this;
        }

        @JsonProperty(value="AuthMethod")
        @CanIgnoreReturnValue
        public final Builder setAuthMethod(String authMethod) {
            this.authMethod = Objects.requireNonNull(authMethod, "authMethod");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="BearerToken")
        @CanIgnoreReturnValue
        public final Builder setBearerToken(String bearerToken) {
            this.bearerToken = Objects.requireNonNull(bearerToken, "bearerToken");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setMeta(Map<String, String> meta) {
            this.meta = Objects.requireNonNull(meta, "meta");
            return this;
        }

        @JsonProperty(value="Meta")
        @CanIgnoreReturnValue
        public final Builder setMeta(Optional<? extends Map<String, String>> meta) {
            this.meta = meta.orElse(null);
            return this;
        }

        public ImmutableLogin build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLogin(this.authMethod, this.bearerToken, this.meta);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("authMethod");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("bearerToken");
            }
            return "Cannot build Login, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Login", generator="Immutables")
    static final class Json
    extends Login {
        @Nullable
        String authMethod;
        @Nullable
        String bearerToken;
        @Nullable
        Optional<Map<String, String>> meta = Optional.empty();

        Json() {
        }

        @JsonProperty(value="AuthMethod")
        public void setAuthMethod(String authMethod) {
            this.authMethod = authMethod;
        }

        @JsonProperty(value="BearerToken")
        public void setBearerToken(String bearerToken) {
            this.bearerToken = bearerToken;
        }

        @JsonProperty(value="Meta")
        public void setMeta(Optional<Map<String, String>> meta) {
            this.meta = meta;
        }

        @Override
        public String getAuthMethod() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBearerToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Map<String, String>> getMeta() {
            throw new UnsupportedOperationException();
        }
    }
}

