/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.acl.Token;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Token.NodeIdentity", generator="Immutables")
@Immutable
public final class ImmutableNodeIdentity
extends Token.NodeIdentity {
    private final String name;
    private final String datacenter;

    private ImmutableNodeIdentity(String name, String datacenter) {
        this.name = name;
        this.datacenter = datacenter;
    }

    @Override
    @JsonProperty(value="NodeName")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Datacenter")
    public String getDatacenter() {
        return this.datacenter;
    }

    public final ImmutableNodeIdentity withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableNodeIdentity(newValue, this.datacenter);
    }

    public final ImmutableNodeIdentity withDatacenter(String value) {
        String newValue = Objects.requireNonNull(value, "datacenter");
        if (this.datacenter.equals(newValue)) {
            return this;
        }
        return new ImmutableNodeIdentity(this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeIdentity && this.equalTo((ImmutableNodeIdentity)another);
    }

    private boolean equalTo(ImmutableNodeIdentity another) {
        return this.name.equals(another.name) && this.datacenter.equals(another.datacenter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.datacenter.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NodeIdentity").omitNullValues().add("name", (Object)this.name).add("datacenter", (Object)this.datacenter).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNodeIdentity fromJson(Json json) {
        Builder builder = ImmutableNodeIdentity.builder();
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.datacenter != null) {
            builder.setDatacenter(json.datacenter);
        }
        return builder.build();
    }

    public static ImmutableNodeIdentity copyOf(Token.NodeIdentity instance) {
        if (instance instanceof ImmutableNodeIdentity) {
            return (ImmutableNodeIdentity)instance;
        }
        return ImmutableNodeIdentity.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Token.NodeIdentity", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_DATACENTER = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private String datacenter;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Token.NodeIdentity instance) {
            Objects.requireNonNull(instance, "instance");
            this.setName(instance.getName());
            this.setDatacenter(instance.getDatacenter());
            return this;
        }

        @JsonProperty(value="NodeName")
        @CanIgnoreReturnValue
        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Datacenter")
        @CanIgnoreReturnValue
        public final Builder setDatacenter(String datacenter) {
            this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableNodeIdentity build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeIdentity(this.name, this.datacenter);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("datacenter");
            }
            return "Cannot build NodeIdentity, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Token.NodeIdentity", generator="Immutables")
    static final class Json
    extends Token.NodeIdentity {
        @Nullable
        String name;
        @Nullable
        String datacenter;

        Json() {
        }

        @JsonProperty(value="NodeName")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Datacenter")
        public void setDatacenter(String datacenter) {
            this.datacenter = datacenter;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDatacenter() {
            throw new UnsupportedOperationException();
        }
    }
}

