/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.acl.Token;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Token.PolicyLink", generator="Immutables")
@Immutable
public final class ImmutablePolicyLink
extends Token.PolicyLink {
    @Nullable
    private final String id;
    @Nullable
    private final String name;

    private ImmutablePolicyLink(@Nullable String id, @Nullable String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    @JsonProperty(value="ID")
    public Optional<String> getId() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="Name")
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public final ImmutablePolicyLink withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutablePolicyLink(newValue, this.name);
    }

    public final ImmutablePolicyLink withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutablePolicyLink(value, this.name);
    }

    public final ImmutablePolicyLink withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (Objects.equals(this.name, newValue)) {
            return this;
        }
        return new ImmutablePolicyLink(this.id, newValue);
    }

    public final ImmutablePolicyLink withName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutablePolicyLink(this.id, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePolicyLink && this.equalTo((ImmutablePolicyLink)another);
    }

    private boolean equalTo(ImmutablePolicyLink another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.name, another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.name);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PolicyLink").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePolicyLink fromJson(Json json) {
        Builder builder = ImmutablePolicyLink.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        return builder.build();
    }

    public static ImmutablePolicyLink copyOf(Token.PolicyLink instance) {
        if (instance instanceof ImmutablePolicyLink) {
            return (ImmutablePolicyLink)instance;
        }
        return ImmutablePolicyLink.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Token.PolicyLink", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private String name;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Token.PolicyLink instance) {
            Optional<String> nameOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> idOptional = instance.getId();
            if (idOptional.isPresent()) {
                this.setId(idOptional);
            }
            if ((nameOptional = instance.getName()).isPresent()) {
                this.setName(nameOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty(value="ID")
        @CanIgnoreReturnValue
        public final Builder setId(Optional<String> id) {
            this.id = id.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        @JsonProperty(value="Name")
        @CanIgnoreReturnValue
        public final Builder setName(Optional<String> name) {
            this.name = name.orElse(null);
            return this;
        }

        public ImmutablePolicyLink build() {
            return new ImmutablePolicyLink(this.id, this.name);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Token.PolicyLink", generator="Immutables")
    static final class Json
    extends Token.PolicyLink {
        @Nullable
        Optional<String> id = Optional.empty();
        @Nullable
        Optional<String> name = Optional.empty();

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(Optional<String> id) {
            this.id = id;
        }

        @JsonProperty(value="Name")
        public void setName(Optional<String> name) {
            this.name = name;
        }

        @Override
        public Optional<String> getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getName() {
            throw new UnsupportedOperationException();
        }
    }
}

