/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.acl.BasePolicyResponse;
import com.orbitz.consul.model.acl.PolicyListResponse;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="PolicyListResponse", generator="Immutables")
@Immutable
public final class ImmutablePolicyListResponse
extends PolicyListResponse {
    private final String id;
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final List<String> datacenters;
    private final String hash;
    private final BigInteger createIndex;
    private final BigInteger modifyIndex;

    private ImmutablePolicyListResponse(String id, String name, @Nullable String description, @Nullable List<String> datacenters, String hash, BigInteger createIndex, BigInteger modifyIndex) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.datacenters = datacenters;
        this.hash = hash;
        this.createIndex = createIndex;
        this.modifyIndex = modifyIndex;
    }

    @Override
    @JsonProperty(value="ID")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="Datacenters")
    public Optional<List<String>> getDatacenters() {
        return Optional.ofNullable(this.datacenters);
    }

    @Override
    @JsonProperty(value="Hash")
    public String getHash() {
        return this.hash;
    }

    @Override
    @JsonProperty(value="CreateIndex")
    public BigInteger getCreateIndex() {
        return this.createIndex;
    }

    @Override
    @JsonProperty(value="ModifyIndex")
    public BigInteger getModifyIndex() {
        return this.modifyIndex;
    }

    public final ImmutablePolicyListResponse withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutablePolicyListResponse(newValue, this.name, this.description, this.datacenters, this.hash, this.createIndex, this.modifyIndex);
    }

    public final ImmutablePolicyListResponse withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutablePolicyListResponse(this.id, newValue, this.description, this.datacenters, this.hash, this.createIndex, this.modifyIndex);
    }

    public final ImmutablePolicyListResponse withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutablePolicyListResponse(this.id, this.name, newValue, this.datacenters, this.hash, this.createIndex, this.modifyIndex);
    }

    public final ImmutablePolicyListResponse withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutablePolicyListResponse(this.id, this.name, value, this.datacenters, this.hash, this.createIndex, this.modifyIndex);
    }

    public final ImmutablePolicyListResponse withDatacenters(List<String> value) {
        List<String> newValue = Objects.requireNonNull(value, "datacenters");
        if (this.datacenters == newValue) {
            return this;
        }
        return new ImmutablePolicyListResponse(this.id, this.name, this.description, newValue, this.hash, this.createIndex, this.modifyIndex);
    }

    public final ImmutablePolicyListResponse withDatacenters(Optional<? extends List<String>> optional) {
        List value = optional.orElse(null);
        if (this.datacenters == value) {
            return this;
        }
        return new ImmutablePolicyListResponse(this.id, this.name, this.description, value, this.hash, this.createIndex, this.modifyIndex);
    }

    public final ImmutablePolicyListResponse withHash(String value) {
        String newValue = Objects.requireNonNull(value, "hash");
        if (this.hash.equals(newValue)) {
            return this;
        }
        return new ImmutablePolicyListResponse(this.id, this.name, this.description, this.datacenters, newValue, this.createIndex, this.modifyIndex);
    }

    public final ImmutablePolicyListResponse withCreateIndex(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "createIndex");
        if (this.createIndex.equals(newValue)) {
            return this;
        }
        return new ImmutablePolicyListResponse(this.id, this.name, this.description, this.datacenters, this.hash, newValue, this.modifyIndex);
    }

    public final ImmutablePolicyListResponse withModifyIndex(BigInteger value) {
        BigInteger newValue = Objects.requireNonNull(value, "modifyIndex");
        if (this.modifyIndex.equals(newValue)) {
            return this;
        }
        return new ImmutablePolicyListResponse(this.id, this.name, this.description, this.datacenters, this.hash, this.createIndex, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePolicyListResponse && this.equalTo((ImmutablePolicyListResponse)another);
    }

    private boolean equalTo(ImmutablePolicyListResponse another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && Objects.equals(this.description, another.description) && Objects.equals(this.datacenters, another.datacenters) && this.hash.equals(another.hash) && this.createIndex.equals(another.createIndex) && this.modifyIndex.equals(another.modifyIndex);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.datacenters);
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + this.createIndex.hashCode();
        h += (h << 5) + this.modifyIndex.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PolicyListResponse").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("description", (Object)this.description).add("datacenters", this.datacenters).add("hash", (Object)this.hash).add("createIndex", (Object)this.createIndex).add("modifyIndex", (Object)this.modifyIndex).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePolicyListResponse fromJson(Json json) {
        Builder builder = ImmutablePolicyListResponse.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.description != null) {
            builder.setDescription(json.description);
        }
        if (json.datacenters != null) {
            builder.setDatacenters(json.datacenters);
        }
        if (json.hash != null) {
            builder.setHash(json.hash);
        }
        if (json.createIndex != null) {
            builder.setCreateIndex(json.createIndex);
        }
        if (json.modifyIndex != null) {
            builder.setModifyIndex(json.modifyIndex);
        }
        return builder.build();
    }

    public static ImmutablePolicyListResponse copyOf(PolicyListResponse instance) {
        if (instance instanceof ImmutablePolicyListResponse) {
            return (ImmutablePolicyListResponse)instance;
        }
        return ImmutablePolicyListResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PolicyListResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_HASH = 4L;
        private static final long INIT_BIT_CREATE_INDEX = 8L;
        private static final long INIT_BIT_MODIFY_INDEX = 16L;
        private long initBits = 31L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private List<String> datacenters;
        @Nullable
        private String hash;
        @Nullable
        private BigInteger createIndex;
        @Nullable
        private BigInteger modifyIndex;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BasePolicyResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PolicyListResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof BasePolicyResponse) {
                BasePolicyResponse instance = (BasePolicyResponse)object;
                Optional<List<String>> datacentersOptional = instance.getDatacenters();
                if (datacentersOptional.isPresent()) {
                    this.setDatacenters(datacentersOptional);
                }
                this.setModifyIndex(instance.getModifyIndex());
                this.setName(instance.getName());
                Optional<String> descriptionOptional = instance.getDescription();
                if (descriptionOptional.isPresent()) {
                    this.setDescription(descriptionOptional);
                }
                this.setId(instance.getId());
                this.setCreateIndex(instance.getCreateIndex());
                this.setHash(instance.getHash());
            }
        }

        @JsonProperty(value="ID")
        @CanIgnoreReturnValue
        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Name")
        @CanIgnoreReturnValue
        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setDescription(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="Description")
        @CanIgnoreReturnValue
        public final Builder setDescription(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setDatacenters(List<String> datacenters) {
            this.datacenters = Objects.requireNonNull(datacenters, "datacenters");
            return this;
        }

        @JsonProperty(value="Datacenters")
        @CanIgnoreReturnValue
        public final Builder setDatacenters(Optional<? extends List<String>> datacenters) {
            this.datacenters = datacenters.orElse(null);
            return this;
        }

        @JsonProperty(value="Hash")
        @CanIgnoreReturnValue
        public final Builder setHash(String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="CreateIndex")
        @CanIgnoreReturnValue
        public final Builder setCreateIndex(BigInteger createIndex) {
            this.createIndex = Objects.requireNonNull(createIndex, "createIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="ModifyIndex")
        @CanIgnoreReturnValue
        public final Builder setModifyIndex(BigInteger modifyIndex) {
            this.modifyIndex = Objects.requireNonNull(modifyIndex, "modifyIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutablePolicyListResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePolicyListResponse(this.id, this.name, this.description, this.datacenters, this.hash, this.createIndex, this.modifyIndex);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("createIndex");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("modifyIndex");
            }
            return "Cannot build PolicyListResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PolicyListResponse", generator="Immutables")
    static final class Json
    extends PolicyListResponse {
        @Nullable
        String id;
        @Nullable
        String name;
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        Optional<List<String>> datacenters = Optional.empty();
        @Nullable
        String hash;
        @Nullable
        BigInteger createIndex;
        @Nullable
        BigInteger modifyIndex;

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty(value="Datacenters")
        public void setDatacenters(Optional<List<String>> datacenters) {
            this.datacenters = datacenters;
        }

        @JsonProperty(value="Hash")
        public void setHash(String hash) {
            this.hash = hash;
        }

        @JsonProperty(value="CreateIndex")
        public void setCreateIndex(BigInteger createIndex) {
            this.createIndex = createIndex;
        }

        @JsonProperty(value="ModifyIndex")
        public void setModifyIndex(BigInteger modifyIndex) {
            this.modifyIndex = modifyIndex;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<String>> getDatacenters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger getCreateIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigInteger getModifyIndex() {
            throw new UnsupportedOperationException();
        }
    }
}

