/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.acl.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Token.ServiceIdentity", generator="Immutables")
@Immutable
public final class ImmutableServiceIdentity
extends Token.ServiceIdentity {
    private final String name;
    private final ImmutableList<String> datacenters;

    private ImmutableServiceIdentity(String name, ImmutableList<String> datacenters) {
        this.name = name;
        this.datacenters = datacenters;
    }

    @Override
    @JsonProperty(value="ServiceName")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="Datacenters")
    @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
    public ImmutableList<String> getDatacenters() {
        return this.datacenters;
    }

    public final ImmutableServiceIdentity withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableServiceIdentity(newValue, this.datacenters);
    }

    public final ImmutableServiceIdentity withDatacenters(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableServiceIdentity(this.name, (ImmutableList<String>)newValue);
    }

    public final ImmutableServiceIdentity withDatacenters(Iterable<String> elements) {
        if (this.datacenters == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableServiceIdentity(this.name, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceIdentity && this.equalTo((ImmutableServiceIdentity)another);
    }

    private boolean equalTo(ImmutableServiceIdentity another) {
        return this.name.equals(another.name) && this.datacenters.equals(another.datacenters);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.datacenters.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ServiceIdentity").omitNullValues().add("name", (Object)this.name).add("datacenters", this.datacenters).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableServiceIdentity fromJson(Json json) {
        Builder builder = ImmutableServiceIdentity.builder();
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.datacenters != null) {
            builder.addAllDatacenters(json.datacenters);
        }
        return builder.build();
    }

    public static ImmutableServiceIdentity copyOf(Token.ServiceIdentity instance) {
        if (instance instanceof ImmutableServiceIdentity) {
            return (ImmutableServiceIdentity)instance;
        }
        return ImmutableServiceIdentity.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Token.ServiceIdentity", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        private ImmutableList.Builder<String> datacenters = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Token.ServiceIdentity instance) {
            Objects.requireNonNull(instance, "instance");
            this.setName(instance.getName());
            this.addAllDatacenters(instance.getDatacenters());
            return this;
        }

        @JsonProperty(value="ServiceName")
        @CanIgnoreReturnValue
        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDatacenters(String element) {
            this.datacenters.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDatacenters(String ... elements) {
            this.datacenters.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="Datacenters")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        @CanIgnoreReturnValue
        public final Builder setDatacenters(Iterable<String> elements) {
            this.datacenters = ImmutableList.builder();
            return this.addAllDatacenters(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDatacenters(Iterable<String> elements) {
            this.datacenters.addAll(elements);
            return this;
        }

        public ImmutableServiceIdentity build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServiceIdentity(this.name, this.datacenters.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build ServiceIdentity, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Token.ServiceIdentity", generator="Immutables")
    static final class Json
    extends Token.ServiceIdentity {
        @Nullable
        String name;
        @Nullable
        List<String> datacenters = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="ServiceName")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Datacenters")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        public void setDatacenters(List<String> datacenters) {
            this.datacenters = datacenters;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getDatacenters() {
            throw new UnsupportedOperationException();
        }
    }
}

