/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import com.orbitz.consul.model.acl.ImmutableRole;
import com.orbitz.consul.model.acl.ImmutableRoleNodeIdentity;
import com.orbitz.consul.model.acl.ImmutableRolePolicyLink;
import com.orbitz.consul.model.acl.ImmutableRoleServiceIdentity;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableRole.class)
@JsonDeserialize(as=ImmutableRole.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@Value.Immutable
public abstract class Role {
    @JsonProperty(value="Name")
    public abstract String getName();

    @JsonProperty(value="ID")
    public abstract Optional<String> getId();

    @JsonProperty(value="Description")
    public abstract Optional<String> getDescription();

    @JsonProperty(value="Policies")
    @JsonDeserialize(as=ImmutableList.class, contentAs=RolePolicyLink.class)
    public abstract List<RolePolicyLink> getPolicies();

    @JsonProperty(value="ServiceIdentities")
    @JsonDeserialize(as=ImmutableList.class, contentAs=RoleServiceIdentity.class)
    public abstract List<RoleServiceIdentity> getServiceIdentities();

    @JsonProperty(value="NodeIdentities")
    @JsonDeserialize(as=ImmutableList.class, contentAs=RoleNodeIdentity.class)
    public abstract List<RoleNodeIdentity> getNodeIdentities();

    @JsonProperty(value="Namespace")
    public abstract Optional<String> getNamespace();

    @JsonSerialize(as=ImmutableRoleNodeIdentity.class)
    @JsonDeserialize(as=ImmutableRoleNodeIdentity.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Value.Immutable
    public static abstract class RoleNodeIdentity {
        @JsonProperty(value="NodeName")
        public abstract String getName();

        @JsonProperty(value="Datacenter")
        public abstract String getDatacenter();
    }

    @JsonSerialize(as=ImmutableRoleServiceIdentity.class)
    @JsonDeserialize(as=ImmutableRoleServiceIdentity.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Value.Immutable
    public static abstract class RoleServiceIdentity {
        @JsonProperty(value="ServiceName")
        public abstract String getName();

        @JsonProperty(value="Datacenters")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        public abstract List<String> getDatacenters();
    }

    @JsonSerialize(as=ImmutableRolePolicyLink.class)
    @JsonDeserialize(as=ImmutableRolePolicyLink.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Value.Immutable
    public static abstract class RolePolicyLink {
        @JsonProperty(value="ID")
        public abstract Optional<String> getId();

        @JsonProperty(value="Name")
        public abstract Optional<String> getName();
    }
}

